/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.fact;

import java.util.ArrayList;
import pcgen.base.util.Indirect;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.fact.FactInfo;
import pcgen.cdom.enumeration.FactKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FactParser<T extends CDOMObject, F>
extends AbstractNonEmptyToken<T>
implements CDOMSecondaryToken<T> {
    private final FactInfo<T, F> def;

    public FactParser(FactInfo<T, F> fi) {
        if (fi == null) {
            throw new IllegalArgumentException("Fact Info cannot be null");
        }
        this.def = fi;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, T obj, String value) {
        FactKey<F> fk = this.def.getFactKey();
        if (".CLEAR".equals(value)) {
            context.getObjectContext().remove((CDOMObject)obj, fk);
        } else {
            Indirect indirect = this.def.getFormatManager().convertIndirect(value);
            context.getObjectContext().put((CDOMObject)obj, fk, indirect);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public Class<T> getTokenClass() {
        return this.def.getUsableLocation();
    }

    @Override
    public String getTokenName() {
        return this.def.getFactName();
    }

    @Override
    public String getParentToken() {
        return "FACT";
    }

    @Override
    public String[] unparse(LoadContext context, T obj) {
        Indirect<F> fact;
        FactKey<F> fk = this.def.getFactKey();
        boolean removed = context.getObjectContext().wasRemoved((CDOMObject)obj, fk);
        ArrayList<String> results = new ArrayList<String>(2);
        if (removed) {
            results.add(".CLEAR");
        }
        if ((fact = context.getObjectContext().getFact((CDOMObject)obj, fk)) != null) {
            results.add(fact.getUnconverted());
        }
        return results.toArray(new String[results.size()]);
    }
}

