/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.ArrayList;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class TargetareaToken
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "TARGETAREA";
    }

    public ParseResult parseToken(LoadContext context, Spell spell, String value) {
        if (value == null || value.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " arguments may not be empty", context);
        }
        if (".CLEAR".equals(value)) {
            context.getObjectContext().remove((CDOMObject)spell, StringKey.TARGET_AREA);
        } else {
            if (!StringUtil.hasBalancedParens((String)value)) {
                return new ParseResult.Fail("Unbalanced parentheses in " + this.getTokenName() + " '" + value + "' used in spell " + spell, context);
            }
            context.getObjectContext().put((CDOMObject)spell, StringKey.TARGET_AREA, value);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        String target = context.getObjectContext().getString((CDOMObject)spell, StringKey.TARGET_AREA);
        boolean globalClear = context.getObjectContext().wasRemoved((CDOMObject)spell, StringKey.TARGET_AREA);
        ArrayList<String> list = new ArrayList<String>();
        if (globalClear) {
            list.add(".CLEAR");
        }
        if (target != null) {
            list.add(target);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

