/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class LangbonusToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Language> LANGUAGE_CLASS = Language.class;

    public String getTokenName() {
        return "LANGBONUS";
    }

    protected char separator() {
        return ',';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass cl, String value) {
        StringTokenizer tok = new StringTokenizer(value, ",");
        boolean foundAny = false;
        boolean foundOther = false;
        boolean firstToken = true;
        while (tok.hasMoreTokens()) {
            Object lang;
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEAR must be the first argument", context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), (CDOMObject)cl, Language.STARTING_LIST);
            } else if (tokText.startsWith(".CLEAR.")) {
                String clearText = tokText.substring(7);
                lang = "ALL".equals(clearText) ? context.getReferenceContext().getCDOMAllReference(LANGUAGE_CLASS) : TokenUtilities.getTypeOrPrimitive((LoadContext)context, LANGUAGE_CLASS, (String)clearText);
                if (lang == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName() + ": " + value + " had an invalid .CLEAR. reference: " + clearText, context);
                }
                context.getListContext().removeFromList(this.getTokenName(), (CDOMObject)cl, Language.STARTING_LIST, (CDOMReference)lang);
            } else {
                if ("ALL".equals(tokText)) {
                    foundAny = true;
                    lang = context.getReferenceContext().getCDOMAllReference(LANGUAGE_CLASS);
                } else {
                    foundOther = true;
                    lang = TokenUtilities.getTypeOrPrimitive((LoadContext)context, LANGUAGE_CLASS, (String)tokText);
                }
                if (lang == null) {
                    return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName() + ": " + value + " had an invalid reference: " + tokText, context);
                }
                context.getListContext().addToList(this.getTokenName(), (CDOMObject)cl, Language.STARTING_LIST, (CDOMReference)lang);
            }
            firstToken = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcl) {
        Collection addedItems;
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), (CDOMObject)pcl, Language.STARTING_LIST);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)",.CLEAR."));
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((addedItems = changes.getAdded()) != null && !addedItems.isEmpty()) {
            list.add(ReferenceUtilities.joinLstFormat((Collection)addedItems, (String)","));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

