/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.InPlaceClasspathBuilder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ServiceScope(value={Scope.UserHome.class})
public class DefaultClasspathBuilder
implements ClasspathBuilder {
    private final TemporaryFileProvider temporaryFileProvider;
    private final ClasspathBuilder inPlaceBuilder;

    @Inject
    public DefaultClasspathBuilder(TemporaryFileProvider temporaryFileProvider) {
        this.temporaryFileProvider = temporaryFileProvider;
        this.inPlaceBuilder = new InPlaceClasspathBuilder();
    }

    @Override
    public void jar(File jarFile, ClasspathBuilder.Action action) {
        try {
            this.buildJar(jarFile, action);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to create Jar file %s.", jarFile), (Throwable)e);
        }
    }

    @Override
    public void directory(File destinationDir, ClasspathBuilder.Action action) {
        try {
            this.buildDirectory(destinationDir, action);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to create directory %s.", destinationDir), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(File jarFile, ClasspathBuilder.Action action) throws IOException {
        File parentDir = jarFile.getParentFile();
        File tmpFile = this.temporaryFileProvider.createTemporaryFile(jarFile.getName(), ".tmp", new String[0]);
        try {
            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
            this.inPlaceBuilder.jar(tmpFile, action);
            Files.move(tmpFile.toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDirectory(File destinationDir, ClasspathBuilder.Action action) throws IOException {
        File parentDir = destinationDir.getParentFile();
        File tmpDir = this.temporaryFileProvider.createTemporaryDirectory(destinationDir.getName(), ".tmp", new String[0]);
        try {
            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
            this.inPlaceBuilder.directory(tmpDir, action);
            if (destinationDir.exists()) {
                GFileUtils.forceDelete((File)destinationDir);
            }
            GFileUtils.moveDirectory((File)tmpDir, (File)destinationDir);
        }
        finally {
            if (tmpDir.exists()) {
                GFileUtils.deleteDirectory((File)tmpDir);
            }
        }
    }
}

