/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.search;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.search.Completion;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class CompletionUtils {
    private CompletionUtils() {
    }

    public static String commonPrefix(List<? extends Completion> completions) {
        Preconditions.checkNotNull(completions, "The %s must not be null.", "completions");
        String currentPrefix = completions.get(0).getReplacementText();
        Iterator<? extends Completion> i = completions.iterator();
        i.next();
        while (i.hasNext()) {
            Completion completion = i.next();
            currentPrefix = CompletionUtils.commonPrefix(currentPrefix, completion.getReplacementText());
        }
        return currentPrefix;
    }

    public static String commonPrefix(String str1, String str2) {
        int i;
        Preconditions.checkNotNull(str1, "The %s must not be null.", "str1");
        Preconditions.checkNotNull(str2, "The %s must not be null.", "str2");
        int length1 = str1.length();
        int length2 = str2.length();
        for (i = 0; i < length1 && i < length2 && str1.charAt(i) == str2.charAt(i); ++i) {
        }
        return str1.substring(0, i);
    }

    public static String commonPrefixIgnoreCase(String str1, String str2) {
        int i;
        Preconditions.checkNotNull(str1, "The %s must not be null.", "str1");
        Preconditions.checkNotNull(str2, "The %s must not be null.", "str2");
        int length1 = str1.length();
        int length2 = str2.length();
        for (i = 0; i < length1 && i < length2 && Character.toLowerCase(str1.charAt(i)) == Character.toLowerCase(str2.charAt(i)); ++i) {
        }
        return str1.substring(0, i);
    }

    public static void replaceText(Document document, String text) {
        CompletionUtils.replaceText(document, 0, document.getLength(), text);
    }

    public static void replaceText(Document document, int offset, int length, String text) {
        if (length == 0 && (text == null || text.length() == 0)) {
            return;
        }
        try {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).replace(offset, length, text, null);
            } else {
                if (length > 0) {
                    document.remove(offset, length);
                }
                if (text != null && text.length() > 0) {
                    document.insertString(offset, text, null);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

