/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.ChartUtils;
import com.jgoodies.common.swing.internal.RenderingUtils;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class ChartLabel {
    private static final double DEGREE_TO_RADIAN = Math.PI / 180;
    private static final int LABEL_TO_PIE_GAP = 5;
    private final String label;
    private final String sizeStr;
    private final int startAngle;
    private final int stopAngle;
    private final boolean isLeftAligned;
    private Rectangle bounds;
    private boolean showSize;

    ChartLabel(String label, String sizeStr, int startAngle, int stopAngle, boolean isLeftAligned) {
        this.label = label;
        this.sizeStr = sizeStr;
        this.startAngle = startAngle;
        this.stopAngle = stopAngle;
        this.isLeftAligned = isLeftAligned;
    }

    private boolean computeShowSize(int groupSize, int radius, int labelAndSizeHeight) {
        float h2;
        if (null == this.sizeStr) {
            return false;
        }
        if (groupSize == 1) {
            return true;
        }
        if (this.stopAngle - this.startAngle > 30) {
            return true;
        }
        double radian1 = Math.PI / 180 * (double)this.startAngle;
        double radian2 = Math.PI / 180 * (double)this.stopAngle;
        int pad = 8;
        float h1 = (float)Math.cos(radian1) * (float)radius;
        float availableHeight = Math.abs(h1 - (h2 = (float)Math.cos(radian2) * (float)radius));
        return (float)(labelAndSizeHeight + pad) < availableHeight;
    }

    void initializeFrom(FontMetrics fm, int width, int height, int radius, int groupSize) {
        int availableWidth;
        int xCenter = width / 2;
        int yCenter = height / 2;
        int angle = (this.startAngle + this.stopAngle) / 2;
        double radian = Math.PI / 180 * (double)angle;
        float sin = (float)Math.sin(radian);
        float cos = (float)Math.cos(radian);
        double distance = radius + 5;
        int x = xCenter + (int)((double)sin * distance);
        int y = yCenter - (int)((double)cos * distance);
        int labelHeight = fm.getHeight();
        int labelAscent = fm.getAscent();
        this.showSize = this.computeShowSize(groupSize, radius, 2 * labelAscent);
        int totalHeight = this.showSize ? 2 * labelAscent : labelHeight;
        if (x < xCenter) {
            availableWidth = x;
            x = Math.max(0, x - xCenter);
        } else {
            availableWidth = width - x - 1;
        }
        if ((float)y < (float)yCenter - (float)radius * 0.9f) {
            y -= totalHeight;
        } else if ((float)y < (float)yCenter + (float)radius * 0.9f) {
            y -= totalHeight / 2;
            int shift = Math.round(Math.abs(cos) * (float)totalHeight / 2.0f);
            availableWidth -= shift;
            if (x > xCenter) {
                x += shift;
            }
        } else {
            y += 0;
        }
        this.bounds = new Rectangle(x, y, availableWidth, totalHeight);
    }

    void paint(JComponent c, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        String clippedText = ChartUtils.clipText(this.label, fm, this.bounds.width);
        int labelX = this.isLeftAligned ? 0 : this.bounds.width - fm.stringWidth(clippedText);
        int ascent = fm.getAscent();
        g.translate(this.bounds.x, this.bounds.y);
        RenderingUtils.drawString(c, g, clippedText, labelX, ascent);
        if (this.showSize) {
            String clippedSizeStr = ChartUtils.clipText(this.sizeStr, fm, this.bounds.width);
            int sizeX = this.isLeftAligned ? 0 : this.bounds.width - fm.stringWidth(clippedSizeStr);
            RenderingUtils.drawString(c, g, clippedSizeStr, sizeX, ascent + 1 + ascent);
        }
        g.translate(-this.bounds.x, -this.bounds.y);
    }
}

