/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.basic;

import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jrm.ui.basic.ResultColUpdater;
import jrm.ui.basic.SDRTableModel;

public class JSDRDropTable
extends JTable
implements DropTargetListener,
ResultColUpdater {
    private final Color color;
    private SDRTableModel model;
    private final AddDelCallBack addCallBack;

    public JSDRDropTable(final SDRTableModel model, AddDelCallBack callback) {
        super(model);
        this.setCellSelectionEnabled(true);
        this.addCallBack = callback;
        this.model = model;
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellRenderer(model.getCellRenderers()[i]);
        }
        this.color = this.getBackground();
        new DropTarget(this, this);
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() >= 0 && model.getColumnClass(e.getColumn()).equals(Boolean.class) && e.getType() == 0) {
                    JSDRDropTable.this.addCallBack.call(model.getData());
                }
            }
        });
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (this.isEnabled() && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            Point point = dtde.getLocation();
            int old_row = this.model.getCurrentRow();
            int old_col = this.model.getCurrentCol();
            int row = this.model.setCurrentRow(this.rowAtPoint(point));
            int col = this.model.setCurrentCol(this.columnAtPoint(point));
            if (old_col != col || old_row != row) {
                if (row == -1) {
                    this.model.setCurrentRow(-1);
                    this.setBackground(Color.decode("#DDFFDD"));
                    this.model.fireTableChanged(new TableModelEvent(this.model));
                } else {
                    this.setBackground(Color.white);
                    this.model.fireTableChanged(new TableModelEvent(this.model, row, row, col));
                    if (old_row != -1) {
                        this.model.fireTableChanged(new TableModelEvent(this.model, old_row, old_row, old_col));
                    }
                }
            }
            dtde.acceptDrag(1);
        } else {
            this.model.setCurrentRow(-1);
            this.setBackground(Color.decode("#FFDDDD"));
            this.model.fireTableChanged(new TableModelEvent(this.model));
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.model.setCurrentRow(-1);
        this.setBackground(this.color);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.model.setCurrentRow(-1);
        this.setBackground(this.color);
        this.model.fireTableChanged(new TableModelEvent(this.model));
        try {
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                Point point = dtde.getLocation();
                int row = this.rowAtPoint(point);
                int col = this.columnAtPoint(point);
                List files = ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().filter(f -> {
                    FileFilter filter = null;
                    if (col == 1) {
                        filter = this.model.getDstFilter();
                    } else if (col == 0) {
                        filter = this.model.getSrcFilter();
                    }
                    if (filter != null) {
                        return filter.accept((File)f);
                    }
                    return true;
                }).collect(Collectors.toList());
                if (files.size() > 0) {
                    int start_size = this.model.getData().size();
                    for (int i = 0; i < files.size(); ++i) {
                        SDRTableModel.SrcDstResult line;
                        File file = (File)files.get(i);
                        if (row == -1 || row + i >= this.model.getData().size()) {
                            line = new SDRTableModel.SrcDstResult();
                            this.model.getData().add(line);
                        } else {
                            line = this.model.getData().get(row + i);
                        }
                        if (col == 1) {
                            line.dst = file;
                            continue;
                        }
                        line.src = file;
                    }
                    if (row != -1) {
                        this.model.fireTableChanged(new TableModelEvent(this.model, row, start_size - 1, col));
                    }
                    if (start_size != this.model.getData().size()) {
                        this.model.fireTableChanged(new TableModelEvent(this.model, start_size, this.model.getData().size() - 1, -1, 1));
                    }
                    this.addCallBack.call(this.model.getData());
                    dtde.getDropTargetContext().dropComplete(true);
                } else {
                    dtde.getDropTargetContext().dropComplete(false);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException e) {
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public SDRTableModel getSDRModel() {
        return this.model;
    }

    @Override
    public void updateResult(int row, String result) {
        this.model.getData().get((int)row).result = result;
        this.model.fireTableChanged(new TableModelEvent(this.model, row, row, 2));
        this.addCallBack.call(this.model.getData());
    }

    public void del(List<SDRTableModel.SrcDstResult> sdrl) {
        for (SDRTableModel.SrcDstResult sdr : sdrl) {
            this.model.getData().remove(sdr);
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.addCallBack.call(this.model.getData());
    }

    public List<SDRTableModel.SrcDstResult> getSelectedValuesList() {
        int[] rows = this.getSelectedRows();
        ArrayList<SDRTableModel.SrcDstResult> list = new ArrayList<SDRTableModel.SrcDstResult>();
        for (int row : rows) {
            list.add(this.model.getData().get(row));
        }
        return list;
    }

    @Override
    public void clearResults() {
        this.model.getData().forEach(r -> {
            r.result = "";
        });
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, this.model.getRowCount() - 1, 2));
        this.addCallBack.call(this.model.getData());
    }

    @FunctionalInterface
    public static interface AddDelCallBack {
        public void call(List<SDRTableModel.SrcDstResult> var1);
    }
}

