/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ModuleComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

@NotThreadSafe
public class ComponentSelectorSerializer
extends AbstractSerializer<ComponentSelector> {
    private final OptimizingAttributeContainerSerializer attributeContainerSerializer;
    private final BuildIdentifierSerializer buildIdentifierSerializer;
    private final CapabilitySelectorSerializer capabilitySelectorSerializer;
    private final ModuleComponentSelectorSerializer moduleComponentSelectorSerializer;

    public ComponentSelectorSerializer(AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer) {
        this.attributeContainerSerializer = new OptimizingAttributeContainerSerializer(attributeContainerSerializer);
        this.buildIdentifierSerializer = new BuildIdentifierSerializer();
        this.capabilitySelectorSerializer = capabilitySelectorSerializer;
        this.moduleComponentSelectorSerializer = new ModuleComponentSelectorSerializer(this.attributeContainerSerializer, capabilitySelectorSerializer);
    }

    void reset() {
        this.attributeContainerSerializer.reset();
    }

    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            String projectName = decoder.readString();
            ProjectIdentity projectId = new ProjectIdentity(buildIdentifier, Path.ROOT, Path.ROOT, projectName);
            ImmutableAttributes attributes = this.readAttributes(decoder);
            return new DefaultProjectComponentSelector(projectId, attributes, this.readCapabilitySelectors(decoder));
        }
        if (Implementation.ROOT_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path projectPath = Path.path((String)decoder.readString());
            ProjectIdentity projectId = new ProjectIdentity(buildIdentifier, projectPath, projectPath, projectPath.getName());
            ImmutableAttributes attributes = this.readAttributes(decoder);
            return new DefaultProjectComponentSelector(projectId, attributes, this.readCapabilitySelectors(decoder));
        }
        if (Implementation.OTHER_BUILD_ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path((String)decoder.readString());
            String projectName = decoder.readString();
            ProjectIdentity projectId = new ProjectIdentity(buildIdentifier, identityPath, Path.ROOT, projectName);
            ImmutableAttributes attributes = this.readAttributes(decoder);
            return new DefaultProjectComponentSelector(projectId, attributes, this.readCapabilitySelectors(decoder));
        }
        if (Implementation.OTHER_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path((String)decoder.readString());
            Path projectPath = Path.path((String)decoder.readString());
            ProjectIdentity projectId = new ProjectIdentity(buildIdentifier, identityPath, projectPath, projectPath.getName());
            ImmutableAttributes attributes = this.readAttributes(decoder);
            return new DefaultProjectComponentSelector(projectId, attributes, this.readCapabilitySelectors(decoder));
        }
        if (Implementation.MODULE.getId() == id) {
            return this.moduleComponentSelectorSerializer.read(decoder);
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryComponentSelector(decoder.readString(), decoder.readNullableString(), decoder.readNullableString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    private ImmutableAttributes readAttributes(Decoder decoder) throws IOException {
        return this.attributeContainerSerializer.read(decoder);
    }

    private ImmutableSet<CapabilitySelector> readCapabilitySelectors(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)this.capabilitySelectorSerializer.read(decoder));
        }
        return builder.build();
    }

    private void writeCapabilitySelectors(Encoder encoder, Set<CapabilitySelector> capabilitySelectors) throws IOException {
        encoder.writeSmallInt(capabilitySelectors.size());
        for (CapabilitySelector capabilitySelector : capabilitySelectors) {
            this.capabilitySelectorSerializer.write(encoder, capabilitySelector);
        }
    }

    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            this.moduleComponentSelectorSerializer.write(encoder, (ModuleComponentSelector)value);
        } else if (implementation == Implementation.ROOT_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getProjectIdentity().getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectIdentity().getProjectName());
            this.writeAttributes(encoder, (AttributeContainer)projectComponentSelector.getAttributes());
            this.writeCapabilitySelectors(encoder, (Set<CapabilitySelector>)projectComponentSelector.getCapabilitySelectors());
        } else if (implementation == Implementation.ROOT_BUILD_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getProjectIdentity().getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectPath());
            this.writeAttributes(encoder, (AttributeContainer)projectComponentSelector.getAttributes());
            this.writeCapabilitySelectors(encoder, (Set<CapabilitySelector>)projectComponentSelector.getCapabilitySelectors());
        } else if (implementation == Implementation.OTHER_BUILD_ROOT_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getProjectIdentity().getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getIdentityPath().getPath());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectIdentity().getProjectName());
            this.writeAttributes(encoder, (AttributeContainer)projectComponentSelector.getAttributes());
            this.writeCapabilitySelectors(encoder, (Set<CapabilitySelector>)projectComponentSelector.getCapabilitySelectors());
        } else if (implementation == Implementation.OTHER_BUILD_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getProjectIdentity().getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getIdentityPath().getPath());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectPath());
            this.writeAttributes(encoder, (AttributeContainer)projectComponentSelector.getAttributes());
            this.writeCapabilitySelectors(encoder, (Set<CapabilitySelector>)projectComponentSelector.getCapabilitySelectors());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)value;
            encoder.writeString((CharSequence)libraryComponentSelector.getProjectPath());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getLibraryName());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private void writeAttributes(Encoder encoder, AttributeContainer attributes) throws IOException {
        this.attributeContainerSerializer.write(encoder, attributes);
    }

    private Implementation resolveImplementation(ComponentSelector value) {
        Implementation implementation;
        if (value instanceof DefaultModuleComponentSelector) {
            implementation = Implementation.MODULE;
        } else {
            if (value instanceof DefaultProjectComponentSelector) {
                DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
                boolean isARootProject = projectComponentSelector.getProjectIdentity().getProjectPath().equals((Object)Path.ROOT);
                if (projectComponentSelector.getIdentityPath().equals((Object)Path.ROOT) && isARootProject) {
                    return Implementation.ROOT_PROJECT;
                }
                if (isARootProject) {
                    return Implementation.OTHER_BUILD_ROOT_PROJECT;
                }
                Path projectPath = projectComponentSelector.getProjectIdentity().getProjectPath();
                String projectName = projectComponentSelector.getProjectIdentity().getProjectName();
                if (!projectName.equals(projectPath.getName())) {
                    throw new IllegalArgumentException("Unexpected name for project " + projectPath + ". Expected: " + projectPath.getName() + ", found: " + projectName);
                }
                if (projectComponentSelector.getIdentityPath().equals((Object)projectPath)) {
                    return Implementation.ROOT_BUILD_PROJECT;
                }
                return Implementation.OTHER_BUILD_PROJECT;
            }
            if (value instanceof DefaultLibraryComponentSelector) {
                implementation = Implementation.LIBRARY;
            } else {
                throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
            }
        }
        return implementation;
    }

    private static class OptimizingAttributeContainerSerializer
    implements AttributeContainerSerializer {
        private final Map<AttributeContainer, Integer> writeIndex = new IdentityHashMap<AttributeContainer, Integer>();
        private final List<ImmutableAttributes> readIndex = new ArrayList<ImmutableAttributes>();
        private final AttributeContainerSerializer delegate;

        private OptimizingAttributeContainerSerializer(AttributeContainerSerializer delegate) {
            this.delegate = delegate;
        }

        public void reset() {
            this.writeIndex.clear();
            this.readIndex.clear();
        }

        @Override
        public ImmutableAttributes read(Decoder decoder) throws IOException {
            ImmutableAttributes attributes;
            boolean empty = decoder.readBoolean();
            if (empty) {
                return ImmutableAttributes.EMPTY;
            }
            int idx = decoder.readSmallInt();
            if (idx == this.readIndex.size()) {
                attributes = this.delegate.read(decoder);
                this.readIndex.add(attributes);
            } else {
                attributes = this.readIndex.get(idx);
            }
            return attributes;
        }

        @Override
        public void write(Encoder encoder, AttributeContainer container) throws IOException {
            if (container.isEmpty()) {
                encoder.writeBoolean(true);
                return;
            }
            encoder.writeBoolean(false);
            Integer idx = this.writeIndex.get(container);
            if (idx == null) {
                encoder.writeSmallInt(this.writeIndex.size());
                this.writeIndex.put(container, this.writeIndex.size());
                this.delegate.write(encoder, container);
            } else {
                encoder.writeSmallInt(idx.intValue());
            }
        }
    }

    private static enum Implementation {
        MODULE(1),
        ROOT_PROJECT(2),
        ROOT_BUILD_PROJECT(3),
        OTHER_BUILD_ROOT_PROJECT(4),
        OTHER_BUILD_PROJECT(5),
        LIBRARY(6),
        SNAPSHOT(7);

        private final byte id;

        private Implementation(int id) {
            this.id = (byte)id;
        }

        byte getId() {
            return this.id;
        }
    }
}

