/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasmaCannonHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 2304364403526293671L;

    public PlasmaCannonHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -3;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (entity instanceof Mech) {
            HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
            hitData.setGeneralDamageType(this.generalDamageType);
            if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
                this.r = new Report(3460);
                this.r.subject = this.subjectId;
                this.r.add(entity.getShortName());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.newlines = 0;
                this.r.indent(2);
                vector.addElement(this.r);
                this.missed = true;
                return;
            }
            if (!this.bSalvo) {
                this.r = new Report(3405);
                this.r.subject = this.subjectId;
                this.r.add(this.toHit.getTableDesc());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
            this.r = new Report(3400);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            int n5 = Compute.d6(2);
            this.r.add(n5);
            this.r.choose(true);
            this.r.newlines = 0;
            vector.addElement(this.r);
            entity.heatFromExternal += n5;
        } else {
            super.handleEntityDamage(entity, vector, building, n, n2, n3, n4);
        }
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Mech) {
            return 0;
        }
        int n = 1;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            n = Compute.d6(3);
            if (this.bDirect) {
                n += this.toHit.getMoS() / 3;
            }
            if (((Entity)this.target).getCrew().getOptions().booleanOption("pain_shunt")) {
                n = Math.max(n / 2, 1);
            }
        } else if (this.bDirect) {
            n = Math.min(n + this.toHit.getMoS() / 3, n * 2);
        }
        if (this.bGlancing) {
            n = (int)Math.floor((double)n / 2.0);
        }
        return n;
    }

    @Override
    protected int calcnCluster() {
        if (this.target instanceof Mech) {
            this.bSalvo = false;
            return 1;
        }
        this.bSalvo = true;
        return 5;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        if (this.target instanceof Mech) {
            return 1;
        }
        if (this.target instanceof BattleArmor && ((BattleArmor)this.target).isFireResistant()) {
            return 0;
        }
        return Compute.d6(3);
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    @Override
    protected void handleIgnitionDamage(Vector<Report> vector, Building building, boolean bl, int n) {
        TargetRoll targetRoll;
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if ((targetRoll = new TargetRoll(this.wtype.getFireTN(), this.wtype.getName())).getValue() != Integer.MAX_VALUE) {
            Report.addNewline(vector);
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, targetRoll, true, -1, vector);
        }
    }

    @Override
    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }
}

