/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NarcExplosiveHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = -1655014339855184419L;

    public NarcExplosiveHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " explosive pod ";
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            return 1;
        }
        this.bSalvo = true;
        if (this.ae instanceof BattleArmor) {
            if (this.amsEnganged) {
                return Compute.missilesHit(((BattleArmor)this.ae).getShootingStrength(), -2);
            }
            return Compute.missilesHit(((BattleArmor)this.ae).getShootingStrength());
        }
        if (this.amsEnganged) {
            this.r = new Report(3235);
            this.r.subject = this.subjectId;
            vector.add(this.r);
            this.r = new Report(3230);
            this.r.indent(1);
            this.r.subject = this.subjectId;
            vector.add(this.r);
            int n = Compute.d6();
            if (n <= 3) {
                this.r = new Report(3240);
                this.r.subject = this.subjectId;
                this.r.add(n);
                vector.add(this.r);
                return 0;
            }
            this.r = new Report(3241);
            this.r.add(n);
            this.r.subject = this.subjectId;
            vector.add(this.r);
        }
        return 1;
    }

    @Override
    protected int calcnCluster() {
        return 1;
    }

    @Override
    protected int calcDamagePerHit() {
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        double d = ammoType.getAmmoType() == 30 ? 6.0 : 4.0;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0, ((Infantry)this.target).isMechanized());
            d = Math.ceil(d);
        }
        if (this.bGlancing) {
            return (int)Math.floor(d / 2.0);
        }
        return (int)d;
    }
}

