/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryRemover {
    private static final String[] SANDBOX_CONTENT = new String[]{"com/izforge/izpack/util/LibraryRemover.class"};
    private static final String BASE_KEY = "lib.rem.base";
    private static final String PHASE_KEY = "self.mod.phase";
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String PREFIX = "InstallRemover";
    private int phase = 0;
    private File logFile = null;
    private File sandbox = null;
    private File specFile = null;
    private SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();
    PrintStream log = null;

    private LibraryRemover(int n) throws IOException {
        this.phase = n;
        if (n == 1) {
            this.initJavaExec();
        } else {
            this.logFile = new File(System.getProperty(BASE_KEY) + ".log");
            this.specFile = new File(System.getProperty(BASE_KEY) + ".spec");
            this.sandbox = new File(System.getProperty(BASE_KEY) + ".d");
        }
    }

    public static void invoke(List<String> list) throws IOException {
        LibraryRemover libraryRemover = new LibraryRemover(1);
        libraryRemover.invoke1(list);
    }

    private void initJavaExec() throws IOException {
        try {
            Process process = Runtime.getRuntime().exec(LibraryRemover.javaCommand());
            new StreamProxy(process.getErrorStream(), "err").start();
            new StreamProxy(process.getInputStream(), "out").start();
            process.getOutputStream().close();
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Unable to create a java subprocess");
        }
    }

    private void invoke1(List<String> list) throws IOException {
        Object object;
        while (true) {
            this.logFile = File.createTempFile(PREFIX, ".log");
            object = this.logFile.getCanonicalPath();
            this.specFile = new File(((String)object).substring(0, ((String)object).length() - 4) + ".spec");
            this.sandbox = new File(((String)object).substring(0, ((String)object).length() - 4) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        object = null;
        InputStream inputStream = null;
        byte[] byArray = new byte[5120];
        int n = 0;
        for (String string : SANDBOX_CONTENT) {
            int n2;
            inputStream = this.getClass().getResourceAsStream("/" + string);
            File file = new File(this.sandbox, string);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            object = new BufferedOutputStream(new FileOutputStream(file));
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                ((OutputStream)object).write(byArray, 0, n2);
            }
            ((OutputStream)object).close();
            ++n;
        }
        object = new BufferedOutputStream(new FileOutputStream(this.specFile));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object));
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            bufferedWriter.write(iterator.next());
            if (!iterator.hasNext()) continue;
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
        ((OutputStream)object).close();
        this.spawn(2);
        this.log("library cleanup done");
    }

    private ArrayList<File> getFilesList() throws Exception {
        TreeSet treeSet = new TreeSet(Collections.reverseOrder());
        FileInputStream fileInputStream = new FileInputStream(this.specFile);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        while (string != null) {
            treeSet.add(new File(string));
            string = bufferedReader.readLine();
        }
        ((InputStream)fileInputStream).close();
        return new ArrayList<File>(treeSet);
    }

    private void invoke2() {
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<File> arrayList = this.getFilesList();
            int n = arrayList.size();
            this.log("deleteing temporary dlls/shls");
            for (int i = 0; i < n; ++i) {
                File file = arrayList.get(i);
                file.delete();
                if (file.exists()) {
                    this.log("    deleting of " + file.getCanonicalPath() + " failed!!!");
                    continue;
                }
                this.log("    " + file.getCanonicalPath());
            }
            this.log("deleteing sandbox");
            LibraryRemover.deleteTree(this.sandbox);
            this.specFile.delete();
        }
        catch (Exception exception) {
            this.log(exception);
        }
    }

    private Process spawn(int n) throws IOException {
        String string = this.logFile.getAbsolutePath();
        string = string.substring(0, string.length() - 4);
        String[] stringArray = new String[]{LibraryRemover.javaCommand(), "-classpath", this.sandbox.getAbsolutePath(), "-Dlib.rem.base=" + string, "-Dself.mod.phase=" + n, this.getClass().getName()};
        StringBuffer stringBuffer = new StringBuffer("Spawning phase ");
        stringBuffer.append(n).append(": ");
        for (String string2 : stringArray) {
            stringBuffer.append("\n\t").append(string2);
        }
        this.log(stringBuffer.toString());
        return Runtime.getRuntime().exec(stringArray, null, null);
    }

    public static boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                LibraryRemover.deleteTree(file2);
            }
        }
        return file.delete();
    }

    private static String addExtension(String string) {
        return string + (OsVersion.IS_WINDOWS || OsVersion.IS_OS2 ? ".exe" : "");
    }

    private static String javaCommand() {
        String string = LibraryRemover.addExtension("java");
        String string2 = new File(JAVA_HOME + "/bin").getAbsolutePath();
        File file = new File(string2, string);
        if (!file.exists()) {
            return string;
        }
        return file.getAbsolutePath();
    }

    public static void main(String[] stringArray) {
        try {
            LibraryRemover libraryRemover = new LibraryRemover(2);
            libraryRemover.invoke2();
        }
        catch (IOException iOException) {
            System.err.println("Error invoking a secondary phase");
            System.err.println("Note that this program is only intended as a secondary process");
            iOException.printStackTrace();
        }
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException iOException) {
            System.err.println("Phase " + this.phase + " log err: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable throwable) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + throwable.getMessage());
            throwable.printStackTrace(this.log);
        }
    }

    private void log(String string) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + string);
        }
    }

    public static class StreamProxy
    extends Thread {
        InputStream in;
        String name;
        OutputStream out;

        public StreamProxy(InputStream inputStream, String string) {
            this(inputStream, string, null);
        }

        public StreamProxy(InputStream inputStream, String string, OutputStream outputStream) {
            this.in = inputStream;
            this.name = string;
            this.out = outputStream;
        }

        public void run() {
            try {
                String string;
                PrintWriter printWriter = null;
                if (this.out != null) {
                    printWriter = new PrintWriter(this.out);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
                while ((string = bufferedReader.readLine()) != null) {
                    if (printWriter == null) continue;
                    printWriter.println(string);
                }
                if (printWriter != null) {
                    printWriter.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

