-------------------
-- This is the main help page. It is meant to be easy to 
-- navigate, so an important point is that the LHSButton
-- should be used to navigate up a tier, and the RHSButton
-- should be a "Goodbye" button. Documenting tiers is crucial to 
-- maintaining a clean organization of the  help files.
-------------------
--
-- Basics
--   - Movement
--   - Talking to NPC's
--     - SENTInce (standard topics)
--   - First steps (i.e. talk to Fanrir, go into cellar, etc.)
--   - Combat
-- Chat
--   - Overview
--   - /channel command
--   - /tell command
--   - /gsay command
--   - Emotes
-- Groups
--   - Overview
--     - /invite command
--     - /leave command
--     - /gsay command
--     - Other group commands which are never used
-- Commands
--   - Dynamically-generated list of commands
-------------------

-- TODO: Use a metatable to classify help topics based on one or
-- more category->subcategory listing. For example, when the 
-- user runs /help /commands, the interface should be generated
-- from all the help files which classify themselves as commands

local player = event.activator

require("interface_builder")
ib = InterfaceBuilder()
require("topic_list")
tl = TopicList()

require("help/basics")
require("help/chat")
require("help/groups")

local function topic_help_main()
    ib:SetHeader("st_001", "")
    ib:SetTitle("Main help menu")
    ib:SetMsg("\n\nWelcome to Daimonin!")
    ib:AddMsg("\n\nThis is the game's interactive help menu. On the left-hand side of each page, you'll see all the available help categories. As you navigate through the categories, you'll see various subcategories as well.")

    ib:AddLink("The basics", "/help basics")
    ib:AddLink("Chat", "/help chat")
    ib:AddLink("Groups", "/help groups")
end

tl:SetDefault(topic_help_main)
tl:AddTopics({"/help", "/help main"}, topic_help_main)

ib:ShowSENTInce(game.GUI_NPC_MODE_NPC, tl:CheckMessage(event, true))

