/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.hash.HashCode;

public class EmptyHistoricalFileCollectionFingerprint
implements HistoricalFileCollectionFingerprint {
    public static final EmptyHistoricalFileCollectionFingerprint INSTANCE = new EmptyHistoricalFileCollectionFingerprint();

    private EmptyHistoricalFileCollectionFingerprint() {
    }

    @Override
    public boolean visitChangesSince(FileCollectionFingerprint oldFingerprint, String title, boolean includeAdded, TaskStateChangeVisitor visitor) {
        for (Map.Entry<String, NormalizedFileSnapshot> entry : oldFingerprint.getSnapshots().entrySet()) {
            if (visitor.visitChange(FileChange.removed(entry.getKey(), title, entry.getValue().getType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Multimap<String, HashCode> getRootHashes() {
        return ImmutableMultimap.of();
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return Collections.emptyMap();
    }

    @Override
    public HistoricalFileCollectionFingerprint archive() {
        return this;
    }

    public String toString() {
        return "EMPTY";
    }
}

