/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.TreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeCopyHandler;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeGenerator;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class ChangeUtil {
    public static void encodeInformation(TreeElement element) {
        ChangeUtil.encodeInformation(element, element);
    }

    private static void encodeInformation(TreeElement element, ASTNode original) {
        DebugUtil.performPsiModification(null, () -> ChangeUtil.encodeInformation(element, original, new HashMap<Object, Object>()));
    }

    private static void encodeInformation(TreeElement element, ASTNode original, Map<Object, Object> state2) {
        for (TreeCopyHandler handler2 : Extensions.getExtensions(TreeCopyHandler.EP_NAME)) {
            handler2.encodeInformation(element, original, state2);
        }
        if (original instanceof CompositeElement) {
            TreeElement child = element.getFirstChildNode();
            ASTNode child1 = original.getFirstChildNode();
            while (child != null) {
                ChangeUtil.encodeInformation(child, child1, state2);
                child = child.getTreeNext();
                child1 = child1.getTreeNext();
            }
        }
    }

    public static TreeElement decodeInformation(TreeElement element) {
        return DebugUtil.performPsiModification(null, () -> ChangeUtil.decodeInformation(element, new HashMap<Object, Object>()));
    }

    private static TreeElement decodeInformation(TreeElement element, Map<Object, Object> state2) {
        for (TreeElement child = element.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            child = ChangeUtil.decodeInformation(child, state2);
        }
        for (TreeCopyHandler handler2 : Extensions.getExtensions(TreeCopyHandler.EP_NAME)) {
            TreeElement handled = handler2.decodeInformation(element, state2);
            if (handled == null) continue;
            return handled;
        }
        return element;
    }

    @NotNull
    public static LeafElement copyLeafWithText(@NotNull LeafElement original, @NotNull String text2) {
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            ChangeUtil.$$$reportNull$$$0(1);
        }
        LeafElement element = ASTFactory.leaf(original.getElementType(), text2);
        original.copyCopyableDataTo(element);
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        LeafElement leafElement = element;
        if (leafElement == null) {
            ChangeUtil.$$$reportNull$$$0(2);
        }
        return leafElement;
    }

    public static TreeElement copyElement(@NotNull TreeElement original, CharTable table) {
        CompositeElement treeParent;
        if (original == null) {
            ChangeUtil.$$$reportNull$$$0(3);
        }
        return ChangeUtil.copyElement(original, (treeParent = original.getTreeParent()) == null ? null : treeParent.getPsi(), table);
    }

    public static TreeElement copyElement(TreeElement original, PsiElement context, CharTable table) {
        TreeElement element = (TreeElement)original.clone();
        PsiManagerEx manager = original.getManager();
        DummyHolderFactory.createHolder(manager, element, context, table).getTreeElement();
        ChangeUtil.encodeInformation(element, original);
        TreeUtil.clearCaches(element);
        ChangeUtil.saveIndentationToCopy(original, element);
        return element;
    }

    private static void saveIndentationToCopy(TreeElement original, TreeElement element) {
        if (original == null || element == null || CodeEditUtil.isNodeGenerated(original)) {
            return;
        }
        int indentation = CodeEditUtil.getOldIndentation(original);
        if (indentation < 0) {
            CodeEditUtil.saveWhitespacesInfo(original);
        }
        CodeEditUtil.setOldIndentation(element, CodeEditUtil.getOldIndentation(original));
        if (indentation < 0) {
            CodeEditUtil.setOldIndentation(original, -1);
        }
    }

    public static TreeElement copyToElement(PsiElement original) {
        DummyHolder holder = DummyHolderFactory.createHolder(original.getManager(), null, original.getLanguage());
        FileElement holderElement = holder.getTreeElement();
        TreeElement treeElement = ChangeUtil.generateTreeElement(original, holderElement.getCharTable(), original.getManager());
        holderElement.rawAddChildren(treeElement);
        TreeUtil.clearCaches(holderElement);
        ChangeUtil.saveIndentationToCopy((TreeElement)original.getNode(), treeElement);
        return treeElement;
    }

    @Nullable
    public static TreeElement generateTreeElement(@Nullable PsiElement original, @NotNull CharTable table, @NotNull PsiManager manager) {
        if (table == null) {
            ChangeUtil.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            ChangeUtil.$$$reportNull$$$0(5);
        }
        if (original == null) {
            return null;
        }
        PsiUtilCore.ensureValid(original);
        if (SourceTreeToPsiMap.hasTreeElement(original)) {
            return ChangeUtil.copyElement((TreeElement)SourceTreeToPsiMap.psiElementToTree(original), table);
        }
        for (TreeGenerator generator : Extensions.getExtensions(TreeGenerator.EP_NAME)) {
            TreeElement element = generator.generateTreeFor(original, table, manager);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public static void prepareAndRunChangeAction(final ChangeAction action2, final TreeElement changedElement) {
        final FileElement changedFile = TreeUtil.getFileElement(changedElement);
        PsiManagerEx manager = changedFile.getManager();
        final PomModel model = PomManager.getModel(manager.getProject());
        final TreeAspect treeAspect = model.getModelAspect(TreeAspect.class);
        model.runTransaction(new PomTransactionBase(changedElement.getPsi(), treeAspect){

            @Override
            public PomModelEvent runInner() {
                PomModelEvent event = new PomModelEvent(model);
                TreeChangeEventImpl destinationTreeChange = new TreeChangeEventImpl(treeAspect, changedFile);
                event.registerChangeSet(treeAspect, destinationTreeChange);
                action2.makeChange(destinationTreeChange);
                changedElement.clearCaches();
                if (changedElement instanceof CompositeElement) {
                    ((CompositeElement)changedElement).subtreeChanged();
                }
                return event;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ChangeUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyLeafWithText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyLeafWithText";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateTreeElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ChangeAction {
        public void makeChange(TreeChangeEvent var1);
    }
}

