/*
 * KlammerCheck
 *
 * Dieses Makro markiert den gesammten Text zwischen der schlieenden und
 * der zugehrigen ffnenden Klammer fr eine kurze Zeit.
 *
 * Der Cursor mu entweder auf oder direkt hinter der schlieenden
 * Klammer stehen.
 */


/*
 * Variablen
 */
Text = VRGet( 'MLE_1', 'Value')
pos  = VRGet( 'MLE_1', 'SelectedStart')
if Check(pos) = 0 then return


/*
 * Klammer bestimmen
 */
if pos \= VRGet( 'MLE_1', 'SelectedEnd') then
   Pos = Max( VRGet( 'MLE_1', 'SelectedStart'), VRGet( 'MLE_1', 'SelectedEnd'))
OldPos = Pos
Pos = Pos - 1
SKl = SubStr( Text, Pos , 1)
select
   when SKl = ')' then OKl = '('
   when SKl = '}' then OKl = '{'
   when SKl = ']' then OKl = '['
   otherwise return
end


/*
 * Anzahl der Klammern finden
 */
found = 1
do while found > 0
   S = LastPos( SKl, Text, pos - 1)
   ImText = Check(S)
   do while ImText = 0
      S = LastPos( SKl, Text, S - 1)
      ImText = Check(S)
   end
   O = LastPos( OKl, Text, pos - 1)
   ImText = Check(O)
   do while ImText = 0
      O = LastPos( OKl, Text, O - 1)
      ImText = Check(O)
   end
   if (S = 0) then
      select
         when O > 0 then S = O - 1
         when O = 0 then do
            call VRMessage VRWindow(), "ffnende Klammer nicht gefunden.",
               "Klammer Makro", "Information"
            return
         end
      end
   if S > O then do
      found = found + 1
      pos = S
   end
   else do
      found = found - 1
      pos = O
   end
end


/*
 * Zugehrige ffnende Klammer kurz markieren
 */
call VRSet 'MLE_1', 'SelectedEnd', OldPos
call VRSet 'MLE_1', 'SelectedStart', Pos
do 50000
   nop
end
call VRSet 'MLE_1', 'SelectedStart', OldPos
return


/*
 * Unterroutine, die Prft, ob sich die 'Fundstelle' in einem
 * Kommentar befindet.
 */

Check:  procedure expose Text
pos   = arg(1)
rc = 1
if pos > 0 then do
   ENTER = LastPos( D2C(13), Text, pos) + 1
   if ENTER = 1 then return rc
   Str   = SubStr(Text, ENTER, pos - ENTER + 1)
   Marker = Pos( ' %', Str)
   if (Marker < pos - ENTER) & (Marker > 0) then return 0
   do forever
      Str = DelStr( Str, 1, 1)
      Marker = Marker - 1
      select
         when C2D( Left( Str, 1, 1)) = '9' then iterate
         when C2D( Left( Str, 1, 1)) = '32' then iterate
         when C2D( Left( Str, 1, 1)) = '37' then do
            rc = 0
            leave
         end
         otherwise leave
      end
   end
end
return rc
