/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.AnyBoxedNode;
import nts.node.BreakingCntx;
import nts.node.FontMetric;
import nts.node.HorizIterator;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.SettingContext;
import nts.node.TypeSetter;
import nts.node.VisibleSummarizer;

public class DiscretionaryNode
extends AnyBoxedNode {
    public static final int MAX_LIST_LENGTH = 255;
    public static final int MAX_LIST_RECONS_LENGTH = 127;
    public static final DiscretionaryNode EMPTY = new DiscretionaryNode(NodeList.EMPTY, NodeList.EMPTY, NodeList.EMPTY);
    protected final NodeList pre;
    protected final NodeList post;
    protected final NodeList list;

    public boolean hasKern() {
        Node last = this.list.lastNode();
        return last != null && last.hasKern();
    }

    public Dimen getKern() {
        Node last = this.list.lastNode();
        return last != null ? last.getKern() : null;
    }

    public Dimen getItalCorr() {
        Node last = this.list.lastNode();
        return last != null ? last.getItalCorr() : null;
    }

    public FontMetric addShortlyOn(Log log, FontMetric metric) {
        return this.post.addShortlyOn(log, this.pre.addShortlyOn(log, metric));
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc());
        if (!this.list.isEmpty()) {
            log.add(" replacing ").add(this.list.length());
        }
        cntx.addOn(log, this.pre.nodes(), '.');
        cntx.addOn(log, this.post.nodes(), '|');
        cntx.addItems(log, this.list.nodes());
    }

    public String getDesc() {
        return "discretionary";
    }

    public void typeSet(TypeSetter setter, SettingContext sctx) {
        setter.moveLeft(this.getLeftX());
        NodeEnum nodes = this.list.nodes();
        while (nodes.hasMoreNodes()) {
            Node node = nodes.nextNode();
            setter.moveRight(node.getLeftX());
            node.typeSet(setter, sctx);
            setter.moveRight(node.getWidth());
        }
        setter.moveLeft(this.getWidth());
    }

    public void addBreakDescOn(Log log) {
        log.addEsc("discretionary");
    }

    public int breakPenalty(BreakingCntx brCntx) {
        return this.pre.isEmpty() ? brCntx.exHyphenPenalty() : brCntx.hyphenPenalty();
    }

    public boolean isHyphenBreak() {
        return true;
    }

    public Dimen preBreakWidth() {
        return HorizIterator.totalWidth(this.pre.nodes());
    }

    public Dimen postBreakWidth() {
        return HorizIterator.totalWidth(this.post.nodes());
    }

    public NodeEnum atBreakReplacement() {
        NodeList replacement = new NodeList(1 + this.pre.length());
        replacement.append(EMPTY).append(this.pre);
        return replacement.nodes();
    }

    public NodeEnum postBreakNodes() {
        return this.post.nodes();
    }

    public boolean discardsAfter() {
        return this.post.isEmpty();
    }

    public void contributeVisible(VisibleSummarizer summarizer) {
        summarizer.summarize(this.list.nodes());
    }

    public String toString() {
        return "Discretionary(" + this.pre + "; " + this.post + "; " + this.list + ")";
    }

    public DiscretionaryNode(NodeList pre, NodeList post, NodeList list) {
        super(HorizIterator.naturalSizes(list.nodes()));
        this.pre = pre;
        this.post = post;
        this.list = list;
    }
}

