/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.BoolPar;
import nts.command.BackedToken;
import nts.command.BackedTokenList;
import nts.command.ContextDisplay;
import nts.command.FilePos;
import nts.command.InpTokChecker;
import nts.command.InsertedToken;
import nts.command.InsertedTokenList;
import nts.command.Token;
import nts.command.TokenList;
import nts.command.Tokenizer;

public class TokenizerStack {
    private Tokenizer top = null;
    private InpTokChecker checker = null;
    private final BoolPar CAN_EXPAND = new BoolPar();

    public Tokenizer getTop() {
        return this.top;
    }

    public synchronized void push(Tokenizer tokenizer) {
        Tokenizer oldTop = this.top;
        this.top = tokenizer;
        this.top.pushTo(this, oldTop);
    }

    private synchronized Tokenizer pop() {
        if (this.top != null) {
            Tokenizer oldTop = this.top;
            this.top = oldTop.getNext();
            oldTop.popFrom(this);
            return oldTop;
        }
        return null;
    }

    public synchronized void dropPop() {
        if (this.top != null) {
            this.pop().close();
        }
    }

    public synchronized void dropFinishedPop() {
        if (this.top != null && this.top.finished()) {
            this.pop().close();
        }
    }

    public void push(TokenList list, String desc) {
        this.push(new InsertedTokenList(list, desc));
    }

    public void backUp(TokenList list) {
        this.push(new BackedTokenList(list));
    }

    public void push(Token tok, String desc) {
        this.push(new InsertedToken(tok, desc));
    }

    public void backUp(Token tok, boolean exp) {
        this.push(new BackedToken(tok, exp));
    }

    public InpTokChecker setChecker(InpTokChecker chk) {
        InpTokChecker old = this.checker;
        this.checker = chk;
        return old;
    }

    public synchronized Token nextToken(BoolPar canExpand) {
        if (canExpand == null) {
            canExpand = this.CAN_EXPAND;
        }
        while (this.top != null) {
            Token tok = this.top.nextToken(canExpand);
            if (tok != null) {
                return this.checker != null ? this.checker.checkToken(tok, canExpand) : tok;
            }
            if (!this.pop().close() || this.checker == null) continue;
            this.checker.checkEndOfFile();
        }
        canExpand.set(false);
        return null;
    }

    public synchronized void close() {
        while (this.top != null) {
            this.pop().close();
        }
    }

    public synchronized void cleanFinishedLists() {
        while (this.top != null && this.top.finishedList()) {
            this.pop().close();
        }
    }

    public synchronized void cleanFinishedInserts() {
        while (this.top != null && this.top.finishedInsert()) {
            this.pop().close();
        }
    }

    public synchronized void endTopmostInput() {
        Tokenizer curr = this.top;
        while (curr != null) {
            if (curr.endInput()) break;
            curr = curr.getNext();
        }
    }

    public synchronized FilePos filePos() {
        FilePos pos = null;
        Tokenizer curr = this.top;
        while (curr != null) {
            pos = curr.filePos();
            if (pos != null) break;
            curr = curr.getNext();
        }
        return pos;
    }

    public int lineNumber() {
        FilePos pos = this.filePos();
        return pos != null ? pos.line : 0;
    }

    public synchronized void show(ContextDisplay disp) {
        int lines = disp.lines();
        boolean dots = lines > 0;
        Tokenizer curr = this.top;
        if (curr != null) {
            while (true) {
                boolean force;
                boolean bottom = curr.enoughContext() || curr.getNext() == null;
                boolean bl = force = bottom || curr == this.top;
                if (force || lines > 0) {
                    disp.reset();
                    lines -= curr.show(disp, force, lines);
                } else if (lines <= 0 && dots) {
                    disp.normal().startLine().add("...");
                    dots = false;
                }
                if (bottom) break;
                curr = curr.getNext();
            }
        }
    }
}

