/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.BoolPar;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.Expandable;
import nts.command.ExpandablePrim;
import nts.command.FilePos;
import nts.command.InpTokChecker;
import nts.command.SkipToksChecker;
import nts.command.Token;
import nts.io.Loggable;

public abstract class CondPrim
extends ExpandablePrim {
    public static final int NOTHING = 0;
    public static final int WAIT = 1;
    public static final int FI = 2;
    public static final int ELSE = 3;
    public static final int OR = 4;
    private static CondEntry condTop = null;

    protected static boolean conforms(int endLev, int limit) {
        return endLev <= limit;
    }

    protected static boolean closesBranch(int endLev) {
        return endLev > 1;
    }

    protected static CondEntry pushCond(int limit, Expandable curr) {
        FilePos fpos = CommandBase.getTokStack().filePos();
        condTop = new CondEntry(condTop, limit, curr, fpos);
        return condTop;
    }

    protected static void popCond() {
        condTop = CondPrim.condTop.next;
    }

    protected static CondEntry topCond() {
        return condTop;
    }

    protected static boolean noCond() {
        return condTop == null;
    }

    public static void cleanUp() {
        while (condTop != null) {
            CommandBase.normLog.startLine().add('(').addEsc("end").add(" occurred when ");
            CondPrim.condTop.curr.addExpandable(CommandBase.normLog);
            if (CondPrim.condTop.fpos != null) {
                CommandBase.normLog.add(" on line ").add(CondPrim.condTop.fpos.line);
            }
            CommandBase.normLog.add(" was incomplete)");
            CondPrim.popCond();
        }
    }

    protected static int skipBranch() {
        int endLev;
        BoolPar exp = new BoolPar();
        Loggable[] params = new Loggable[]{Expandable.exp(CondPrim.condTop.curr), CommandBase.num(CommandBase.currLineNumber())};
        InpTokChecker savedChk = CommandBase.setTokenChecker(new SkipToksChecker(params));
        int level = 0;
        while (true) {
            Token tok;
            Command cmd;
            if (CondPrim.closesBranch(endLev = (cmd = CommandBase.meaningOf(tok = CommandBase.nextRawToken(exp), exp.get())).endBranchLevel())) {
                if (level == 0) break;
                if (endLev != 2) continue;
                --level;
                continue;
            }
            if (!cmd.isConditional()) continue;
            ++level;
        }
        CommandBase.setTokenChecker(savedChk);
        return endLev;
    }

    public CondPrim(String name) {
        super(name);
    }

    protected static final class CondEntry {
        public static final CondEntry NULL;
        public final CondEntry next;
        public int limit;
        public final Expandable curr;
        public final FilePos fpos;

        CondEntry(CondEntry next, int limit, Expandable curr, FilePos fpos) {
            this.next = next;
            this.limit = limit;
            this.curr = curr;
            this.fpos = fpos;
        }
    }
}

