program VFComb;
{$I option.pas}
{$M 65000,0,655360}
uses Dos,
     VFDcl,   VFString, VFCheck,
     VFParm,  VFRead,
     VFInput, VFOutput;

{---------------------------------------------------------------}
{                                                               }
{      Program combines several TeX fonts in a virtual font.    }
{      It uses text (ASCII) files *.VP (produced by TFtpPL      }
{      utility from corresponding *.TFM files), and creates     }
{      the text file *.VPL which can transferred to the         }
{      binary form (*.VF file) by VPtoVF utility.               }
{                                                               }
{      The formal syntaxis for *.VP and *.VPL files used        }
{      by VFComb is described in:                               }
{                                                               }
{      Donald Knuth. Virtual Fonts: More Fun for Grand          }
{             Wizards, TUGBoat 11 (1990), No 1, pp.13--23.      }
{                                                               }
{---------------------------------------------------------------}

var HFlags : FontHeadFlags;
var FParam : FontParamRec;
var FDim   : FontDimenRec;
var FChar  : CharDataType;
var FLig   : ptrLigRecord;
var FLigB  : ptrLigRecord;
var CharReMap : CharReMapArr;

var ptrL   : ptrLigRecord;
    ptrDD  : ptrDVIRecord;

var fn : text;
    res : float;

var s : string;
    i, ii, jj, ind : integer;
    sDir   : DirStr;
    sNam   : NameStr;
    sExt   : ExtStr;
    fl     : boolean;

begin

     writeln;
     writeln('This is VFComb (version '+_Version+')');
     if ParamCount = 0 then
     begin
          writeln('Usage: VFComb <datafile> [<macro defs>] [/l:<logfile>] [/u:<default dirs>]');
          halt;
     end;

     new(FontsParm); new(CharDataGlb);

     FlagProcessFile:=false;
     InitData;
     ReadCommandLine;

     FlagLogOut:=true;

     if (TableNameGlb = '') or (TableNameGlb = ' ') then
     begin
          ErrorLog('*** Error : no MAP TABLE name is specified');
          FlagSevere:=true; halt;
     end;

     InitHeadFile(VParamGlb,FontDimenGlb,HFlagsGlb);

     FlagProcessFile:=true;
     LoadTableFile(TableNameGlb);
     FlagProcessFile:=false;

     if LigDesignUnitsGlb <= 0.0 then
     begin
          ErrorLog('*** Error : LIGDESIGNUNITS < 0 : '
                      +ConvReal(LigDesignUnitsGlb));
          ErrorLog('            LIGDESIGNUNITS is set to 1.0');
          LigDesignUnitsGlb:=1.0;
     end;
     if LigDesignSizeGlb <= 0.0 then
     begin
          ErrorLog('*** Error : LIGDESIGNSIZE < 0 : '
                      +ConvReal(LigDesignSizeGlb));
          ErrorLog('            LIGDESIGNSIZE is set to 1.0');
          LigDesignSizeGlb:=1.0;
     end;

     if IndHeadGlb = -9999 then IndHeadGlb:=0;
     if (IndHeadGlb >= 0) then
     begin
          if FontsParm^[IndHeadGlb].FlagFontUsed then
          begin
               InitHeadFile(FParam,FDim,HFlags);
               FlagProcessFile:=true;
               LoadHeadFile(FontsParm^[IndHeadGlb].FontName,
                            FParam,FDim,HFlags);
               FlagProcessFile:=false;
               JoinHeader(FParam,FDim,HFlags,
                          FontsParm^[IndHeadGlb].FontAt,
                          FontsParm^[IndHeadGlb].FlFontAt);
          end
          else begin
               ErrorLog('Font number '+ConvInt(IndHeadGlb)+' is not defined');
          end;
     end;
     if HeadNameGlb <> '' then
     begin
          InitHeadFile(FParam,FDim,HFlags);
          FlagProcessFile:=true;
          LoadHeadFile(HeadNameGlb,
                       FParam,FDim,HFlags);
          FlagProcessFile:=false;
          JoinHeader(FParam,FDim,HFlags,
                     FParam.FontDesignSize,false);
     end;

     {--- update char size data, header size data, lig size data ---}
     if VParamGlb.FontDesignUnits <= 0.0 then
     begin
          ErrorLog('*** Error : HEADER DESIGNUNITS < 0 : '
                      +ConvReal(VParamGlb.FontDesignUnits));
          ErrorLog('            HEADER DESIGNUNITS is set to 1.0');
          VParamGlb.FontDesignUnits:=1.0;
     end;
     if VParamGlb.FontDesignSize <= 0.0 then
     begin
          ErrorLog('*** Error : HEADER DESIGNSIZE < 0 : '
                      +ConvReal(VParamGlb.FontDesignSize));
          ErrorLog('            HEADER DESIGNSIZE is set to 10.0');
          VParamGlb.FontDesignSize:=10.0;
     end;
     res:=(LigDesignSizeGlb*VParamGlb.FontDesignUnits)
         /(LigDesignUnitsGlb*VParamGlb.FontDesignSize);

     with FontDimenGlb do
     begin
          {!!! Slant !!!}
          Space:=res*FDim.Space;
          Stretch:=res*FDim.Stretch;
          Shrink:=res*FDim.Shrink;
          XHeight:=res*FDim.XHeight;
          Quad:=res*FDim.Quad;
          ExtraSpace:=res*FDim.ExtraSpace;
          Num1:=res*FDim.Num1;
          Num2:=res*FDim.Num2;
          Num3:=res*FDim.Num3;
          Denom1:=res*FDim.Denom1;
          Denom2:=res*FDim.Denom2;
          Sup1:=res*FDim.Sup1;
          Sup2:=res*FDim.Sup2;
          Sup3:=res*FDim.Sup3;
          Sub1:=res*FDim.Sub1;
          Sub2:=res*FDim.Sub2;
          SupDrop:=res*FDim.SupDrop;
          SubDrop:=res*FDim.SubDrop;
          Delim1:=res*FDim.Delim1;
          Delim2:=res*FDim.Delim2;
          AxisHeight:=res*FDim.AxisHeight;
     end;

     for ii:=0 to 255 do
     with CharDataGlb^[ii] do
     begin
           if FlCharWD then CharWD:=CharWD*res;
           if FlCharHT then CharHT:=CharHT*res;
           if FlCharDP then CharDP:=CharDP*res;
           if FlCharIC then CharIC:=CharIC*res;
           if DefPKWidth then PKWidth:=PKWidth*res;

           if marked = CharDVI then
           begin
                ptrDD:=ptrDVI;
                while ptrDD <> nil do
                begin
                    case ptrDD^.TDVI of
                    DVIRule : begin
                                   ptrDD^.height:=ptrDD^.height*res;
                                   ptrDD^.width:=ptrDD^.width*res;
                              end;
                    DVIRight, DVILeft,
                    DVIUp, DVIDown : begin
                                   ptrDD^.dist:=ptrDD^.dist*res;
                              end;
                    end; {case}
                    ptrDD:=ptrDD^.ptrNext;
                end;
           end;
     end;

     ptrL:=ptrLigTable;
     while ptrL <> nil do
     with ptrL^ do
     begin
          if TTLig = TKern then KernValue:=KernValue*res;
          ptrL:=ptrL^.ptrNext;
     end; {while}

     {--- correct sizechar and sizefont fields ---}
     for ii:=0 to 255 do
     with CharDataGlb^[ii] do
     if (marked in [CharUsed,CharDVI]) and (not DefFlTFMData)
     then begin
          for ind:=0 to MaxFontNumber do
          if (FontsParm^[ind].FlagFontUsed)
              and (FontsParm^[ind].FlFontTFMData <> 0)
              and (mapfont = ind)
          then begin
               case FontsParm^[ind].FlFontTFMData of
               1 : sizechar:=mapchar;
               2 : sizechar:=ii;
               else begin
                    sizechar:=0;
                    ErrorLog('*** Error: Font D '+ConvInt(ind)+' has illegal AUTOTFM CHAR/MAPCHAR attributes.');
               end;
               end; {case}
               if not DefAutoWidth
                  then FlAutoWidth:=FontsParm^[ind].FlFontAutoWidth;
               sizefont:=FontsParm^[ind].IndexTFMFont;
               FlTFMData:=true; DefFlTFMData:=true;
          end;

          if FlFontTFMDataGlb <> 0 then
          begin
               case FlFontTFMDataGlb of
               1 : sizechar:=mapchar;
               2 : sizechar:=ii;
               else begin
                    sizechar:=0;
                    ErrorLog('*** Error: Font D '+ConvInt(ind)+' has illegal AUTOTFM CHAR/MAPCHAR attributes.');
               end;
               end; {case}
               if not DefAutoWidth then
               begin
                  FlAutoWidth:=FlFontAutoWidthGlb;
               end;
               sizefont:=IndexTFMFontGlb;
               FlTFMData:=true; DefFlTFMData:=true;
          end;

     end; {for ii}

     {--- correct VPL design units, if necessary ---}
     if VParamGlb.FontDesignSize <= 0.0 then
     begin
          ErrorLog('*** Error : Global DESIGNSIZE < 0 : '
                      +ConvReal(VParamGlb.FontDesignSize));
          ErrorLog('            DESIGNSIZE is set to 10.0');
          VParamGlb.FontDesignSize:=10.0; FlagError:=true;
     end;
     if VParamGlb.FontDesignUnits <= 0.0 then
     begin
          ErrorLog('*** Error : Global DESIGNUNITS < 0 : '
                     +ConvReal(VParamGlb.FontDesignUnits));
          ErrorLog('            DESIGNUNITS is set to 1.0');
          VParamGlb.FontDesignUnits:=1.0; FlagError:=true;
     end;

     {--- load and process font data ---}
     for ind:=0 to MaxFontNumber do
     if FontsParm^[ind].FlagFontUsed then
     begin

          if not FontsParm^[ind].DefNullDvi
             then FontsParm^[ind].FlagNullDvi:=FlagNullDviGlb;
          if not FontsParm^[ind].DefNoNextChar
             then FontsParm^[ind].FlNoNextChar:=FlNoNextCharGlb;
          if not FontsParm^[ind].DefFontAutoWidth
             then FontsParm^[ind].FlFontAutoWidth:=FlFontAutoWidthGlb;

          s:=FontsParm^[ind].FontTFMName;
          if (s = '') or (s = ' ') then s:=FontsParm^[ind].FontName;

          InitHeadFile(FParam, FDim, HFlags);
          InitCharData(FChar);
          FLig:=nil;

          FlagProcessFile:=true;
          LoadFontFile(s, FParam, FDim, FChar, FLig);
          FlagProcessFile:=false;

          CheckFont(FParam, FDim, FChar, FLig);

          if not FontsParm^[ind].FlCheckSum
             then  FontsParm^[ind].CheckSum:=FParam.FontCheckSum;
          if not FontsParm^[ind].FlFontDSize
             then  FontsParm^[ind].FontDSize:=FParam.FontDesignSize;
          if not FontsParm^[ind].FlFontDUnits
             then  FontsParm^[ind].FontDUnits:=FParam.FontDesignUnits;

          with FontsParm^[ind] do
          begin
               if DefTraceLig then FlagTraceLig:=FlTraceLig
                              else FlagTraceLig:=FlTraceLigGlb;
               if DefInclude  then FlagInclude :=FlInclude
                              else FlagInclude :=FlIncludeGlb;
               if DefLigTable then FlagLigTable:=FlLigTable
                              else FlagLigTable:=FlLigTableGlb;
               if DefDiscIncl then FlagDiscInclude:=FlDiscIncl
                              else FlagDiscInclude:=FlDiscIncludeGlb;
          end;

          {--- ligature table ---}
          if not FlagLigTable then
          begin
               while FLig <> nil do
               begin
                    ptrL:=FLig;
                    FLig:=FLig^.ptrNext;
                    dispose(ptrL);
               end;
          end;

          if not FlScreen then FlagLogScr:=false;

          CleanFont(ind, FParam, FDim, FChar, FLig, FLigB);

          if FlagTraceLig in [1,3] then
          begin
             fl:=FlagLogScr; FlagLogScr:=false;
             OutputLig(' Font D '+ConvInt(ind)+' (Clean)', FLig, FLigB);
             FlagLogScr:=fl;
          end;

          if FontsParm^[ind].FontAt <= 0.0 then
          begin
               ErrorLog('*** Error : FONTAT for font D '+ConvInt(ind)+' is < 0 : '
                          +ConvReal(FontsParm^[ind].FontAt));
               ErrorLog('            FONTAT is set to 1.0');
               FontsParm^[ind].FontAt:=1.0; FlagError:=true;
          end;
          ConvFont(ind, CharReMap, FParam, FDim, FChar, FLig, FLigB);

          if FlagTraceLig in [2,3] then
          begin
             fl:=FlagLogScr; FlagLogScr:=false;
             OutputLig(' Font D '+ConvInt(ind)+' (Conv)', FLig,FLigB);
             FlagLogScr:=fl;
          end;

          FlagLogScr:=true;
          JoinFont(ind, CharReMap, FParam, FDim, FChar, FLig, FLigB);

     end; {for font}

     {--- check null dvi attribute ---}
     for ii:=0 to 255 do
     if (CharDataGlb^[ii].marked in [CharUsed,CharDVI])
        and (not CharDataGlb^[ii].DefFlPhantom)
     then begin
          ind:=CharDataGlb^[ii].mapfont;
          if (FontsParm^[ind].FlagFontUsed
                and FontsParm^[ind].FlagNullDvi)
          then begin
               CharDataGlb^[ii].FlPhantom:=true;
          end;
     end;

     CheckTable;
     CheckLigTableTable(true); {--- check table and correct LigTableTable
                                    here: some characters may appear after
                                    loading fonts ---}

     FlagTraceLig:=FlTraceLigGlb;
     if FlagTraceLig in [1,2,3] then
     begin
          ptrL:=ptrLigMain;
          while ptrL <> nil do
          begin
               if ptrL^.marked in [LigUsed, LigUsedBound, LigAdded]
                  then ptrL^.marked:=LigUsed;
               ptrL:=ptrL^.ptrNext;
          end; {while}
          ptrL:=ptrLigBound;
          while ptrL <> nil do
          begin
               if ptrL^.marked in [LigUsed, LigUsedBound, LigAdded]
                  then ptrL^.marked:=LigUsed;
               ptrL:=ptrL^.ptrNext;
          end; {while}
          fl:=FlagLogScr; FlagLogScr:=false;
          OutputLig(' Joined LIGTABLE',ptrLigMain,ptrLigBound);
          FlagLogScr:=fl;
     end;

     if ptrLigTable <> nil then
     begin
          ErrorLog('Add new records to LIGTABLE ...');

          JoinLastLigTables;

          if FlagTraceLig in [1,3] then
          begin
               fl:=FlagLogScr; FlagLogScr:=false; ptrL:=nil;
               OutputLig(' External LIGTABLE', ptrLigTable, ptrL);
               FlagLogScr:=fl;
          end;

          if FlagTraceLig in [2,3] then
          begin
               fl:=FlagLogScr; FlagLogScr:=false;
               OutputLig(' Output LIGTABLE', ptrLigMain,ptrLigBound);
               FlagLogScr:=fl;
          end;

     end; {if <> nil}

     if SaveTableName <> '' then
     begin
          FileSplit(SaveTableName,sDir,sNam,sExt);
          if (sDir = '') or (sDir = ' ') then sDir:=OutputDirFile;
          if (sNam = '') or (sNam = ' ') then sNam:='NONAME';
          if (sExt = '') or (sExt = ' ') then sExt:='.TBF';
          SaveTableName:=PathConcat(sDir,sNam+sExt);
          ErrorLog('File '+SaveTableName+' is used for resulting MAP TABLE');

          assign(fn,SaveTableName); rewrite(fn);
          OutputTable(fn);
          close(fn);
     end;


     {---- delete not necessary fragments in
           Main LigTable, Bound LigTable, TABLE LigTable ----}
     FreeLigRecord(ptrLigMain,true);
     FreeLigRecord(ptrLigBound,true);
     FreeLigRecord(ptrLigTable,true);
     {--- do not joint LigTables (see VFOutput) !!! ---}

     if not FlagSevere then
     begin
        FileSplit(FontNameGlb,sDir,sNam,sExt);
        if (sDir = '') or (sDir = ' ') then sDir:=OutputDirFile;
        if (sNam = '') or (sNam = ' ') then sNam:='NONAME';
        if (sExt = '') or (sExt = ' ') then sExt:='.VPL';
        FontNameGlb:=PathConcat(sDir,sNam+sExt);
        ErrorLog('File '+FontNameGlb+' is used for OUTPUT data');

        assign(fn,FontNameGlb); rewrite(fn);
        OutputVPL(fn);
        close(fn);
     end
     else begin
        ErrorLog('*** No output due to severe errors!');
        FlagError:=true;
     end;

     FlagLogOut:=false;

     if FlagError then
     begin
          ErrorLog('There were errors in creating *.VPL file');
          ErrorLog('See LOG file for more information');
     end;

     if FlagLog then close(fnLog);

end.




