/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/fn.c"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#define __FN_C__

#include "common.h"

#include "fn.h"
#include "str.h"
#include "msg.h"
#include "debug.h"

/* compiler, OS, libc specific stuff -----------------------------------------*/
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
   FN_SetPathDelim(PSZ szName, char delim)
   changes slashes in filename to given character
   given:   address if string to store result; slashchar
   returns: string of result
*/
void FN_SetPathDelim(PSZ szName, char delim)
{
PCH p1;

  if (!szName) return;
  for (p1 = szName; *p1; p1++)
#if defined(OS_DOS) || defined(OS_OS2) || defined(OS_WIN)
    if ((*p1=='\\') || (*p1=='/')) *p1 = delim;
#elif defined(OS_UNIX)
    if (*p1=='/') *p1 = delim;     /* a useless function for UNIX... */
#endif
}

/*----------------------------------------------------------------------------
   void FN_MakeStd (PSZ szName)
   change filename to internal conventions.
   For OS/2, DOS, WIN: Change slashes to /, translate to lowercase
   For UNIX: do nothing
*/
void FN_MakeStd (PSZ szName)
{
  if (!szName) return;
#if defined(OS_OS2) || defined(OS_DOS) || defined(OS_WIN)
  {
    PCH p1;
      
    for (p1 = szName; *p1; p1++)
      if (*p1=='\\') *p1 = '/';        /* change to fwdslash */
      else *p1 = tolower(*p1);         /* handles only a-z, A-Z... */
  }
#endif
}

/* ---------------------------------------------------------------------------
   FN_GetAbsWD (PPSZ pszCwd)
   Get the current working dir as an absolute path.
   Note: DOS, OS/2 : cwd includes the drive letter
                     any \ are changed to /
         ALL       : cwd always does end up in an /
*/
void FN_GetAbsWD(PPSZ pszCwd)
{
PSZ p1;
PSZ pres;

  p1 = STR_new_string(_FN_MAX_PATH+1);
#if defined(__EMX__)
  pres = _getcwd2(p1, _FN_MAX_PATH+1);
  if (pres==NULL) { perror("_getcwd2()"); MSG_fatal_n(FAT_NOCURDIR);  }
#elif defined(__DJGPP__) || defined(__LINUX__)
  pres = getcwd(p1, _FN_MAX_PATH+1);
  if (pres==NULL) { perror("getcwd()");  MSG_fatal_n(FAT_NOCURDIR);  }
#endif
  FN_MakeStd(p1);
  STR_copy_string(pszCwd, p1);
  STR_delete_string(&p1);
  p1 = STR_get_terminator(*pszCwd); /* pszCwd must end with / ! */
  p1--;
  if (*p1!='/') STR_concat_string(pszCwd, "/");
  /* DBG2("-- FN_GetAbsWD : >%s<\n", *pszCwd); */
}

/* ---------------------------------------------------------------------------
   FN_SetAbsWD (PSZ pszCwd)
   Set the current working dir, what is an absolute path.
   Note: DOS, OS/2 : cwd is assumed to include the drive letter
         ALL       : cwd always does end up in an /
*/
void FN_SetAbsWD(PSZ szCwd)
{
  /* DBG2(" -- FN_SetAbsWD() : szCwd = >%s<\n", szCwd); */
#if defined(__EMX__)
  if (_chdir2(szCwd))
    { perror("_chdir2()"); MSG_fatal_0(szCwd);
      MSG_fatal_0(" - ");  MSG_fatal_n(FAT_NOCHDIR); }
#elif defined(__DJGPP__) || defined(__LINUX__)
  if (chdir(szCwd))
    { perror("chdir()");   MSG_fatal_0(szCwd);
      MSG_fatal_0(" - ");  MSG_fatal_n(FAT_NOCHDIR); }
#endif
}

/* ---------------------------------------------------------------------------
   void FN_MakeAbs2(PPSZ pszAbs, PSZ szRel, PSZ szRelFrom)
   Make file or directory absolute from (maybe) relative one.
   Third parameter is start point (absolute dir or file) from which is szRel
   relative to.
   For DOS, OS/2, WIN both directories (file) are on the same drive, there are
   no letters.
*/
void FN_MakeAbs2(PPSZ pszAbs, PSZ szRel, PSZ szFrom)
{
int isAbs    = 0;
PSZ szCatPath = NULL;
PSZ szRedPath = NULL;
PCH pTerm     = NULL;
PCH pB        = NULL;
PCH pE        = NULL;
  
      /* is szRel already absolute ? */
  if (szRel[0]=='/') isAbs = 1;
#if defined(OS_UNIX)
  if (szRel[0]=='~') if (szRel[1]=='/')  isAbs = 1;   /* any path starting with "~/" is absolute too. */
#endif
  if (isAbs)
    {
      STR_copy_string(pszAbs, szRel);
      return;
    }
      /* strip of a filename+extension (if any) from szFrom    */
      /* since (as a convention) all dirs end up in an '/'     */
      /* its secure to terminate the string after the last '/' */
  STR_copy_string(&szCatPath, szFrom);
  pTerm = strrchr(szCatPath,'/');   /* since it is abs there is at least one */
  pTerm++; *pTerm=0;
      /* now concat the relative path from szRel */
  STR_concat_string(&szCatPath,szRel);

      /* now we reduce this */
  STR_copy_string(&szRedPath,"");
  pB = pE = szCatPath+1;
      /*  DBG2(" -- FN_MakeAbs2 : szCatPath = >%s< \n", szCatPath); */
  for (;;)
    {
          /*  DBG3(" -- FN_MakeAbs2 loop top : szRedPath = >%s< pB = >%s< \n", szCatPath, pB); */
          /* find the next dir in szCatPath, pB points to start */
      pE = strchr(pB,'/');
      if (pE==NULL) /* remaining string is filename */
        {
          STR_concat_string(&szRedPath,"/");
          STR_concat_string(&szRedPath,pB);
              /* DBG1(" -- FN_MakeAbs2 loop break\n"); */
          break;
        }
      else
        {     /* there is a dirname starting at pB */
              /* for a while terminate it by overriding '/'  */
          *pE = 0;
          if (strcmp(pB,".")==0)
            { /* skip */ }
          else
          if (strcmp(pB,"..")==0)
            {  /* strip the last dirname from szRedPath */
              pTerm = strrchr(szRedPath,'/');
              if (pTerm!=szRedPath) *pTerm=0; /* but we never kill the first '/' */
            }
          else
            { /* add the dir */
              STR_concat_string(&szRedPath,"/");
              STR_concat_string(&szRedPath,pB);
            }
          *pE = '/'; pB = ++pE;
        }
    }
  STR_copy_string(pszAbs, szRedPath);
  STR_delete_string(&szRedPath);
  STR_delete_string(&szCatPath);
}

/* ---------------------------------------------------------------------------
   void FN_MakeAbs(PPSZ pszAbs, PSZ szRel, PSZ szRelFrom)
   Make file or directory absolute from (maybe) relative one.
   Third parameter is either a directory or a file (in this case only
   the path is used), absolute, as a start point from which szRel is
   relative to. If NULL, the current working dir is used.
*/
void FN_MakeAbs(PPSZ pszAbs, PSZ szRel, PSZ szFrom)
{
PSZ szFrom1 = NULL;
PSZ szAbs1  = NULL;
#if defined(OS_OS2) || defined(OS_DOS) || defined(OS_WIN)
char drv[3] = "!:";
char lettF = 0;
char lettR = 0;
PSZ szRel2  = NULL;
PSZ szFrom2 = NULL;
#endif
  
    /* Get szFrom if needed, make szFrom, szRel internal std */
  if (szFrom)
    STR_copy_string(&szFrom1, szFrom);
  else
    FN_GetAbsWD(&szFrom1);
  FN_MakeStd(szRel);
  FN_MakeStd(szFrom1);

#if defined (OS_UNIX)
  FN_MakeAbs2(&szAbs1, szRel, szFrom1);      /* no drives to handle, do the rest */
  STR_copy_string(pszAbs, szAbs1);
#elif defined(OS_OS2) || defined(OS_DOS) || defined(OS_WIN)
    /* check drive letters first, szFrom1 is assumed to have one */
  lettF = szFrom1[0];                             /* get letters */
  if ((szRel[0]>='a') && (szRel[0]<='z'))
    if (szRel[1]==':')
      lettR = szRel[0];
  if (lettR==lettF)                 /* both the same drv letters */
    {
      drv[0] = lettF;               /* store letter */
      szRel2  = szRel+2 ;           /* and 'strip' them */
      szFrom2 = szFrom1+2;
    }
  else
  if (lettR==0)                     /* szRel has no drv letter */
    {
      drv[0] = lettF;               /* store letter */
      szRel2  = szRel;              /* and 'strip' them */
      szFrom2 = szFrom1+2;
    }
  else                              /* szRel has, but different */ 
    {
          /* what we can do is: get the cwd for szRel's drive and */
          /* make absolute from there */
#if defined(__EMX__)
       char orgdrv;
       orgdrv = tolower(_getdrive());
       drv[0] = lettR;
       if (_chdir2(drv))
         { perror("_chdir2()"); MSG_fatal_0(drv);
           MSG_fatal_0(" - ");  MSG_fatal_n(FAT_NOCURDIR); }
       STR_delete_string(&szFrom1);
       FN_GetAbsWD(&szFrom1);       /* replace szFrom1 */
       drv[0] = orgdrv;
       if (_chdir2(drv))
         { perror("_chdir2()"); MSG_fatal_0(drv);
           MSG_fatal_0(" - ");  MSG_fatal_n(FAT_NOCURDIR); }
       drv[0] = lettF = lettR;       /* store letter */
       szRel2  = szRel+2 ;           /* and 'strip' them */
       szFrom2 = szFrom1+2;
#elif defined(__DJGPP__)
       unsigned int orgdrv;
       unsigned int availdrv;
       _dos_getdrive(&orgdrv);     /* can't check for err here */
       _dos_setdrive(lettR-'a'+1, &availdrv);
       STR_delete_string(&szFrom1);
       FN_GetAbsWD(&szFrom1);       /* replace szFrom1 */
       _dos_setdrive(orgdrv, &availdrv);
       drv[0] = lettF = lettR;       /* store letter */
       szRel2  = szRel+2 ;           /* and 'strip' them */
       szFrom2 = szFrom1+2;
#endif   /* __EMX__,  __DJGPP__ */
    }
      /* ok. drv is set to the drive letter for pszAbs, */
      /* szRel2, szFrom2 pointing to strings w/o drv letters */
  FN_MakeAbs2(&szAbs1, szRel2, szFrom2);      /* no longer drives to handle, do the rest */
  STR_copy_string(pszAbs, drv);
  STR_concat_string(pszAbs, szAbs1);
#endif   /* OS_UNIX, OS_DOS, OS_OS2, OS_WIN */

  /* DBG2(" -- FN_MakeAbs() pszAbs = >%s< \n", *pszAbs);
  DBG2("                 szRel  = >%s< \n", szRel);
  DBG2("                 szFrom = >%s< \n", szFrom);
  */

  STR_delete_string(&szFrom1);
  STR_delete_string(&szAbs1);
}

/* ---------------------------------------------------------------------------
   void FN_MakeAbsPath(PPSZ pszAbs, PSZ szRel, PSZ szRelFrom)
   Same as FN_MakeAbs, but a filename+ext (if any) is stripped from
   szAbs to make a path instead of a file
*/
void FN_MakeAbsPath(PPSZ pszAbs, PSZ szRel, PSZ szFrom)
{
PSZ szAbs1 = NULL;
PCH pTerm  = NULL;

  FN_MakeAbs(&szAbs1, szRel, szFrom);
      /* strip of a filename+extension (if any) from szAbs1    */
      /* since (as a convention) all dirs end up in an '/'     */
      /* its secure to terminate the string after the last '/' */
  pTerm = strrchr(szAbs1,'/');   /* since it is abs there is at least one */
  pTerm++; *pTerm=0;
  /* DBG2(" -- FN_MakeAbsPath() pszAbs = >%s< \n", szAbs1);
  DBG2("                     szRel  = >%s< \n", szRel);
  DBG2("                     szFrom = >%s< \n", szFrom);
  */
  STR_copy_string(pszAbs, szAbs1);
  STR_delete_string(&szAbs1);
}

/* ---------------------------------------------------------------------------
   FN_SplitPath(PPSZ pszDrv, PPSZ pszPath,
                PPSZ pszBase, PPSZ pszExt, PSZ szFileName )
   Split a given (absolute!) szFileName into components.
   Store the results in szDrv, szPath, szBase, szExt.
   If any psz pointer is NULL, the corresponding result
   is not stored.
   For UNIX: szDrv becomes an empty string.
*/
void FN_SplitPath(PPSZ pszDrv, PPSZ pszPath, PPSZ pszBase, PPSZ pszExt, PSZ szFileName )
{
PSZ pDrvB  = NULL;
PCH pDrvE  = NULL;
PSZ pPathB = NULL;
PCH pPathE = NULL;
PSZ pBaseB = NULL;
PCH pBaseE = NULL;
PSZ pExtB  = NULL;
PCH pExtE  = NULL;
char tmpCh = 0;

    /* DBG2(" -- FN_SplitPath : szFileName = >%s< \n", szFileName); */

                                        /* get pointers for drive */
#if defined(OS_UNIX)
    /* skip, nothing to do here */
#elif defined(OS_OS2) || defined(OS_DOS) || defined(OS_WIN)
  pDrvB = szFileName; pDrvE = pDrvB+2;
#endif
  /* DBG3(" -- FN_SplitPath (1) pDrvB  = >%s<, pDrvE  = >%s< \n", pDrvB, pDrvE); */
                                        /* get pointers for path */
#if defined(OS_UNIX)
  pPathB = szFileName;
#elif defined(OS_OS2) || defined(OS_DOS) || defined(OS_WIN)
  pPathB = pDrvE;
#endif
  pPathE = strrchr(pPathB,'/');  /* since the given name is abs we find one */
  pPathE++;
  /* DBG3(" -- FN_SplitPath (2) pPathB = >%s<, pPathE = >%s< \n", pPathB, pPathE); */

  if (*pPathE!=0)   /* if pPathE points to the trailing zero we skip finding name+ext */
    {
      /* DBG1(" -- FN_SplitPath res. base+ext\n"); */
      pBaseB = pPathE;   /* Basename starts here */
      pExtB = strrchr(pBaseB,'.');
      if (pExtB!=NULL)      /* there is an extension ? */
        {
          /* DBG1(" -- FN_SplitPath case 1 \n"); */
#if defined(OS_UNIX)
          if (pExtB==pBaseE)   /* there is no. for UNIX I assume that "/blah/.resource" */
            {                  /* has a basename ".resource" and no extension. Right ?    */
              /* DBG1(" -- FN_SplitPath case 1a \n"); */
              pBaseE = strchr(pBaseB,0);
              pExtB = pExtE = NULL;
            }
          else
            {
              /* DBG1(" -- FN_SplitPath case 1b \n"); */
              pExtE = strchr(pExtB, 0);
              pBaseE = pExtB;
            }
#elif defined(OS_OS2) || defined(OS_DOS) || defined(OS_WIN)
          if (pExtB==pBaseE)   /* there is one. for OS/2 I assume that "/blah/.ext" */
            {                  /* has no basename, but a extension ".ext". On FATs  */
                               /* (OS/2 and DOS) this cannot happen, but I don't check */
                               /* what about NT ? */
              /* DBG1(" -- FN_SplitPath case 1a \n"); */
              pExtE = strchr(pExtB,0);
              pBaseB = pBaseE = NULL;
            }
          else
            {
              /* DBG1(" -- FN_SplitPath case 1b \n"); */
              pExtE = strchr(pExtB, 0);
              pBaseE = pExtB;
            }
#endif
        }
      else /* if (pExtB!=NULL), no '.' found, no extension  */
        {
          /* DBG1(" -- FN_SplitPath case 2 \n"); */
          pBaseE = strchr(pBaseB,0);
        }
    }
  /* DBG3(" -- FN_SplitPath (3) pBaseB = >%s<, pBaseE = >%s< \n", pBaseB, pBaseE);
     DBG3(" -- FN_SplitPath (4) pExtB  = >%s<, pExtE  = >%s< \n", pExtB, pExtE);
   */

      /* pXxxxB and pXxxxE pointers are now set (and maybe NULL) */
      /* begin transfer of results */
  if (pszDrv)  if (pDrvB==NULL)
                 STR_copy_string(pszDrv,"");
               else
                 { tmpCh = *pDrvE; *pDrvE = 0;
                   STR_copy_string(pszDrv,pDrvB);
                 *pDrvE=tmpCh; }
  if (pszPath) if (pPathB==NULL)
                 STR_copy_string(pszPath,"");
               else
                 { tmpCh = *pPathE; *pPathE = 0;
                   STR_copy_string(pszPath,pPathB);
                   *pPathE=tmpCh; }
  if (pszBase) if (pBaseB==NULL)
                 STR_copy_string(pszBase,"");
               else
                 { tmpCh = *pBaseE; *pBaseE = 0;
                   STR_copy_string(pszBase,pBaseB);
                   *pBaseE=tmpCh; }
  if (pszExt)  if (pExtB==NULL)
                 STR_copy_string(pszExt,"");
               else
                 { tmpCh = *pExtE; *pExtE = 0;
                   STR_copy_string(pszExt,pExtB);
                   *pExtE=tmpCh; }
}

void FN_GetName(PPSZ pszName, PSZ szFileName)
{
PSZ szBase = NULL;
PSZ szExt  = NULL;

  FN_SplitPath(NULL, NULL, &szBase, &szExt, szFileName);
  STR_copy_string(pszName, szBase);
  STR_concat_string(pszName, szExt);
  STR_delete_string(&szBase);
  STR_delete_string(&szExt);
}

void FN_GetDrvPath(PPSZ pszDrvPath, PSZ szFileName)
{
PSZ szDrv  = NULL;
PSZ szPath = NULL;

  FN_SplitPath(&szDrv, &szPath, NULL, NULL, szFileName);
  STR_copy_string(pszDrvPath, szDrv);
  STR_concat_string(pszDrvPath, szPath);
  STR_delete_string(&szDrv);
  STR_delete_string(&szPath);
}


/* ---------------------------------------------------------------------------
   FN_GetPath2(PPSZ pszPath, PSZ szFileName)
   like the FN_GetPath macro, but the trailing '/' stripped.
*/
 
void FN_GetPath2(PPSZ pszPath, PSZ szFileName)
{
PCH pTerm;
    
  FN_SplitPath(NULL, pszPath, NULL, NULL, szFileName);
  pTerm=strchr(*pszPath, 0);
  if (pTerm==*pszPath) return; /* don't strip from an empty string */
  pTerm--; *pTerm=0;
}

/*------------------------------------------------------------------------- */
