#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "header1.h"
#include "header2.h"

char *argp[50]; /* pointers args */
int   argi[50]; /* arg sizes */
char *fname;	/* function name */
int args;	/* number of args */
int openmode;

int  function_index_windll;	/* windows dll number */
char *argstr;
int sum;

static int readline(FILE *fhandle, char *buf)
{
    int ch;
    int i = 0;

    for (;;) {
	ch = fgetc(fhandle);
	if (ch == EOF) {	    /* file ends */
	    if (!i)
		return EOF;
	    else {
		buf[i] = 0;
		return i;
	    }
	}
	else if (ch=='\n') {        /* line ends */
	    buf[i] = 0;
	    return i;
	}
	else
	    buf[i++]=ch;
    }
}

static BOOL find_winapi(char *linebuf, char *argbuf)
{
    char *pos, *sp;
    int offset;

    /* find WINAPI */
    if ((pos = strstr(linebuf, "WINAPI")) == NULL)
	return FALSE;
    offset = (int) pos - (int)linebuf;
    strcpy(argbuf, linebuf);

    /* pos to function name */
    fname = argbuf + offset + 7;
    while (*fname == ' ' || *fname == '\t')
	fname++;

    /* build string for return value */
    argp[0] = argbuf;

    sp = argbuf + offset - 1;
    while (*sp == ' ' || *sp == '\t')
	*sp-- = '\0';

    /* find arguments */
    if ((argstr = strchr(fname, '(')) == NULL)
	return FALSE;
    *argstr = '\0';
    sp = argstr - 1;
    while (*sp == ' ')
	*sp-- = '\0';

    ++argstr;

    if ((pos = strchr(argstr, ')')) == NULL)
	return FALSE;

    /* remove ; from function prototype */
    offset = (int) pos - (int) argbuf;
    *pos = '\0';
    linebuf[offset + 1] = '\0';
    --pos;
    while (*pos == ' ')
	*pos-- = '\0';
    while (*argstr == ' ')
	*argstr++ = '\0';

    argp[1] = argstr;
    args = 1;

    while ((pos = strchr(argp[args], ',')) != NULL) {
	if (*(pos-1) == ' ') {  /* remove space */
	    sp = pos-1;
	    while (*sp == ' ')
		*sp-- = '\0';
	}
	*pos = 0;
	while (*(pos+1) == ' ') /* remove space */
	    *++pos = 0;
	argp[++args] = pos + 1;
    }

    return TRUE;
}

static void remove_argnames(void)
{
    int i, flag=0;
    char *s, ch;

    for (i=1; i<=args; i++) {
	s = argp[i];
	while ((ch = *s) != '\0') {
	    if (ch == '*') {
		*++s = 0;
		flag = 0;
		break;
	    }
	    else if (ch >= 'A' && ch <= 'Z')     /* fnct( TYPE *name) */
		flag=1;
	    else if (ch >='a' && ch <='z' && flag) {
		*--s = 0;
		flag = 0;
		break;
	    }
	    ++s;
	}
    }
}

static BOOL searchlist(void)
{
    int i,j;
    char *list, *current;
    static char short_str[] = "short";

    sum = 0;
    for (i = 0; i <= args; i++) {
	current = argp[i];
	if (strcmp(current, "int") == 0)
	    current = argp[i] = short_str;
	else if (strncmp(current, "const", 5) == 0) {
	    current+=5;
	    while (*current == ' ')
		current++;
	}
	for ( j=0 ; ; j++) {
	    list = data_types[j].name;
	    if (list == NULL) {
		printf("\nnot found '%s' in %s()\n\n", current, fname);
		return FALSE;
	    }
	    if (strcmp(list, current) == 0) {
		argi[i] = data_types[j].size;
		sum += argi[i];
		/* mark "FAR xx" */
		if ((*current=='L' && *(current+1)=='P' && strcmp(current,"LPARAM")!=0)
			|| strstr(current, "FAR*") || strstr(current, "_huge*"))
		    argi[i] = - data_types[j].size;
		break;
	    }
	}
    }

    for ( j=0 ; ; j++) {
	list = windows_dll[j].name;
	if (list == NULL) {
	    printf("\nfunction not found '%s'\n\n", fname);
	    return FALSE;
	}
	if (stricmp(list, fname) == 0) {
	    function_index_windll = j;
	    break;
	}
    }
    return TRUE;
}

static int printbody(char *linebuf)
{
    int i,size;
    FILE *fh;

    if (openmode) {
	char name1[25];
	char name2[25];
	int x = windows_dll[function_index_windll].fcntno;

	strcpy(name1, windows_dll[function_index_windll].module);
	name1[5] = '\0';

	sprintf(name2, "%d", x);
	if (x<100)
	    strcat(name1, "0");
	if (x<10)
	    strcat(name1, "0");
	strcat(name1, name2);
	strcat(name1, ".c");
	printf("open file %s\n", name1);

	fh = fopen(name1, "wt");

	fprintf(fh, "#define STRICT\n");
	fprintf(fh, "#include <windows.h>\n");
	fprintf(fh, "#include <sys/rsxw32.h>\n\n");
    }
    else
	fh = stdout;

    if (args == 1 && strcmp(argp[1],"void")==0) {
	fprintf(fh, "%s\n", linebuf);
	sum = args = 0;
    }
    else {
	fprintf(fh, "%s WINAPI %s (", argp[0], fname);
	for (i = 1; i < args ; i++)
	    fprintf(fh, "%s par%d, ", argp[i], i);
	fprintf(fh, "%s par%d)\n" , argp[i], i);
    }

    fprintf(fh, "{\n");

    if (sum) {
	fprintf(fh, "    STACKWORDS(");
	for (i = 1; i < args; i++)
	    fprintf(fh, "%d+", (abs(argi[i])+1)>>1);
	fprintf(fh, "%d);\n\n", (abs(argi[i])+1)>>1);
    }
    else
	fprintf(fh, "    NOSTACK;\n\n");

    for (i = 1; i <= args; i++) {
	if (strcmp(argp[i] + strlen(argp[i]) - 4, "PROC") == 0)
	    fputs("/* next parameter must converted */\n", fh);

	size = argi[i];
	if (size == 1 || size == 2)
	    fprintf(fh, "    PUSH_WORD(par%d);\n", i);
	else if (size == 4)
	    fprintf(fh, "    PUSH_LONG(par%d);\n", i);
	else if (size < 0)
	    fprintf(fh, "    PUSH_LPSTR(par%d);\n", i);
	else
	    fprintf(fh, "    PUSH ??? %d,\n",size);
    }

    if (strcmp(argp[0],"void")==0 || strcmp(argp[0],"VOID")==0)
	fprintf(fh, "    " );
    else
	fprintf(fh, "    return " );

    if (strcmp(argp[0],"LPSTR")==0 || strstr(argp[0],"FAR*")!=NULL) {
	fprintf(fh, "_rsx_16to32(WINCALL(%3d,%s));\n",
	    windows_dll[function_index_windll].fcntno,
	    windows_dll[function_index_windll].module);
    } else {
	fprintf(fh, "WINCALL(%3d,%s);\n",
	    windows_dll[function_index_windll].fcntno,
	    windows_dll[function_index_windll].module);
    }
    fprintf(fh, "}\n\n");

    if (openmode)
	fclose (fh);
    return 0;
}

int main(int argc, char **argv)
{
    static char linebuf[512];
    static char argsbuf[512];

    FILE *fhandle;
    int chars=0;

    if (argc < 2) {
	puts("usage: HEADER windows.h");
	exit(1);
    }
    if (argv[2] && (strcmp(argv[2], "-open") == 0))
	openmode = 1;
    else
	openmode = 0;

    fhandle = fopen(argv[1], "rt");

    printf("/* This is the file %s */\n\n", argv[1]);

    for (;;) {
	if ((chars = readline(fhandle, linebuf)) < 0)
	    break;
	else if (chars == 0)
	    continue;

	if (find_winapi(linebuf, argsbuf) == FALSE)
	    continue;
	remove_argnames();
	if (searchlist() == TRUE)
	    printbody(linebuf);
    };

    fclose(fhandle);
    return 0;
}
