#define NOGDICAPMASKS		/* CC_~, LC_~, PC_~, CP_~, TC_~, RC_	*/
#define NOVIRTUALKEYCODES	/* VK_~ 				*/
#define NOSYSMETRICS		/* SM_~ 				*/
#define NOMENUS 		/* MF_~ 				*/
#define NOKEYSTATES		/* MK_~ 				*/
#define NOSYSCOMMANDS		/* SC_~ 				*/
#define NORASTEROPS		/* Binary and Tertiary raster ops	*/
#define OEMRESOURCE		/* OEM Resource values			*/
#define NOATOM			/* Atom Manager routines		*/
#define NOCLIPBOARD		/* Clipboard routines			*/
#define NOCTLMGR		/* Control and Dialog routines		*/
#define NODRAWTEXT		/* DrawText() and DT_~			*/
#define NOMETAFILE		/* typedef METAFILEPICT 		*/
#define NOMINMAX		/* Macros min(a,b) and max(a,b) 	*/
#define NOOPENFILE		/* OpenFile(), OemToAnsi,  and OF_~	*/
#define NOSCROLL		/* SB_~ and scrolling routines		*/
#define NOSOUND 		/* Sound driver routines		*/
#define NOTEXTMETRIC		/* typedef TEXTMETRIC and assoc. routines */
#define NOWH			/* SetWindowsHook and WH_~		*/
#define NOCOMM			/* COMM driver routines 		*/
#define NOKANJI 		/* Kanji support stuff. 		*/
#define NOHELP			/* Help engine interface.		*/
#define NOPROFILER		/* Profiler interface.			*/
#define NODEFERWINDOWPOS	/* DeferWindowPos routines		*/

#define STRICT
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <sys/port.h>

/* small changes for GCC */
#ifdef __GNUC__
#define __LARGE__
#define lstrcpy strcpy
#endif

LRESULT CALLBACK _export
 WndProc(HWND hWnd, UINT iMessage, WPARAM wParam, LPARAM lParam);

class Main
{
    public:
    static HINSTANCE hInstance;
    static HINSTANCE hPrevInstance;
    static INT nCmdShow;
    static INT MessageLoop(void);
};

class Window
{
    protected:
    HWND hWnd;
    public:
    HWND GetHandle(void) {
	return hWnd;
    }

    BOOL Show(INT nCmdShow) {
	return ShowWindow(hWnd, nCmdShow);
    }
    void Update(void) {
	UpdateWindow(hWnd);
    }
    virtual long WndProc(UINT iMessage, WPARAM wParam, LPARAM lParam) = 0;
};

static char szClassName[14] = "Hello, World!";

class MainWindow:public Window
{
    public:
    static void Register(void) {
	WNDCLASS wndclass;

	 wndclass.style = CS_HREDRAW | CS_VREDRAW;
	 wndclass.lpfnWndProc =::WndProc;
	 wndclass.cbClsExtra = 0;
	 wndclass.cbWndExtra = sizeof(MainWindow *);
	 wndclass.hInstance = Main::hInstance;
	 wndclass.hIcon = LoadIcon(Main::hInstance, "whello");
	 wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	 wndclass.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	 wndclass.lpszMenuName = NULL;
	 wndclass.lpszClassName = szClassName;

	if (!RegisterClass(&wndclass))
	     exit(FALSE);
    }

     MainWindow(void) {
	hWnd = CreateWindow(szClassName,
			    szClassName,
			    WS_OVERLAPPEDWINDOW,
			    CW_USEDEFAULT,
			    CW_USEDEFAULT,
			    CW_USEDEFAULT,
			    CW_USEDEFAULT,
			    NULL,
			    NULL,
			    Main::hInstance,
			    (LPSTR) this);
	if (!hWnd) {
	    MessageBox(NULL, "CreateWindow", NULL, MB_OK);
	    exit(FALSE);
	}
	 Show(Main::nCmdShow);
	Update();
    }
    long WndProc(UINT iMessage, WPARAM wParam, LPARAM lParam);

    void Paint(void);
};

HINSTANCE Main::hInstance = 0;
HINSTANCE Main::hPrevInstance = 0;
INT Main::nCmdShow = 0;

INT Main::MessageLoop(void)
{
    MSG msg;

    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return msg.wParam;
}

void MainWindow::Paint(void)
{
    PAINTSTRUCT ps;

    static char message[] =
    "GNU C/C++ opens the World of 32-bit Windows Programming!";

    BeginPaint(hWnd, &ps);

    TextOut(ps.hdc, 10, 10, message, sizeof(message) - 1);

    EndPaint(hWnd, &ps);
}



long MainWindow::WndProc(UINT iMessage, WPARAM wParam, LPARAM lParam)
{
    switch (iMessage) {
	case WM_CREATE:
	break;
    case WM_PAINT:
	Paint();
	break;
    case WM_DESTROY:
	PostQuitMessage(0);
	break;
    default:
	return DefWindowProc(hWnd, iMessage, wParam, lParam);
    }
    return 0;
}


#if defined(__SMALL__) || defined(__MEDIUM__)
inline Window *GetPointer(HWND hWnd)
{
    return (Window *) GetWindowWord(hWnd, 0);
}
inline void SetPointer(HWND hWnd, Window * pWindow)
{
    SetWindowWord(hWnd, 0, (WORD) pWindow);
}
#elif defined(__LARGE__) || defined(__COMPACT__)
inline Window *GetPointer(HWND hWnd)
{
    return (Window *) GetWindowLong(hWnd, 0);
}
inline void SetPointer(HWND hWnd, Window * pWindow)
{
    SetWindowLong(hWnd, 0, (LONG) pWindow);
}
#endif

LRESULT CALLBACK _export WndProc(HWND hWnd, UINT iMessage, WPARAM wParam,
				  LPARAM lParam)
{
    Window *pWindow = GetPointer(hWnd);

    if (pWindow == 0) {
	if (iMessage == WM_CREATE) {
	    LPCREATESTRUCT lpcs;

	    lpcs = (LPCREATESTRUCT) LONG2PTR(lParam);	/* gcc changes */
	    pWindow = (Window *) FAR2PTR(lpcs->lpCreateParams);

	    SetPointer(hWnd, pWindow);

	    return pWindow->WndProc(iMessage, wParam, lParam);
	} else
	    return DefWindowProc(hWnd, iMessage, wParam, lParam);
    } else
	return pWindow->WndProc(iMessage, wParam, lParam);
}

INT PASCAL WinMain(
		       HINSTANCE hInstance,
		       HINSTANCE hPrevInstance,
		       LPSTR lpszCmdLine,
		       INT nCmdShow)
{
  Main::hInstance = hInstance;
  Main::hPrevInstance = hPrevInstance;
  Main::nCmdShow = nCmdShow;

  if (!Main::hPrevInstance) {
      MainWindow::Register();
    }
    MainWindow MainWnd;

  return Main::MessageLoop();
}
