#!/bin/sh
# original mktexmf -- make a new MF file, because one wasn't found.
# 
# (If you change or delete the word `original' on the previous line,
# installation won't write this script over yours.)
# 
# te@informatik.uni-hannover.de, kb@mail.tug.org, and infovore@xs4all.nl.
# Public domain.

version='$Id: mktexmf,v 1.13 1998/02/20 16:26:17 olaf Exp $'
progname=`echo $0 | sed 's%.*/%%'`
usage="Usage: $progname FONT.

Makes the Metafont source file for FONT, if possible. For example,
\`ecr12' or \`cmr11'."

# Common code for all scripts.
: ${MT_TEXMFMAIN=`kpsewhich --expand-path='$TEXMFMAIN'`}
: ${MT_MKTEX_OPT=`kpsewhich --format='web2c files' mktex.opt`}
test -n "$MT_MKTEX_OPT" || MT_MKTEX_OPT="$MT_TEXMFMAIN/web2c/mktex.opt"
if test ! -f "$MT_MKTEX_OPT"; then
  echo "$progname: Cannot find mktex.opt; check your installation." >&2
  exit 1
fi

. "$MT_MKTEX_OPT"

(
# See comments in mktexpk.
name="`echo $1 | sed 's%.*/%%; s%\.mf$%%'`"
rootname=`echo "$name" | sed 's/[0-9]*$//'`
pointsize=`echo "$name" | sed "s/^$rootname//"`

sauterroot=`kpsewhich b-$rootname.mf 2>/dev/null`
if test -n "$sauterroot"; then
  rootfile=$sauterroot
else
  case $rootname in
    wn*)
       lhname=`echo $name | sed 's/^wn/lh/'`
       rootfile=`kpsewhich $lhname.mf 2>/dev/null`;;
    *)
       rootfile=`kpsewhich $rootname.mf 2>/dev/null`;;
  esac
fi
{ test -z "$rootfile" || test ! -f "$rootfile"; } && exit 1

#if test -z "$MT_MFNAME"; then
OIFS=$IFS; IFS=$SEP
set x `"$MT_MKTEXNAM" $name`; shift
IFS=$OIFS
MT_MFNAME="$3"
#fi

destdir=`echo "$MT_MFNAME" | sed 's%/[^/][^/]*$%%'`
test -d "$destdir" || "$MT_MKTEXDIR" "$destdir" || exit 1
cd "$destdir" >/dev/null 2>&1 || exit 1

case "$pointsize" in
  "") echo "$progname: no pointsize."; exit 1;;
  11) realsize=10.95444;;      # \magstephalf
  14) realsize=14.4;;  # \magstep2
  17) realsize=17.28;; # \magstep3
  20) realsize=20.74;; # \magstep4
  25) realsize=24.88;; # \magstep5
        # The new convention is to have three or four letters for the
        # font name and four digits for the pointsize. The number is
        # pointsize * 100. We effectively divide by 100 by ignoring the
        # last two digits.
  ????|?????) realsize=`echo "$pointsize" | sed 's/\(..\)$/.\1/'`;;
  *) realsize="$pointsize";;
esac

mfname="$name.mf"
if test -r "$mfname"; then
  echo "$progname: $destdir/$mfname already exists."
  echo "$destdir/$mfname" >$STDOUT
  "$MT_MKTEXUPD" "$destdir" "$mfname"
  exit 0
fi

case "$name" in
  ec*|tc*)
    cat > "mf$$.tmp" <<END
if unknown exbase: input exbase fi;
gensize:=$realsize;
generate $rootname;
END
    ;;
  dc*)
    cat > "mf$$.tmp" <<END
if unknown dxbase: input dxbase fi;
gensize:=$realsize;
generate $rootname;
END
    ;;
  wn*)
    cat > "mf$$.tmp" <<END
wncoding:=1;
input $lhname;
END
    ;;
  *)
    cat > "mf$$.tmp" <<END
design_size := $realsize;
input b-$rootname;
END
    ;;
esac

chmod `kpsestat -xst,go-w .` "mf$$.tmp"
rm -f "$mfname"
mv "mf$$.tmp" "$mfname"

echo "$destdir/$mfname" >$STDOUT
echo "$progname: $destdir/$mfname: successfully generated." >&2
"$MT_MKTEXUPD" "$destdir" "$mfname"
exit 0
) 1>&2 </dev/null
