#!/bin/sh
#-*-tcl-*-
# the next line restarts using wish \
exec wish "$0" ${1+"$@"}

set dir [file dirname [info script]]
wm withdraw .

#tk_messageBox -title "$argc $argv"
# We do this so we don't have to mess with Windows native-names
# which use backslashes which Tcl doesn't like.
if {$argc == 1} {
    set name [file nativename [lindex $argv 0]]
} elseif {$argc > 1} {
    set name [file nativename [join $argv " "]]
}
# So we can handle relative path names in the
# startup sequence.
if {[info exists name]} {
    if {[file pathtype $name] == "relative"} {
	set name [file join [pwd] $name]
    }
}

switch -- $tcl_platform(platform) {
    "unix" {
	switch -- $argc {
	    0 {
		if {[lsearch -exact [winfo interps] "alpha"] == -1} {
		    # startup the application
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl &
		}
	    }
	    1 {
		if {[lsearch -exact [winfo interps] "alpha"] == -1} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl [list edit $name] &
		} else {
		    # can't use async because this script ends and the connection
		    # is aborted too early
		    send alpha [list edit $name]
		}
	    }
	    default {
		if {[lsearch -exact [winfo interps] "alpha"] == -1} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl [list edit $name] &
		} else {
		    # can't use async because this script ends and the connection
		    # is aborted too early
		    send alpha [list edit $name]
		}
		#error "Bad arguments $argv to 'alpha'.  Only one argument allowed"
	    }
	}
    }
    "windows" {
	package require dde
	switch -- $argc {
	    0 {
		# startup the application
		if {[lsearch -exact [dde services TclEval ""] {TclEval Alpha}] == -1} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl &
		}
	    }
	    1 {
		if {[lsearch -exact [dde services TclEval ""] {TclEval Alpha}] == -1} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl [list edit $name] &
		} else {
		    # can't use async because this script ends and the connection
		    # is aborted too early
		    dde execute TclEval Alpha [list edit $name]
		}
	    }
	    default {
		if {[lsearch -exact [dde services TclEval ""] {TclEval Alpha}] == -1} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl [list edit $name] &
		} else {
		    # can't use async because this script ends and the connection
		    # is aborted too early
		    dde execute TclEval Alpha [list edit $name]
		}
		#error "Bad arguments $argv to 'alpha'.  Only one argument allowed"
	    }
	}
    }
    "macintosh" {
	switch -- $argc {
	    0 {
		# startup the application
		cd $dir
		exec [info nameofexecutable] alphatk.tcl &
	    }
	    1 {
		package require Comm 3
		if {[catch {comm connect 1197}]} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl [list edit $name] &
		} else {
		    # can't use async because this script ends and the connection
		    # is aborted too early
		    comm send 1197 [list edit $name]
		}
	    }
	    default {
		package require Comm 3
		if {[catch {comm connect 1197}]} {
		    cd $dir
		    exec [info nameofexecutable] alphatk.tcl [list edit $name] &
		} else {
		    # can't use async because this script ends and the connection
		    # is aborted too early
		    comm send 1197 [list edit $name]
		}
		#error "Bad arguments $argv to 'alpha'.  Only one argument allowed"
	    }
	}
    }
    default {
	error "No known platform"
    }
}

exit
