/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TexSpecialCharRule
implements IPredicateRule {
    private IToken successToken;
    private char startChar = (char)92;
    private List<Character> endChars;

    public TexSpecialCharRule(IToken token) {
        this.successToken = token;
        this.initChars();
    }

    private void initChars() {
        this.endChars = new ArrayList<Character>();
        this.endChars.add(Character.valueOf('\\'));
        this.endChars.add(Character.valueOf('_'));
        this.endChars.add(Character.valueOf('$'));
        this.endChars.add(Character.valueOf(' '));
        this.endChars.add(Character.valueOf('\n'));
        this.endChars.add(Character.valueOf('\t'));
        this.endChars.add(Character.valueOf('\r'));
        this.endChars.add(Character.valueOf('{'));
        this.endChars.add(Character.valueOf('}'));
        this.endChars.add(Character.valueOf('!'));
        this.endChars.add(Character.valueOf('.'));
        this.endChars.add(Character.valueOf(','));
        this.endChars.add(Character.valueOf('?'));
        this.endChars.add(Character.valueOf('\"'));
        this.endChars.add(Character.valueOf('\u00a3'));
        this.endChars.add(Character.valueOf('%'));
        this.endChars.add(Character.valueOf('^'));
        this.endChars.add(Character.valueOf('&'));
        this.endChars.add(Character.valueOf('*'));
        this.endChars.add(Character.valueOf(':'));
        this.endChars.add(Character.valueOf(';'));
        this.endChars.add(Character.valueOf('@'));
        this.endChars.add(Character.valueOf('\''));
        this.endChars.add(Character.valueOf('#'));
        this.endChars.add(Character.valueOf('~'));
        this.endChars.add(Character.valueOf('/'));
        this.endChars.add(Character.valueOf('+'));
        this.endChars.add(Character.valueOf('|'));
        this.endChars.add(Character.valueOf('<'));
        this.endChars.add(Character.valueOf('>'));
        this.endChars.add(Character.valueOf('='));
        this.endChars.add(Character.valueOf('\uffff'));
        Collections.sort(this.endChars);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.evaluateNext(scanner)) {
                return this.successToken;
            }
            return Token.UNDEFINED;
        }
        return this.evaluate(scanner);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == this.startChar && this.evaluateNext(scanner)) {
            return this.successToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean evaluateNext(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1) {
            if (Collections.binarySearch(this.endChars, Character.valueOf((char)c)) >= 0) {
                return true;
            }
            scanner.unread();
        }
        return false;
    }
}

