/* tl2.c this is part of the package "tex2latex"
    Copyright (C) 1998 Pedro Fortuny.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file readme.t2l to know how to use this program. And how you
   can support me :-)


    Pedro Fortuny. Dpto. Algebra. Universidad de Valladolid. Spain.
    pfortuny@vax631.cpd.uva.es

*/


/*t2l.c this files contains the main functions of the program tex2ltx,
  namely:
        give_format
        principal
        main

  see the notes in each function.*/



#include <stdio.h>
#include <string.h>
/* #include <dir.h> */
#include "t2l.h"
typedef struct environment{ /* this is for nested things, p. e. */
           char name[64];                /* \proclaim and itemize... */
           struct environment *next;
           struct environment *previous;
} env;


int principal(char orig[],char dest[],char bibl,char bibliog[]);
/* principal is 'main' in spanish :-)*/

void give_format(FILE *file);
/* give_format: */
/* simply puts the usual preamble in an AMS-LaTeX article */

void references(char file[],char destination_file[]);
/* function defined in the file refs.c see info there */

int main(int argc,char *argv[]);
/* obviously this is the main function */

void give_format(FILE *file){
/* as you can see this gives the usual 'article' style to the destination */
/*   file (FILE *file) and puts the 'amslatex' inputs */

   fprintf(file,"%%document transformed from plain TeX to LaTeX\n");
   fprintf(file,"%%using tex2ltx. (c) P. Fortuny 1998\n");
   fprintf(file,"%%dpt. Algebra. univ. Valladolid. Spain.\n");
   fprintf(file,"%%pfortuny@vax631.cpd.uva.es\n");
   fprintf(file,"%%\n%%\n%%\n");
   fprintf(file,"\\documentclass{article}\n");
   fprintf(file,"\\usepackage{amsmath}%% t2l\n");
   fprintf(file,"\\usepackage{amsthm} %% t2l\n");
   fprintf(file,"\\usepackage{amsbsy} %% t2l\n");
   fprintf(file,"\\usepackage{amssymb}%% t2l\n");
   return;
}

int main(int argc,char *argv[]){
/* here we read the command-line options and give the files the proper     */
/*   names. as you will see, it is very meshy and very very 'ad hoc'. i    */
/*   am sorry not to be a very good programmer. there are no comments, for */
/*   the construction is obvious -if you know what is going on- and too    */
/*   complicated at the same time. too many nested 'if' and 'else'. sorry. */

   char destination[64],bibliography[64],bib,*auxiliary;
   int i;
   for(i=0;i<66;i++){
     bibliography[i]='\0';
     destination[i]='\0';
   }
   bib='n';
   if(argc==1){
       printf("TeX2LaTeX: intsructions:\n\n");
       printf("usage: tex2ltx  original file [latex file] [-b] [biblio file]\n");
       printf("       if you omit latex file the name of the destination one will\n");
       printf("       be the same as the original with the suffix '.ltx'\n\n");
       printf("       -b if you want the references to be converted to bib-tex format\n");
       printf("          in which case the biblio file will have either the name you\n");
       printf("          enter or the same as the original with the suffix '.bib'");
       exit(0);
   }
   if (fopen(argv[1],"r")==NULL){
           printf("Cannot find file ");
           printf("%s",argv[1]);
           exit(0);
   }
   if(argc>=3){
       if (!strcmp(argv[2],"-b")){
           bib='y';
           auxiliary=strchr(argv[1],'.');
           if (auxiliary==NULL){
               strcpy(destination,argv[1]);
               strcat(destination,".ltx");
           }
           else{
               for(i=0;i<(auxiliary-&(argv[1][0]));i++){
                   destination[i]=argv[1][i];
               }
               strcat(destination,".ltx");
           }
           if(argc==3){
               auxiliary=strchr(argv[1],'.');
               if (auxiliary==NULL){
                   strcpy(bibliography,argv[1]);
                   strcpy(destination,argv[1]);
                   strcat(bibliography,".bib");
                   if(strchr(destination,'.')==NULL){
                       strcat(destination,".ltx");}
               }
               else{
                   for(i=0;i<auxiliary-&(argv[1][0]);i++){
                       bibliography[i]=argv[1][i];
                       destination[i]=argv[1][i];
                   }
                   strcat(bibliography,".bib");
                   if(strchr(destination,'.')==NULL){
                       strcat(destination,".ltx");}
               }
           }
           else{
               strcpy(bibliography,argv[3]);
               bib='y';
           }
       }
       else{
           strcpy(destination,argv[2]);
           if(argc==3){ bib='n';}
           else{
               if (strcmp(argv[3],"-b")){
                   printf("error: write tex2ltx to see the syntax");
                   exit(0);
               }
               if(argc==4){
                   bib='y';
                   auxiliary=strchr(argv[1],'.');
                   for(i=0;i<(auxiliary-&(argv[1][0]));i++){
                       bibliography[i]=argv[1][i];
                   }
                   strcat(bibliography,".bib");
               }
               else{
                   bib='y';
                   strcpy(bibliography,argv[4]);
               }
           }
       }
   }
    if(argc==2){
        bib='n';
        auxiliary=strchr(argv[1],'.');
        if(auxiliary!=NULL){
            for(i=0;i<(auxiliary-&(argv[1][0]));i++){
            destination[i]=argv[1][i];}
        }
        else{strcpy(destination,argv[1]);}
        strcat(destination,".ltx");
   }
   if(!strcmp(argv[1],destination) || !strcmp(argv[1],bibliography)
      || !strcmp(destination,bibliography)){
          printf("Please, give different names to different files");
          exit(0);
      }
   principal(argv[1],destination,bib,bibliography);
   exit(0);
}

/*principal:
  the parameters: orig[] is the name of the source 'plain-TeX' (AMS) file.
                  dest[] is the name of the destination 'AMS-LaTeX' file.
                  bibl is 'y' or 'n' according as the user has asked to
                       build the bibliography in a separate file as a
                       BiB-TeX file or not.
                  bibliog[] is the name of the (optional) BiB-TeX file.
*/
int principal(char orig[],char dest[],char bibl,char bibliog[]){
   int *line_number; /* number of the line in orig[] */
   int newline;      /* ibid in dest */
   char being_red;   /* the character being read */
   char *word;       /* will be anything after a backslash -usually a TeX command */
   char *word_copy;  /* will be a copy of the previous one (or another word)*/
   char dos[64];   /* 64: i hope no one uses a so-long command word... */
   int a,b;          /* counters */
   char star;        /* the star '*' is a special character in the
                        replace.txt file -see there- */
   char backwards;   /* a char -sometimes -in the '*' case we will have to
                        read the file orig[] backwards */
   int back;         /* a counter to know hoy many chars we have gone back */
   FILE *original_file=fopen(orig,"r");
   FILE *replace_file=fopen(("replace.t2l"),"r"); /* name of the 'how to change
                                                   things' file */
   FILE *destination_file=fopen(dest,"w");
   FILE *log_file=fopen("t2l.log","w");         /* we keep errors and warnings
                                                in t2l.log */
   env *environ;
   char last_one[64];
   if(replace_file==NULL){
      printf("Cannot find replace.t2l. Please, include its path into the PATH\n");
      printf("environmental variable.\nThank you.");
      exit(0);
   }
   *line_number=1;
   newline=13;
   printf("This is tex2ltx\n");
   fprintf(log_file,"This is tex2ltx\n");
   give_format(destination_file);  /* write the header */
   fread(&being_red,1,1,original_file);   /* begin: we read char by char */
   while (!feof(original_file))    /* work all the file over */
     {
     fwrite(&being_red,1,1,destination_file); /* and write anything in dest[] */

     /* next lines: show a message each 50 lines to unnerve the user */
     if(being_red=='\n'){
       newline++;
       *line_number=(*line_number)+1;
        if(*line_number/50*50==*line_number)printf("[line:%i-->%i]",*line_number,newline);
/*        fflush(stdout);*/
       }

     /* now we find a possible Plain command */
     if(being_red=='\\')
       {word=(char *)malloc(64);      /* i hope no one uses commands more than
                                         64 chars long */
       redword(original_file,word);   /* read the 'command' and keep it in word */
       a=rplace(destination_file,replace_file,word);  /* replace if necessary.
                                                         and give 'a' a value according
                                                         to the kind of change.
       the cases a==sth etc... are explained in "rplace", which
       is defined in the file change.c */
           if(word[0]=='0'){
                   fwrite("end{",4,1,destination_file);
                   warning("IMPORTANT: MAYBE YOU HAVE TO CREATE A\n
                   \\newtheorem{foo}[counter]{Foo} AT THE PREAMBLE, \n
                   WHERE {foo} STANDS FOR A SUITABLE NAME (FOR COMPLING)b\n
                   counter STANDS FOR A NAME OF A COUNTER (IF ANY)\n
                   AND Foo STANDS FOR THE WORD APPEARING IN THE NEXT WARNING",
                   log_file,line_number,&newline);
                   warning(&last_one,log_file,line_number,&newline);
                   fwrite(last_one,strlen(last_one),1,destination_file);
                   fwrite("}",1,1,destination_file);
                }
       if(a==INSERT_COMMENT){
          warning("% Inserted before useless?? command -see next warning",
                    log_file,line_number,&newline);
          warning(word,log_file,line_number,&newline);
          fseek(destination_file,-1,SEEK_CUR); /* do not miss characters */
          fwrite("%\\",2,1,destination_file);
          fwrite(word,strlen(word)-1,1,destination_file);
          difficult(original_file,orig,destination_file,
                    replace_file,log_file,"||\n",line_number,&newline,last_one);
          }
       if(a==ERASE_LINE){
          eliminate(orig,log_file,word,line_number,&newline);
          }
       if(a==TEXTandNUMBER){
          something_between_braces(original_file,
                                   destination_file,log_file,line_number,
                                   &newline,number,text0);
          }    /* the number,text0, means: look for a number and afterwards a name:*/
               /* the typical example being \hskip 3pt */
       if(a==TEXTNUMBER){
          something_between_braces(original_file,destination_file,
                                   log_file,line_number,
                                   &newline,0,text1);
          }    /* the 0,text1 means: look for a word of the form 'name.sth' or */
               /* simply 'name', for example as in \input amstex.tex */
       if(a==SPECIAL){
          difficult(original_file,orig,destination_file,
                                   replace_file,log_file,word,line_number,
                                   &newline,last_one);
          }
       if(a==noTEXT){
          something_between_braces(original_file,destination_file,
                                   log_file,line_number,
                                   &newline,0,text2);
          }
       /* next case is very special. i think this is not a good place to
          handle it, but here it is. we have found a star '*'
          ind replace.txt and have to go back till we find a '{', then
          put the chars from this brace to the present place (that is the
          use of variable "back") between braces, then write the new command
          in dest[] and put anything that comes after between braces, until
          we find the closing '}' in orig[]. The example (up to date unique)
          is:
              {something \over anotherthing}
          which has to be converted into
              \frac{something}{anotherthing}
          IMPORTANT: THIS IS NOT RECURSIVE, SO NESTED '\over's ARE NOT
          PROPERLY HANDED. P.E.
              {{3 \over 2}\over{4 over 7}}
          WILL GIVE STH. LIKE
              \fra\frac{2}3\frac{4 \over 7}
          OR SIMILAR (I DO NOT KNOW... :-(
       */
       if(a==STAR){
          back=0;
/*          fflush(stdout);*/
          b=strlen(word);
          fseek(replace_file,-b-1,SEEK_CUR);
          fread(&star,1,1,replace_file);
          fread(&b,1,1,replace_file);
          redword(replace_file,dos);
          b=b-48;  /* convert chars into real numbers */
          fseek(original_file,-b-2,SEEK_CUR);
          fseek(destination_file,-1,SEEK_CUR);
          back++;
          fread(&backwards,1,1,original_file);
          while(backwards!='{'){
            fseek(original_file,-2,SEEK_CUR);
            fseek(destination_file,-1,SEEK_CUR);
            back++;
            fread(&backwards,1,1,original_file);
            }
          fwrite("\\",1,1,destination_file);
          fwrite(dos,strlen(dos)-1,1,destination_file);
          fwrite("{",1,1,destination_file);
          while(back>1){
            fread(&star,1,1,original_file);
            fwrite(&star,1,1,destination_file);
            back=back-1;
            }
          fread(&star,1,1,original_file);
          fwrite("}{",2,1,destination_file);
          fseek(original_file,b,SEEK_CUR);
          fread(&star,1,1,original_file);
          fwrite(&star,1,1,destination_file);
          while(star!='}'){
            fread(&star,1,1,original_file);
            fwrite(&star,1,1,destination_file);
            }
          fwrite("}",1,1,destination_file);
          }
       /* now come the bibliography cases */
       /* we change the original and destination files:
          t2l.aux is first made to make the Plain-Latex
          changes that may appear in the bibliography
          and to change the bib commands (\ref,\paper....)
          into temporary local commands (@key...) see replace.t2l
          then  we make the BiB-TeX file.
          t2l.aux is then useless and can (recommended) be
          deleted
       */
       if(a==BEGIN_BIBLIO && bibl=='y'){
        fwrite("end{document}",13,1,destination_file);
        fclose(destination_file);
        fclose(destination_file);
        destination_file=fopen("t2l.aux","w");
          }
       if(a==END_BIBLIO && bibl=='y'){
       fclose(original_file);
       fclose(log_file);
       fclose(replace_file);
       references(bibliog,orig); /* make the BiB-TeX file */
       break;
       }
       if((a==BEGIN_BIBLIO) && (bibl!='y')){
         warning("Skipping the bibliography.",
                    log_file,line_number,&newline);
         goto skip;
      }
      /*VERY IMPORTANT: I HAVE TO TELL HIM TODO NOTHING WITH THE REFS IF THE*/
      /*USERS SAYS NOTHING REGARDING THE BIBLIOGRAPHY*/
     }
      fread(&being_red,1,1,original_file);  /* read char by char */
   }
skip:
       fwrite("end{document}",13,1,destination_file);
       fclose(destination_file);

   /* now put the final comments in t2l.log and in stdout */
   if(bibl=='y'){   log_file=fopen("t2l.log","a");}
   /* the previous line is compulsory in order not to destroy t2l.log
      or to get undesired output */
   fprintf(log_file,"\nYou want to revise the preamble:\n\n\t
   -All parameters concerning the author, address, mail... must be\n\t
   in the same command, like this:\n\t\t
   \\author{P. Paul\\\\U. Knighted. Los Angeles (CA)\\\\\n
   \t\te-mail:ppaul@disjoint.uknighted.edu}\n\t
   -If there is an \\abstract, you have to put it after the \\begin{document}.\n");
   fprintf(log_file,"\n\tAnd, if there is an \\input of the form ams... which has
   not a comment like %t2l afterwards, please suppress it with a %% for it
   calls AMS-TeX and may cause problems.");
    printf("\nYou want to revise the preamble:\n\n\t
   -All parameters concerning the author, address, mail... must be\n\t
   in the same command, like this:\n\t\t
   \\author{P. Paul\\\\U. Knighted. Los Angeles (CA)\\\\\n
   \t\te-mail:ppaul@disjoint.uknighted.edu}\n\t
   -If there is an \\abstract, you have to put it after the \\begin{document}.\n");
   printf("\n\n\tAnd, if there is an \\input of the form ams... which has
   not a comment like %t2l afterwards, please suppress it with a %% for it
   is of AMS-TeX and may cause problems.\n");
   if(bibl!='y') printf("\nDestination file: %s\n\n",dest);
   if(bibl=='y') printf("\nDestination file:%s; Bibliography:%s\n\n",dest,bibliog);

   fprintf(log_file,"Thank you for using tex2latex.\nEnd of file t2l.log");
   printf("Thank you for using tex2latex.\nEnd of tex2ltx\nErrors and warnings: t2l.log\n");
   fclose(destination_file);
   fclose(original_file);
   fclose(log_file);
   fclose(replace_file);
   exit(0);
}
