/* refs.c  this file is part of the package "plain2latex" (c)
   1998 Pedro Fortuny
   Dpto. Algebra, Univ. Valladolid. Spain.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file readme.t2l to know how to use this program. And how you
   can support me :-)


    Pedro Fortuny. Dpto. Algebra. Universidad de Valladolid. Spain.
    pfortuny@vax631.cpd.uva.es

*/

#include <stdio.h>
#include <string.h>


void write_field(FILE *destination,char str[],char type[]);
   /* writes "type={  str  },\n   basically in the BiB-TeX file */


void seek_tab(FILE *origin,char string[]);
   /*   seeks for a '@' in the aux file: it comes always before */
   /*   bibliography commands (is inserted before)              */


void quit_spaces(char str[]);
   /* eliminates undesired spaces at the beginning and end of str */



int length(char str[]);
   /* useless but used ;-)  returns the length of str, which may   */
   /* contain spaces... created while debugging and not eliminated */
   /* from the functions -it works, however.                       */

void bib_commas(char bib_file[]);
   /* quit possible commas in the keys of the Bib-Tex file         */

void ini (char *str,int len);
   /* initialize string str with length len to all \0 */

/* references: the main file of the bibliography part */
void references(char file[],char ltx_file[]){
typedef struct cite{
    char type[10];
    char title[512];
    char author[256];
    char key[32];
    char publisher[64];
    char year[6];
    char journal[64];
    char comment[128];
    char volume[5];
    char series[32];
    char number[10];
    char pages[10];
    char address[64];
    struct cite *siguiente; /* we are to make a chain of cites */
} cite;
cite *comienzo,*fin;
int cambio;
int commas;      /* if i find commas in the keys, i have to re-build the .bib and */
int counter;     /* re-compile the .ltx file to quit them from the \cite's        */
char being_red;
char word[64];
char actual_author[256];
char actual_key[32];
FILE *original_file=fopen("t2l.aux","r");
FILE *destination_file=fopen(file,"w");
   comienzo=(cite *)malloc(sizeof(cite));
   fin=comienzo;
   fread(&being_red,1,1,original_file);
   cambio=1;
   while (!feof(original_file)){   /*important: refs need not be at the end*/
     if(cambio==1){
       ini(fin->type,10);
       ini(fin->key,32);
       ini(fin->author,256);
       ini(fin->title,512);
       ini(fin->address,64);
       ini(fin->year,6);
       ini(fin->journal,64);
       ini(fin->comment,128);
       ini(fin->pages,10);
       ini(fin->number,10);
       ini(fin->volume,5);
       ini(fin->series,32);
       ini(fin->publisher,64);
       fin->siguiente=NULL;
       cambio=0;
     }
     if(being_red=='@'){ /* call the special functions */
         redword(original_file,word);
         if (!strcmp(word,"kex\n"))
           {seek_tab(original_file,fin->key);
           strcpy(actual_key,fin->key); /* keep track of the key in case */
                                        /* there is a \moreref or a      */
                                        /* \bysame                       */
           }
         if(!strcmp(word,"by\n"))
           {seek_tab(original_file,fin->author);
            strcpy(actual_author,fin->author); /* ibid of the author */
           }
         if(!strcmp(word,"bysame\n"))
           {seek_tab(original_file,fin->author); /* here is the kept track */
            strcpy(fin->author,actual_author);
            strcpy(fin->key,actual_key);
           }
         if(!strcmp(word,"year\n"))
           {seek_tab(original_file,fin->year);
           }
         if(!strcmp(word,"publisher\n"))
           {seek_tab(original_file,fin->publisher);
           }
         if(!strcmp(word,"note\n"))
           {seek_tab(original_file,fin->comment);
           }
         if(!strcmp(word,"journal\n"))
           {seek_tab(original_file,fin->journal);
           }
         if(!strcmp(word,"volume\n"))
           {seek_tab(original_file,fin->volume);
           }
         if(!strcmp(word,"number\n"))
           {seek_tab(original_file,fin->number);
           }
         if(!strcmp(word,"series\n"))
           {seek_tab(original_file,fin->series);
           }
         if(!strcmp(word,"pages\n"))
           {seek_tab(original_file,fin->pages);
           }
         if(!strcmp(word,"book\n"))
           {seek_tab(original_file,fin->title);
            strcpy(fin->type,"book\n");
           }
         if(!strcmp(word,"article\n"))
           {seek_tab(original_file,fin->title);
            strcpy(fin->type,"article\n");
           }
         if(!strcmp(word,"address\n"))
           {seek_tab(original_file,fin->address);
           }
         if(!strcmp(word,"endref\n")){
           fin->siguiente=(cite *)malloc(sizeof(cite));
           fin=fin->siguiente;
           fin->siguiente=NULL;
           cambio=1;
           }
     }
/*this is the end of the special characters (if ...='\t') */
/*     else fwrite(&being_red,1,1,destination_file);      */
   fread(&being_red,1,1,original_file);
   }

/* now we go for the BibTex file */
   while(((comienzo->siguiente))!=NULL){
       for(counter=0;counter<32;counter++){
       if(*((comienzo->key)+counter)==',') commas=1; /* i have to change the commas by '-' */
       }
       for(counter=0;counter<10;counter++)
       if(strcmp(comienzo->type,"book\n")==0){
           fwrite("@BOOK{",6,1,destination_file);
           fprintf(destination_file,(comienzo->key));
           fwrite(",\n",2,1,destination_file);
       }
       if(strstr(comienzo->type,"article")!=NULL){
           fwrite("@ARTICLE{",9,1,destination_file);
           fprintf(destination_file,"%s",(comienzo->key));
           fwrite(",\n",2,1,destination_file);
       }
       write_field(destination_file,(comienzo->author),"author");
       write_field(destination_file,(comienzo->title),"title");
       write_field(destination_file,(comienzo->publisher),"publisher");
       write_field(destination_file,(comienzo->journal),"journal");
       write_field(destination_file,(comienzo->comment),"comment");
       write_field(destination_file,(comienzo->volume),"volume");
       write_field(destination_file,(comienzo->series),"series");
       write_field(destination_file,(comienzo->number),"number");
       write_field(destination_file,(comienzo->pages),"pages");
       write_field(destination_file,(comienzo->address),"address");
       write_field(destination_file,(comienzo->year),"year");
       if(comienzo->siguiente!=NULL){
       fwrite("}\n",2,1,destination_file);}
       comienzo=comienzo->siguiente;
   }
/*   fwrite("}\n",2,1,destination_file);*/
   if(commas==1){
       fclose(destination_file);
       /* fclose(ltx_file); */
       bib_commas(file);
       fclose(destination_file);
       remove(file);
       rename("bib.bib",file);
/*       ltx_commas(ltx_file);*/
   }
return;
}


void write_field(FILE *destination,char str[],char type[]){
    if(strlen(str)<1) return;
    fwrite(type,strlen(type),1,destination);
    fwrite("={",2,1,destination);
    quit_spaces(&str[0]);
    fwrite(str,strlen(str)-1,1,destination);
    fwrite("}\n",2,1,destination);
    return;
}

void seek_tab(FILE *origin,char string[]){
    int counter,another_c;
    char character;
    char word[512];
    counter=0;
    another_c=0;
    redspaces(origin,&character);
    fread(&character,1,1,origin);
    while((character!='@')){
        word[counter]=character;
        counter++;
/*        string[counter]=character;*/
        fread(&character,1,1,origin);
    }
    if(character=='@')fseek(origin,-1,SEEK_CUR);
    counter--;
    while(word[counter]==' ' || word[counter]=='\n') counter--;
/*    counter++;*/
    for(another_c=0;another_c<=counter;another_c++){
        string[another_c]=word[another_c];
    }
        string[another_c]='\n';
    return;
}

void quit_spaces(char str[]){
    int place;
    char variable[2056];
    place=0;
    while(str[place]==' ') place++;
    strcpy(variable,&str[place]);
    strcpy(str,variable);
    place=strlen(str);
    while(str[place]==' ') place--;
    str[place]='\0';
    return;
}

int length(char str[]){
int longitud;
longitud=0;
while(32<=str[longitud]) longitud++;
return longitud;
}

void bib_commas(char bib_file[]){
FILE *bib_copy;
FILE *bib=fopen(bib_file,"r");
char reading,next_char;
int counter;
bib_copy=fopen("bib.bib","w");
fread(&reading,1,1,bib);
fwrite(&reading,1,1,bib_copy);
while(!feof(bib)){
    if(reading!='@'){
        fread(&reading,1,1,bib);
        fwrite(&reading,1,1,bib_copy);
    }
    while((reading!='\n')&&(!feof(bib))){
        fread(&reading,1,1,bib);
        fwrite(&reading,1,1,bib_copy);
        if(reading==','){
            fread(&reading,1,1,bib);
            fwrite(&reading,1,1,bib_copy);
            if(reading!='\n'){
                fseek(bib_copy,-2,SEEK_CUR);
                fwrite("-",1,1,bib_copy);
                fwrite(&reading,1,1,bib_copy);
            }
        }
    }
}
fwrite(&reading,1,1,bib_copy);
fclose(bib_copy);
}


void ini(char *str,int len){
int i;
for(i=0;i<=len;i++){
    *(str+i)='\0';
}
*(str+i)='\0';
return;
}
