#!/bin/awk -f 

#
#   REFERENCES -- bibliographic software
#   Copyright (C) 1995-2006  Volker Kiefel
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#
#   sortrefs -- process and sort lines of a file generated by MFD SORT-01   
#
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f sortrefs.awk textfile
#
#
#    Versions:
#    31.7.2005: name of `ausgabedatei' may be changed (for References v4.2)
#


BEGIN {
  if (!output_file)
  {
    ausgabedatei = "sorted.tbt"
  } else
  {
    ausgabedatei=output_file
  }
  anzz = 0 # number of lines
  anzf = 0 # number of fields
  i = 0
}

{
   ein = $0
   if (length(ein)>0)
   {
     i++
     arr[i] = ein
   }
}

END {
  anzz = i
  for (i=1;i<=anzz;i++)
  {
    anzf = split(arr[i],temparr,"*")
    if (anzf >= 4)
    {
      zeile = sprintf("%-60s|%-60s|%-60s|%-20s",\
        strtoascii(temparr[2]),\
        strtoascii(temparr[3]),\
        strtoascii(temparr[4]),\
        temparr[1])
      arr[i] = zeile
    }
    else
    {
      print "\nInvalid sortrefs file: number of `*'-delimited fields is < 4\n"
      exit(1)
    }
  }
# either uncomment next line for gawk v3.1.1
# asort(arr)
# or this line for earlier versions of awk or Kerninghan's awk
  sorts(arr,anzz)
  for (i=1;i<=anzz;i++)
  {
    split(arr[i],temparr,"|")
    ausgabe = sprintf("*%s*%s|%s|%s*",substr(temparr[4],1,13),\
                                      substr(temparr[1],1,20),\
                                      substr(temparr[2],1,20),\
                                      substr(temparr[3],1,20))
    print ausgabe > ausgabedatei
  }
  print "\nData written into `" ausgabedatei "'\n"
  close(ausgabedatei)
}

function strtoascii(line)
{
   gsub(//,"ae",line)
   gsub(//,"oe",line)
   gsub(//,"ue",line)
   gsub(//,"ae",line)
   gsub(//,"oe",line)
   gsub(//,"ue",line)
   gsub(//,"ss",line)

   gsub(//,"a",line)
   gsub(//,"a",line)
   gsub(//,"a",line)
   gsub(//,"a",line)
   gsub(//,"a",line)
   gsub(//,"a",line)

   gsub(//,"e",line)
   gsub(//,"e",line)
   gsub(//,"e",line)
   gsub(//,"e",line)
   gsub(//,"e",line)
   gsub(//,"e",line)
   
   gsub(//,"i",line)
   gsub(//,"i",line)
   gsub(//,"i",line)
   gsub(//,"i",line)
   gsub(//,"i",line)
   gsub(//,"i",line)

   gsub(//,"o",line)
   gsub(//,"o",line)
   gsub(//,"o",line)
   gsub(//,"o",line)
   gsub(//,"o",line)
   gsub(//,"o",line)

   gsub(//,"u",line)
   gsub(//,"u",line)
   gsub(//,"u",line)
   gsub(//,"u",line)
   gsub(//,"u",line)
   gsub(//,"u",line)
   
   gsub(//,"c",line)
   gsub(//,"c",line)
   gsub(//,"aa",line)
   gsub(//,"aa",line)
   gsub(//,"ae",line)
   gsub(//,"ae",line)
   gsub(//,"n",line)
   gsub(//,"n",line)
   return toupper(line)
}

function sorts(ARRAY, ELEMENTS,        i, j, h, temp)
{
  h = 1;
  do {
    h *= 3 ;
    h++;
  } while (h <= ELEMENTS)

  do {
     h /= 3 ;
     h = int(h);

     for (i = h+1; i <= ELEMENTS; i++) {
        temp = ARRAY[i] ;
        j = i ;
        while (ARRAY[j-h] > temp) {
          ARRAY[j]=ARRAY[j-h] ;
          j -= h ;
          if (j <= h)  break;
        }
        ARRAY[j] = temp
     }
  } while (h > 1)
}

# vim:tw=2048
