#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#



BEGIN {
  a = ""
  max_records = 30
  outfle = ""
  printf("\n")
  i = 0 # count within a OOO macro file
  j = 0 # count for outfle names
  outfle_is_open = 0
  open_file()
  
}

{
  i++
  istring = 2*i ""
  
  a = $0
  str1 = "rem ----------------------------------------------------------------------\ndispatcher.executeDispatch(document, \".uno:GoToStartOfDoc\", \"\", 0, Array())\n\nrem ----------------------------------------------------------------------\ndim args:::argnummer:::(18) as new com.sun.star.beans.PropertyValue\nargs:::argnummer:::(0).Name = \"SearchItem.StyleFamily\"\nargs:::argnummer:::(0).Value = 2\nargs:::argnummer:::(1).Name = \"SearchItem.CellType\"\nargs:::argnummer:::(1).Value = 0\nargs:::argnummer:::(2).Name = \"SearchItem.RowDirection\"\nargs:::argnummer:::(2).Value = true\nargs:::argnummer:::(3).Name = \"SearchItem.AllTables\"\nargs:::argnummer:::(3).Value = false\nargs:::argnummer:::(4).Name = \"SearchItem.Backward\"\nargs:::argnummer:::(4).Value = false\nargs:::argnummer:::(5).Name = \"SearchItem.Pattern\"\nargs:::argnummer:::(5).Value = false\nargs:::argnummer:::(6).Name = \"SearchItem.Content\"\nargs:::argnummer:::(6).Value = false\nargs:::argnummer:::(7).Name = \"SearchItem.AsianOptions\"\nargs:::argnummer:::(7).Value = false\nargs:::argnummer:::(8).Name = \"SearchItem.AlgorithmType\"\nargs:::argnummer:::(8).Value = 0\nargs:::argnummer:::(9).Name = \"SearchItem.SearchFlags\"\nargs:::argnummer:::(9).Value = 65536\nargs:::argnummer:::(10).Name = \"SearchItem.SearchString\"\nargs:::argnummer:::(10).Value = \""
  gsub(/:::argnummer:::/,istring,str1)
  gsub(/\/\/\/A\/\/\//,str1,a)
  
  str2 = "\"\nargs:::argnummer:::(11).Name = \"SearchItem.ReplaceString\"\nargs:::argnummer:::(11).Value = \""
  gsub(/:::argnummer:::/,istring,str2)
  gsub(/\/\/\/B\/\/\//,str2,a)
  
  str3 = "\"\nargs:::argnummer:::(12).Name = \"SearchItem.Locale\"\nargs:::argnummer:::(12).Value = 255\nargs:::argnummer:::(13).Name = \"SearchItem.ChangedChars\"\nargs:::argnummer:::(13).Value = 2\nargs:::argnummer:::(14).Name = \"SearchItem.DeletedChars\"\nargs:::argnummer:::(14).Value = 2\nargs:::argnummer:::(15).Name = \"SearchItem.InsertedChars\"\nargs:::argnummer:::(15).Value = 2\nargs:::argnummer:::(16).Name = \"SearchItem.TransliterateFlags\"\nargs:::argnummer:::(16).Value = 1280\nargs:::argnummer:::(17).Name = \"SearchItem.Command\"\nargs:::argnummer:::(17).Value = 3\nargs:::argnummer:::(18).Name = \"Quiet\"\nargs:::argnummer:::(18).Value = true\n\ndispatcher.executeDispatch(document, \".uno:ExecuteSearch\", \"\", 0, args:::argnummer:::())\n\n"
  gsub(/:::argnummer:::/,istring,str3)
  gsub(/\/\/\/C\/\/\//,str3,a)
  
  print a > outfle

  if (i >= max_records)
  {
     close_file()
     open_file()
  }
}

END {
   if (outfle_is_open==1)
   {
     close_file()
   }
  printf("\n")
    
}



function open_file () {
  j++
  outfle = sprintf("ooo-mak%i.txt",j)
  print "REM  *****  BASIC  *****" > outfle
  print "" > outfle
  print "" > outfle
  print "sub Main" > outfle
  print "rem ----------------------------------------------------------------------" > outfle
  print "rem define variables" > outfle
  print "dim document   as object" > outfle
  print "dim dispatcher as object" > outfle
  print "rem ----------------------------------------------------------------------" > outfle
  print "rem get access to the document" > outfle
  print "document   = ThisComponent.CurrentController.Frame" > outfle
  print "dispatcher = createUnoService(\"com.sun.star.frame.DispatchHelper\")" > outfle
  print "" > outfle
  outfle_is_open = 1
}

function close_file() {
 
  print "end sub" > outfle
  printf "OOOrg/Star Writer macro " outfle " created\n"
  close(outfle)
  outfle_is_open = 0
  i = 0
}

