/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.ConditionReference;
import com.izforge.izpack.api.rules.RulesEngine;

public class RefCondition
extends ConditionReference {
    private static final long serialVersionUID = -2298283511093626640L;
    protected transient RulesEngine rules;
    private String referencedConditionId;

    public RefCondition(RulesEngine rules) {
        this.rules = rules;
    }

    public String getReferencedConditionId() {
        return this.referencedConditionId;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        this.referencedConditionId = xmlcondition.getAttribute("refid");
        if (this.referencedConditionId == null) {
            throw new Exception("Missing attribute \"refid\" in condition \"" + this.getId() + "\"");
        }
    }

    @Override
    public void resolveReference() {
        Condition condition = null;
        if (this.referencedConditionId != null) {
            condition = this.rules.getCondition(this.referencedConditionId);
        }
        if (condition == null) {
            throw new IzPackException("Referenced condition \"" + this.referencedConditionId + "\" not found");
        }
        this.setReferencedCondition(condition);
    }

    @Override
    public boolean isTrue() {
        Condition condition = this.getReferencedCondition();
        if (condition == null) {
            return false;
        }
        return condition.isTrue();
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        details.append(this.getReferencedCondition().getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        conditionRoot.setAttribute("refid", this.referencedConditionId);
    }

    public static boolean isValidRefCondition(IXMLElement conditionElement) {
        return conditionElement.hasAttribute("refid") && conditionElement.hasAttribute("type") && conditionElement.getAttribute("type").equals("ref") && conditionElement.getName().toLowerCase().equals("condition");
    }
}

