class rezinekoT
{
  private StringBuffer wordPool;
  private StringBuffer slideText;
  private StringBuffer wordSlidePairs;
  
  private boolean nextIsCommand;
  private boolean firstWord;
  
  private int slideId;
  
  public void setSlideId(int i){slideId=i;};
  
  
  rezinekoT()
  {
    wordPool  = new StringBuffer();
    slideText = new StringBuffer();
    wordSlidePairs = new StringBuffer();
    init();
  }
  
  
  void reset()
  {
    wordPool.trimToSize();
    slideText.trimToSize();
    wordPool.delete(0,wordPool.length());
    slideText.delete(0,slideText.length());
    wordSlidePairs.delete(0,wordSlidePairs.length());
    init();
  }
  
  public void resetSlideText()
  {
    slideText.delete(0,slideText.length());
  }
  
  void reset(int i)
  {
    reset();
    slideId=i;
  }
  
  void init()
  {
    firstWord=true;
    nextIsCommand=false;
    wordPool.append("insert ignore into wordindex (word) values ");
    wordSlidePairs.append("insert ignore into tempsearchindex (word,slideid) values");
    
  }
  
  String getWordTokens()
  {
     if(firstWord)feed("evilworkar0und");
     return wordPool+";";
  }
  
  String getWordSlidePairs()
  {
     if(firstWord)feed("evilworkar0und");
     return wordSlidePairs+";";
  }
  
  String getSlideText()
  {
    return slideText.toString();
  }
  
  void feed(String s)
  {
    if(s.length()>2&&!nextIsCommand)
    {
      if(!firstWord)
      {  
        wordPool.append(",");
        wordSlidePairs.append(",");
      }
      wordPool.append("(\""+s+"\")");
      wordSlidePairs.append("(\""+s+"\","+slideId+")");
      firstWord=false;
    }
    slideText.append(s);
    nextIsCommand=false;
    if(s.equals("\\"))
    {
      nextIsCommand=true;
    }
    
  }
  
  void print()
  {
    System.out.print(slideText);
  }
   
}
