/*
 * SlideWrapper.java
 *
 * Created on 4. November 2005, 22:30
 */


/**
 *
 * An instance of SlideWrapper represents a slide within <i>CMS</i>4talks.
 * All editing should be done using methods an funcions of this class.
 *
 * @author  Olle Nebendahl
 */


public class SlideWrapper extends SlideRecord
{
    boolean exists=false;

    //private int[] slideOrderPred;
    //private int[] slideOrderSucc;
    
    SlideOrderRecord slideOrder;
    int slideBelongsToTalk;

    public int owningTalkId=Constants.NO_TALK_ID;
    
    private String source;
    
    public void setSource(String s){ source=s; }

    public String getSource() 
    { 
        if(null==source)source=SlideConnection.getSlideSourceByIdSt(getSlideId());
        return source;
    }
  
    public static void main(String[] a)
    {
        SlideWrapper sw = new SlideWrapper();
        sw.load(Integer.decode(a[0]).intValue());
        if(a.length>1) System.out.println(sw.getHeader());
        else System.out.println(sw);
    }
    
    public String toString()
    {
        return super.toString()+"\n"+getSource();
    }
 
//    public int getTalkId(){ return talkId; }

  //  public void setTalkId(int i) { talkId=i; }
  
  

  

    SlideWrapper()
    {
    }
    
    static int createAndFlush(String atitle, String asubject, String abody)
    {
        SlideWrapper sw= new SlideWrapper(-1);
        sw.setSubject(asubject);
        sw.setTitle(atitle);
        sw.setSource(abody);
        sw.flush();
        return sw.getSlideId();
    }
  
    /**
        Constructor for new SlideWrapper in casa i<0. Otherwise loads Slide by Id i.
    */
    SlideWrapper(int i)
    {
        if(i<0)
        {
            SlideConnection.doSqlUpdate("insert into slides values ()");
            Object[] test=(Object[])SlideConnection.getSqlQuery("select last_insert_id();").getFirst();
            setSlideId(((Long)test[0]).intValue());
            exists=true;
        }
        else load(i);
    }


    /**
        Updates SlideBelongsToTalk table.
    */
    public void flushSlideBelongsToTalk()
    {
        SlideConnection.slideBelongsToTalkDeleteEntry(getSlideId() );        
        SlideConnection.slideBelongsToTalkUpdate(getSlideId(),owningTalkId);        
    }
    

    /**
        Updates SlideOrder table.
    */
    public void flushOrder()
    {
        if(null==slideOrder)
        {
            //System.out.println("slideOrder is null???");
            return;
        }
        int predLength = slideOrder.pred.length;
        int succLength = slideOrder.succ.length;
        
        int i;
        
        SlideConnection.slideOrderNoPred(getSlideId());        
        SlideConnection.slideOrderNoSucc(getSlideId());
        
//        if(true)return;

        i=0;
        while(i<predLength)
        {
            SlideConnection.slideOrderUpdate(getSlideId(),slideOrder.pred[i++]);
        }
        
        i=0;
        while(i<succLength)
        {
            SlideConnection.slideOrderUpdate(slideOrder.succ[i++],getSlideId());
        }
    }
  

    /**
        Writes this slide into the data base. Updates tables id slide already present. Otherwise creates new entries.
    */
    public int flush()
    {
        if(exists)
        {
            if(null!=source)SlideConnection.doSlideSourceUpdate(getSource(),getTitle(),getSubject(),getAnnotation(),getSlideId());
            SlideConnection.doSlideTitleUpdate(getTitle(),getSlideId());
            SlideConnection.doSlideSubjectUpdate(getSubject(),getSlideId());
            SlideConnection.doSlideAnnotationUpdate(getAnnotation(),getSlideId());
            SlideConnection.doSlideAAnnotationUpdate(getAAnnotation(),getSlideId());

            flushOrder();
            flushSlideBelongsToTalk();
            
            SlideCache.cacheSlide(this,getSlideId());
        } else 
        {
            Logger.log("Shall write back non-existent slide?!");
            
            /*
            SlideConnection.doSqlUpdate("insert into slides values ()");
            //slideId=((Long)SlideConnection.getSqlQuery("select last_insert_id();").getFirst())[1].intValue();
            Object[] test=(Object[])SlideConnection.getSqlQuery("select last_insert_id();").getFirst();
            setSlideId(((Long)test[0]).intValue());*/
            
            setSlideId(SlideConnection.insertSlide());
            
            Logger.log("Wrote back new slide with ID: "+getSlideId());
            exists=true;
            slideOrder = new SlideOrderRecord();
            owningTalkId = Constants.NO_TALK_ID;
            flush();
        }
        return getSlideId();
    }

    /**
        Returns this the ID of the slide represented by this SlideWrapper instance.
        Returns NO_SLIDE_ID if this slide doesn't exist, i.e. is not present in data base.
        
        todo: is this function used?
    */
    public int getId(){ if(!exists)return Constants.NO_SLIDE_ID; else return getSlideId(); } //
  
    /**
        Loads slide data referred by ID i from database.
    */
    public void load(int i)
    {
//      SlideRecord slide=SlideConnection.getSlide(i);
        source=null; // denn sonst wird es nicht neu geladen
        SlideRecord slide=SlideCache.getSlide(i);
        init(slide); 
        exists=true;
    }
    
    /**
        Loads slide data from given SlideRecord.
    */
    public void load(SlideRecord sr)
    {
        source=null; // denn sonst wird es nicht neu geladen
        init(sr);
        exists=true;
    }
   
    /**
        Initialises slide data with given SlideRecord.
    */
    public void init(SlideRecord r)
    {
        setSlideId(r.getSlideId());
    //    setSource(getSource());
        setAnnotation(r.getAnnotation());
        setAAnnotation(r.getAAnnotation());
        setTitle(r.getTitle());
        setSubject(r.getSubject());
        setDuration(r.getDuration());
        setDateOfCreation(r.getDateOfCreation());
        setDateOfModification(r.getDateOfModification());
        setVersion(r.getVersion());
        setLevel(r.getLevel());
        init();
    }
    
    public void init()
    {
        slideOrder=SlideOrderCache.getSlideOrder(getSlideId());
        owningTalkId=SlideBelongsToTalkCache.get(getSlideId());
    }
}

    /*
    public int getPredSlideCount()
    {
        return slideOrderPred.length;
    }
  
    public int getSuccSlideCount()
    {
        return slideOrderSucc.length;
    }
  
    public int[] getSuccSlides(){ 
        int[] i = new int[slideOrderSucc.length];
        System.arraycopy(slideOrderSucc,0,i,0,slideOrderSucc.length);
        return i; 
    }

    public int[] getPredSlides(){      
        int[] i = new int[slideOrderPred.length];
        System.arraycopy(slideOrderPred,0,i,0,slideOrderPred.length);
        return i; 
    }*/


/*  SlideWrapper(int i, int j)
  {
    setSlideId(j);
    init(i);
  }*/
/*
  private void init(int i)
  {
    if(i==Constants.NEW)
    {
        SlideConnection.doSqlUpdate("insert into slides values ()");
        //slideId=((Long)SlideConnection.getSqlQuery("select last_insert_id();").getFirst())[1].intValue();
        Object[] test=(Object[])SlideConnection.getSqlQuery("select last_insert_id();").getFirst();
        setSlideId(((Long)test[0]).intValue());
        exists=true;
    };
    if(i==Constants.LOAD)
    {
  //    SlideConnection.doSqlQuery
    };
  }  
  
  create table slideorder
(
  slideid mediumint unsigned,
  predslideid mediumint unsigned,
  primary key (slideid,predslideid)
);

  
  */
