/*
 * CommandRepresentation.java
 *
 * Created on 15. November 2005, 17:25
 */


/**
 *
 *  This class represents a LaTeX Command with name and syntax.
 *
 * @author  Olle Nebendahl
 */
class CommandRepresentation extends intStringPair implements Comparable
{ 
    public String toString()
    {   
        StringBuffer result = new StringBuffer();
        result.append(s);
        result.append("[");
        result.append(i+"]");
        int j = 0;
        while(j<i)
        {
            if(j+1==bodyTarget)
                result.append("{body}");
            else
            if(j+1==titleTarget)
                result.append("{title}");
            else
                result.append("{...}");
            j++;
        }
        return result.toString();
    }
    
    CommandRepresentation(int a, String b) {super(a,b);}
    CommandRepresentation(int a, String b, int tt, int bt)
    {
        this(a,b);
        bodyTarget=bt;
        titleTarget=tt;
    }
    
    public int bodyTarget=1;
    public int titleTarget=0;
    
    public int compareTo(Object o)
    {
        String s2=((CommandRepresentation)o).s;
        
        return s.compareTo(s2);
    }
    
    public boolean equals(Object o)
    {
        String s2=((CommandRepresentation)o).s;
        int i2=((CommandRepresentation)o).i;
        return s.equals(s2)&&(i==i2);
    }
    
    public static void main(String[] a)
    {
        CommandRepresentation acr=new CommandRepresentation(3,"newslide",2,1);
        System.out.println(acr);
        
        CommandRepresentation bcr=new CommandRepresentation(acr.toString());
        System.out.println(bcr);
        
        System.out.println("#"+acr.s+"#");
        System.out.println("#"+bcr.s+"#");
        System.out.println(acr.compareTo(bcr));
        
        System.out.println(new CommandRepresentation("createslide[2]{title}{body}"));
    }
    
    public CommandRepresentation(String zeile)
    {
        String[] splitted=zeile.split("\\[");
        s=splitted[0];
        i=Help.str2int(splitted[1].substring(0,1));
        //BracketsTokenizer bt = new BracketsTokenizer("{","}",splitted[1]);
        //bt.run();
        OLL btr=BracketsTokenizer.getTokens(splitted[1],"{","}");
        if(btr!=null)
        {
            btr.reset();
            String s;
            int j = 0;
            while(btr.hasNext())
            {
                j++;
                s=(String)btr.getNext();
                if(s.equals("body"))bodyTarget=j;
                if(s.equals("title"))titleTarget=j;
            }
        }
    }
}
