program nic2pgn;
{$m 65520,0,600000}
uses
  crt,dos, ch_files, ch_chess, ch_parse;

const
  omit_deleted: longint = 0;
  omit_fragment: longint = 0;
  omit_quiz: longint = 0;
  omit_illegal: longint = 0;


var
  not_printed_games : longint;
  i : integer;
  numb_of_games, game_numb : longint;
  f1 : text;
  source, target : sourcetype;
  game : gametype;
  log_fil : text;

{mainprogram}
begin
  io_test;
  writeln;
  writeln('Carsten Hansen, CH0506@HDC.HHA.DK, any comment welcome');
  writeln;
  writeln('SYNTAX: NIC2PGN source-file target-file');
  writeln;
  writeln('The following games will be omitted: ');
  writeln;
  writeln('- deleted, and overwritten games');
  writeln('- game fragments (games starting with a position)');
  writeln;
  writeln;
  source.name:='';
  target.name:='';
  not_printed_games:=0;

  if pos('-SHORT',upcasestr(all_params))=0 then
    use_short_notation:=false
  else
    use_short_notation:=true;

  if get_paramcount=0 then
  begin
    write('NicBase-file to be converted to PGN:    ');
    readln(source.name);
    write('Name of new PGN file:                   ');
    readln(target.name);
  end
  else
  begin
    source.name:=get_paramstr(1);
    target.name:=get_paramstr(2);
  end;
  remove_ext(source.name);
  if (pos('.',target.name)=0) and (length(target.name)>0) then
    target.name:=target.name+'.pgn';
  find_path(source.name,source.path);
  find_path(target.name,target.path);

  if file_exist(source.path+source.name+'.I30') and
     file_exist(source.path+source.name+'.G30') then
  begin
    if target.name='' then
      assign(f1,'')
    else
    if pos(copy(target.name,1,3),' prn PRN')>0 then
      assign(f1,'PRN')
    else
    begin
      assign(f1,target.path+target.name);
      if file_exist(target.path+target.name) then
        erase(f1);
    end;
    io_test;
    rewrite(f1);
    io_test;
    open_file_for_read(source.index  ,source.path+source.name+'.I30');
    open_file_for_read(source.game   ,source.path+source.name+'.G30');
    if not io_error then
    begin
      game.game_format:='NIC';
      game.beg:=get_index_val(source.index);
      numb_of_games:=(filesize(source.index.f)-4) div 4;
      writeln(numb_of_games:6,' Games to examine');
      game_numb:=1;
      while (game_numb<=numb_of_games) and (not io_error) and
            (not keypressed) do
      begin
        game.beg_next:=get_index_val(source.index);
        game.len:=game.beg_next-game.beg;
        if game.len<0 then
        begin
          write('game.len<0');
          halt;
        end;
        i:=0;
        while (i<game.len) and (not io_error) do
        begin
          game.bytes[i]:=get_next_byte(source.game);
          inc(i);
        end;
        game.bytes[game.len]:=-1;
        parse_nic_gamehead(game);
        if not (game.deleted or game.overwritten or
                game.position or game.quiz)
        then
        begin
          parse_nic_moves(game);
          if not game.illegal_move then
            print_pgn(f1,game)
          else
          begin
            inc(not_printed_games);
            inc(omit_illegal);
            if omit_illegal=1 then
            begin
              assign(log_fil,source.path+source.name+'.log');
              rewrite(log_fil);
            end;
            writeln(log_fil,game_numb+1:6,'':4,game.cb_players);
          end;
        end
        else
        begin
          inc(not_printed_games);
          if (game.deleted) or (game.overwritten) then
            inc(omit_deleted)
          else if game.position then
            inc(omit_fragment)
          else if game.quiz then
            inc(omit_quiz);
        end;
        game.beg:=game.beg_next;
        if target.name<>'' then
        begin
          gotoxy(1,wherey);
          write(game_numb:6,' Games Examined ',not_printed_games:6,
                ' Games not printed');
        end
        else
        begin
          writeln;
          writeln(game_numb:6,' Games Examined ',not_printed_games:6,
                ' Games not printed');
        end;
        inc(game_numb);
      end;
    end;
    writeln;
    if not_printed_games>0 then
    begin
      writeln;
      writeln('Omitted games due to deletion/overwrite:    ',omit_deleted);
      writeln('Omitted games due to game fragments:        ',omit_fragment);
      writeln('Omitted games due to quiz:                  ',omit_quiz);
      writeln('Omitted games due to illegal moves          ',omit_illegal);
    end;
    close_read_file(source.index);
    close_read_file(source.game);
    close(f1);
    if omit_illegal>0 then
      close(log_fil);
  end
  else
  begin
    writeln(source.path+source.name,'  Does not exist');
  end;
end.
