// SPDX-License-Identifier: BSD-3-Clause
package org.islandoftex.arara.core.localization

import org.islandoftex.arara.api.localization.MPPLocale
import org.islandoftex.arara.api.localization.Messages

@Suppress("MaxLineLength")
class ItalianLanguage : Messages(
    providedLocale = MPPLocale("it"),
    translators = listOf("Enrico Gregorio", "Carla Maggi", "Paulinho van Duck"),
    ERROR_BASENAME_NOT_A_FILE = "Il metodo 'basename' richiede un file, non una directory. '%s' non sembra proprio essere un file. Se devi eseguire un compito su una directory, puoi adoperare uno dei metodi delle API Java.",
    ERROR_CALCULATEHASH_IO_EXCEPTION = "Per qualche motivo, non ho potuto calcolare un hash. Purtroppo non ho idea del perché sia andata male. Forse il file è stato spostato o cancellato durante l'operazione di hashing. O forse non ho i permessi necessari per leggere il file.",
    ERROR_CHECKBOOLEAN_NOT_VALID_BOOLEAN = "Sembra che '%s' non sia un valore booleano valido. Penso che sia facile correggerlo. Assicurati di adoperare una stringa valida che rappresenti un valore booleano (yes e no, true e false, 1 e 0, oppure on e off).",
    ERROR_CHECKREGEX_IO_EXCEPTION = "Non sono riuscito a leggere il contenuto del file '%s' e ho ricevuto in errore di I/O. Purtroppo non ho idea del perché sia andata male. Forse il file è stato spostato o cancellato durante l'operazione di hashing. O forse non ho i permessi necessari per leggere il file.",
    ERROR_CONFIGURATION_GENERIC_ERROR = "Non sono riuscito a leggere il file di configurazione, è successo qualcosa che non va. Questa parte è un po' complicata, perché riguarda aspetti del formato interno di serializzazione dei dati. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_CONFIGURATION_LOOPS_INVALID_RANGE = "Il valore definito nella chiave 'loops' del file di configurazione per stabilire il massimo numero di cicli ha un intervallo non valido. Assicurati che sia un valore 'lungo' e positivo.",
    ERROR_DISCOVERFILE_FILE_NOT_FOUND = "Non sono riuscito a trovare il file '%s' %s. Assicurati che il file esista e abbia un'estensione valida.",
    ERROR_EVALUATE_COMPILATION_FAILED = "Per qualche ragione, non sono riuscito a compilare l'espressione del condizionale fornito. Questa parte è un po' complicata, perché riguarda aspetti del linguaggio interno per le espressioni. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_EVALUATE_NOT_BOOLEAN_VALUE = "La valutazione del condizionale si aspettava un valore booleano come risultato. Dovrebbe essere facile correggerlo. Assicurati che la valutazione del condizionale fornisca alla fine un valore booleano.",
    ERROR_EXTRACTOR_IO_ERROR = "C'è stato un errore di I/O mentre provavo a estrarre le direttive. Purtroppo non ho idea del perché sia andata male. Forse il file è stato spostato o cancellato prima o durante l'operazione di hashing. O forse non ho i permessi necessari per leggere il file.",
    ERROR_EXTRACTOR_INTERPOLATION_FAILURE = "Il campo 'options' ha un contenuto che il parser MVEL non riesce a gestire. Correggi le opzioni in modo che non contengano parti di forma scorretta con '@{...}'.",
    ERROR_FILETYPE_NOT_A_FILE = "Il metodo 'filetype' richiede un file, non una directory. '%s' non sembra proprio essere un file. Se devi eseguire un compito su una directory, puoi adoperare uno dei metodi delle API Java.",
    ERROR_FILETYPE_UNKNOWN_EXTENSION = "Non riconosco '%s' come un'estensione standard. Se vuoi definire un nuovo tipo di file, assicurati di fornire l'estensione e lo schema. Queste sono le estensioni standard: %s",
    ERROR_GETAPPLICATIONPATH_ENCODING_EXCEPTION = "C'è stato un problema di codifica mentre tentavo di ottenere il percorso dell'applicazione. Non c'è molto che possa fare al riguardo.",
    ERROR_INTERPRETER_ARGUMENT_IS_REQUIRED = "Sembra che '%s' sia contrassegnato come obbligatorio nella regola, ma non l'ho trovato nei parametri della direttiva. Assicurati di aggiungerlo come parametro nella direttiva e riprova.",
    ERROR_INTERPRETER_COMMAND_RUNTIME_ERROR = "Non ho potuto valutare uno dei comandi forniti. Questa parte è un po' complicata perché coinvolge aspetti del linguaggio per le espressioni sottostante. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_INTERPRETER_COMMAND_UNSUCCESSFUL_EXIT = "Il comando \"%s\" ha dato un esito inaspettato, con codice di ritorno non a zero. Guarda l'output per valutare le eventuali azioni da intraprendere.",
    ERROR_INTERPRETER_USER_REQUESTED_HALT = "A seguito di una tua richiesta (o di una regola), arara ora interromperà l'esecuzione.",
    ERROR_INTERPRETER_EXIT_RUNTIME_ERROR = "Non sono riuscito a valutare lo stato di uscita di uno dei comandi forniti. Questa parte è un po' complicata perché coinvolge aspetti del linguaggio per le espressioni sottostante. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_INTERPRETER_FLAG_RUNTIME_EXCEPTION = "Non ho potuto valutare la flag di uno degli argomenti. Questa parte è un po' complicata perché coinvolge aspetti del linguaggio per le espressioni sottostante. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_INTERPRETER_RULE_NOT_FOUND = "Non sono riuscito a trovare una regola chiamata '%s' nei percorsi per le regole impostati. Forse una parola scritta sbagliata? Stavo cercando un file con il nome '%s.yaml' nei seguenti percorsi in ordine di priorità: %s",
    ERROR_INTERPRETER_UNKNOWN_KEYS = "Ho trovato queste chiavi sconosciute nella direttiva: %s. Dovrebbbe essere facile correggere, toglile dalla mappa.",
    ERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN = "L'espressione di 'uscita' deve essere sempre un valore booleano (anche se non c'è alcun calcolo nella parte di chiusura). Dovrebbe essere facile correggere: assicurati che l'asserzione del 'type return' sia giusta e riprova.",
    ERROR_INTERPRETER_WRONG_RETURN_TYPE = "Una regola dovrebbe restituire solo un booleano o un comando. Altri tipi di risposta non sono supportati.",
    ERROR_LOAD_COULD_NOT_LOAD_XML = "Non ho potuto caricare il database YAML di nome '%s'. Purtroppo non ho idea del perché sia andata male. Forse il file è stato spostato o cancellato prima o durante l'operazione di lettura. O forse non ho i permessi necessari per leggere il file. Già che ci siamo, assicurati che il file YAML sia ben formato.",
    ERROR_PARSER_INVALID_PREAMBLE = "Mi dispiace, ma non è stato possibile trovare il preambolo '%s'. Assicurati che questa chiave esista nel file di configurazione.",
    ERROR_PARSERULE_GENERIC_ERROR = "Non ho potuto analizzare la regola, qualcosa è andato storto. Questa parte è un po' complicata, perché riguarda aspetti del formato interno di serializzazione dei dati. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_REPLICATELIST_MISSING_FORMAT_ARGUMENTS_EXCEPTION = "Non sono riuscito a replicare la lista perché manca un argomento per il formato. Penso che si tratti di un numero sbagliato di parametri. Assicurati che il numero di parametri sia corretto e riprova.",
    ERROR_RULE_IDENTIFIER_AND_PATH = "Ho trovato un errore nella regola '%s' alla posizione '%s'.",
    ERROR_RUN_GENERIC_EXCEPTION = "Non ho potuto lanciare il comando di sistema richiesto, qualcosa è andato storto. Questa parte è un po' complicata, perché riguarda aspetti del linguaggio interno per le espressioni. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_RUN_INTERRUPTED_EXCEPTION = "L'esecuzione del comando di sistema richiesto si è interrotta inaspettatamente. Forse un'interruzione esterna ha forzato il comando a terminare.",
    ERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION = "Il comando di sistema richiesto ha restituito un valore di uscita non valido.",
    ERROR_RUN_IO_EXCEPTION = "L'esecuzione del comando di sistema è fallita per via di un errore di I/O. Sei sicuro che il programma esista nei tuoi percorsi? Meglio controllare se il programma è davvero disponibile.",
    ERROR_RUN_TIMEOUT_EXCEPTION = "L'esecuzione del comando di sistema ha raggiunto il valore di timeout impostato ed è stata interrotta. Se il tempo è troppo breve, assicurati di impostarne uno più lungo.",
    ERROR_SAVE_COULD_NOT_SAVE_XML = "Non ho potuto salvare il database YAML con il nome '%s'. Purtroppo non ho idea del perché sia successo. Forse non ho i permessi appropriati per scrivere il file YAML sul disco.",
    ERROR_SESSION_OBTAIN_UNKNOWN_KEY = "Il metodo 'get' ha trovato una chiave sconosciuta '%s' nell'ambito della sessione. Non posso ottenere qualcosa che non ho da nessuna parte. Specifica una chiave valida e riprova.",
    ERROR_SESSION_REMOVE_UNKNOWN_KEY = "Il metodo 'remove' ha trovato una chiave sconosciuta '%s' nell'ambito della sessione. Non posso ottenere qualcosa che non ho da nessuna parte. Specifica una chiave valida e riprova.",
    ERROR_VALIDATE_EMPTY_FILES_LIST = "Ho letto la direttiva %s, ma la lista 'files' fornita è vuota. Puoi correggerlo facilmente assicurandoti che la lista abbia almeno un elemento, poi riprova.",
    ERROR_VALIDATE_FILES_IS_NOT_A_LIST = "Ho letto la direttiva %s e ho scoperto che 'files' richiede una lista. Assicurati di correggere il tipo a una lista appropriata e riprova.",
    ERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT = "Ho visto nel file fornito la direttiva %s che non è valida. Assicurati di correggere la direttiva e riprova.",
    ERROR_VALIDATE_NO_DIRECTIVES_FOUND = "Sembra che nel file fornito non ci siano direttive. Assicurati che ce ne sia almeno una e riprova.",
    ERROR_VALIDATE_ORPHAN_LINEBREAK = "Sembra che ci sia un fine riga che lascia orfana una direttiva alla riga %s. Non posso andare avanti. Correggi la direttiva e riprova.",
    ERROR_VALIDATE_REFERENCE_IS_RESERVED = "Ho letto la direttiva %s dove è stata usata la chiave 'reference'. Questa chiave è riservata e non puoi usarla. Non preoccuparti, lo metti facilmente a posto dando un altro nome.",
    ERROR_VALIDATE_YAML_EXCEPTION = "C'è stato un problema con la mappa YAML fornita con la direttiva %s. Questa parte è un po' complicata, perché riguarda aspetti del formato interno di serializzazione dei dati. Farò del mio meglio per darti una mano, per quanto posso.",
    ERROR_VALIDATEBODY_ARGUMENT_ID_IS_RESERVED = "L'identificatore dell'argomento '%s' è riservato, quindi non puoi adoperarlo. È facile correggerlo: chiamalo in modo diverso.",
    ERROR_VALIDATEBODY_DUPLICATE_ARGUMENT_IDENTIFIERS = "Sembra che tu abbia identificatori di argomenti duplicati nella tua regola. Correggi e riprova.",
    ERROR_VALIDATEBODY_MISSING_KEYS = "Quando si definisce un ambito per l'argomento in una regola bisogna adoperare almeno 'flag' o 'default'. Assicurati che ci sia uno di questi.",
    ERROR_VALIDATEBODY_NULL_ARGUMENT_ID = "Ho trovato che uno degli argomenti non ha identificatore. Assicurati di assegnare un identificatore all'argomento e riprova.",
    ERROR_VALIDATEBODY_NULL_COMMAND = "Ho trovato un comando 'nullo' nella regola fornita. Dovrebbe essere facile correggere: aggiungi un comando valido alla regola.",
    ERROR_VALIDATEHEADER_NULL_NAME = "La regola fornita non ha nome. È facile correggere: specifica un nome valido e riprova.",
    ERROR_VALIDATEHEADER_WRONG_IDENTIFIER = "La regola ha un identificatore sbagliato. Mi sarei aspettato '%s', ma ho trovato '%s'. È facile correggere: correggi l'identificatore sbagliato con quello giusto.",
    INFO_DISPLAY_EXCEPTION_MORE_DETAILS = "Ci sono altri dettagli riguardo a questa eccezione:",
    INFO_DISPLAY_EXECUTION_TIME = "Totale: %s secondi",
    INFO_DISPLAY_FILE_INFORMATION = "Elaborazione '%s' (totale: %s, modificato il: %s), attendere.",
    INFO_INTERPRETER_DRYRUN_MODE_BOOLEAN_MODE = "Sebbene stia eseguendo in modo 'dry-run', questo elemento potrebbe essere già stato elaborato, perché ha restituito un valore booleano: %s",
    INFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND = "Sto per lanciare: %s",
    INFO_LABEL_AUTHOR = "Autore:",
    INFO_LABEL_AUTHORS = "Autori:",
    INFO_LABEL_CONDITIONAL = "Condizionale:",
    INFO_LABEL_NO_AUTHORS = "Nessun autore specificato",
    INFO_LABEL_ON_DETAILS = "DETAILS",
    INFO_LABEL_ON_ERROR = "ERROR",
    INFO_LABEL_ON_FAILURE = "FAILURE",
    INFO_LABEL_ON_SUCCESS = "SUCCESS",
    INFO_LABEL_UNNAMED_TASK = "Compito senza nome",
    INFO_PARSER_NOTES = "arara stesso è rilasciato in accordo con la licenza New BSD.",
    LOG_INFO_BEGIN_BUFFER = "BEGIN OUTPUT BUFFER",
    LOG_INFO_BOOLEAN_MODE = "Valore booleano: %s",
    LOG_INFO_DIRECTIVES_BLOCK = "DIRECTIVES",
    LOG_INFO_END_BUFFER = "END OUTPUT BUFFER",
    LOG_INFO_INTERPRET_RULE = "Sono pronto a interpretare la regola '%s'.",
    LOG_INFO_INTERPRET_TASK = "Sono pronto a interpretare il compito '%s' della regola '%s'.",
    LOG_INFO_POTENTIAL_PATTERN_FOUND = "Ho trovato un potenziale schema alla riga %s: %s",
    LOG_INFO_RULE_LOCATION = "Posizione della regola: '%s'",
    LOG_INFO_SYSTEM_COMMAND = "Comando di sistema: %s",
    LOG_INFO_TASK_RESULT = "Risultato del compito:",
    LOG_INFO_VALIDATED_DIRECTIVES = "Tutte le direttive erano valide. Pronti a partire.",
    LOG_INFO_WELCOME_MESSAGE = "Benvenuto in arara %s!"
)
