/*
Copyright (C) 2016, 2017 Siep Kroonenberg

This file is part of TLaunch.

TLaunch is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

TLaunch is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with TLaunch.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "tla_utils.h"
#include "tlaunch.h"

/////////////////////////////////////////////////////////
// splash window for long-running scripts

static wchar_t * splash_class = L"splash_class";

HWND splash( HWND h, wchar_t * splash_text ) {
  HWND hsplash;
  RECT rect;
  if( !GetWindowRect( h, &rect )) { rect.left = 200; rect.top = 50; }
  hsplash = CreateWindowEx(
      WS_EX_TOPMOST,
      splash_class,
      NULL,
      WS_DLGFRAME | WS_POPUP | WS_DISABLED,
      rect.left + 100, rect.top + 80,
      ( wcslen( splash_text ) + 8 ) * cxb, 3 * cyb,
      h, NULL, NULL, splash_text
      );
  ShowWindow( hsplash, SW_SHOWNORMAL );
  UpdateWindow( hsplash );
  return hsplash;
} // splash

static LRESULT CALLBACK SplashProc( HWND h, UINT msg, WPARAM wp, LPARAM lp ) {
  HWND hbn;
  RECT rect;
  switch(msg) {
    case WM_CREATE: {
      EnableWindow( h, FALSE );

      if( !GetClientRect( h, &rect )) rect.right = 300;

      hbn = CreateWindow(
          L"STATIC",
          ( wchar_t * )(( LPCREATESTRUCT )lp )->lpCreateParams,
          WS_CHILD | WS_VISIBLE | SS_CENTER,
          5,
          cyb,
          rect.right - 10,
          7 * cyb / 4,
          h,
          ( HMENU )ID_SPLASH,
          hInst,
          NULL
      );
      // hfntbig globally-saved font variable
      SendMessage( hbn, WM_SETFONT, ( WPARAM )hfntbig, TRUE );
      SendMessage( hbn, WM_SETFONT, ( WPARAM )hfntbig, TRUE );

      return 0;
    }
    case WM_CTLCOLORSTATIC: {
      HDC hdc = ( HDC )wp;
      SetBkColor( hdc, RGB(255,255,255 ));
      return (INT_PTR)GetStockObject( WHITE_BRUSH );
    }
    case WM_CLOSE: {
      DestroyWindow( h );
      EnableWindow( h, TRUE );
      return 0;
    }
  }
  return DefWindowProc( h, msg, wp, lp );
} // SplashProc

void register_splash() {
  WNDCLASSEX wsplash;

  wsplash.cbSize = sizeof(WNDCLASSEX);
  wsplash.style = 0; // style set by CreateWindow
  wsplash.lpfnWndProc = SplashProc;
  wsplash.cbClsExtra = 0;
  wsplash.cbWndExtra = 0;
  wsplash.hInstance = hInst;
  wsplash.hIcon = NULL;
  wsplash.hCursor = NULL;
  wsplash.hbrBackground = (HBRUSH)GetStockObject (WHITE_BRUSH);
  wsplash.lpszMenuName = NULL;
  wsplash.lpszClassName = splash_class;
  wsplash.hIconSm = NULL;

  if(!RegisterClassEx( &wsplash ))
    tldie( NULL, L"Splash Window Registration Failed: %lu\n",
        GetLastError());
}
