/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JBibtexManager
extends JPanel {
    protected JMenuBar menuBar;
    protected HashMap key2bibitem;
    protected JPanel topPanel;
    protected TaskBarPanel taskBar;
    protected JTable table;
    protected BibtexTableModel model;
    protected JScrollPane scrollPane;
    protected String filename;
    protected int[] selectedRows;
    protected JTableHeader header;
    protected boolean key_sorting_order = false;
    protected boolean year_sorting_order = false;
    protected boolean type_sorting_order = false;
    protected boolean journal_sorting_order = false;
    protected static HashSet titleHighlight;
    protected static HashSet authorHighlight;
    protected int m_maxNumPage = 1;
    protected boolean contentChangedButNotSaved = false;
    protected boolean readingFile = false;
    protected boolean writingFile = false;
    protected int BIBMANKEYNUM = 0;
    protected String previousOpenFilePath = null;
    Highlighter.HighlightPainter greenHighlightPainter = new MyHighlightPainter(Globals.backgroundColor);
    String tempFilename = null;
    Format formatter = new SimpleDateFormat("hh:mm:ss");
    static final HashSet allKeys;
    static int tabLength;
    JMenuItem previousMenu = null;
    JMenuItem prev_previousMenu = null;
    ButtonGroup groupFontSize = new ButtonGroup();
    ButtonGroup groupFontName = new ButtonGroup();
    ButtonGroup groupBackup = new ButtonGroup();

    void flicker() {
        this.setVisible(false);
        this.setVisible(true);
    }

    void cleanUp() {
        this.checkIfNeedToSaveFile();
        this.reset();
        JBM.setTabTitle("*blank*");
        this.taskBar.show_message("");
    }

    void setFileHistory() {
        if (this.filename == null || this.filename.equals("")) {
            return;
        }
        if (this.previousMenu.getText().equals(this.filename)) {
            return;
        }
        this.prev_previousMenu.setText(this.previousMenu.getText());
        this.previousMenu.setText(this.filename);
    }

    public JBibtexManager() {
        titleHighlight = new HashSet();
        authorHighlight = new HashSet();
        this.key2bibitem = new HashMap();
        this.setSize(700, 300);
        this.taskBar = new TaskBarPanel();
        this.taskBar.setSize(this.getWidth(), 20);
        this.setLayout(new BorderLayout());
        this.add((Component)this.taskBar, "South");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.model = new BibtexTableModel(Globals.columnNames);
        this.table = new JTable(this.model){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (this.isCellSelected(n, n2)) {
                    component.setBackground(Globals.foregroundColor);
                } else if (n % 2 == 0) {
                    component.setBackground(Globals.backgroundColor);
                } else {
                    component.setBackground(this.getBackground());
                }
                return component;
            }
        };
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.setupColumns();
        this.setupHeaders();
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        this.addMenu();
        this.add((Component)this.menuBar, "North");
        this.setColumnWidth(Globals.columnWidths);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JBibtexManager.this.selectedRows = JBibtexManager.this.table.getSelectedRows();
            }
        });
        this.setUpPopupMenu();
    }

    public String nextKey() {
        ++this.BIBMANKEYNUM;
        return "" + this.BIBMANKEYNUM;
    }

    public void numberRows() {
        int n = 0;
        while (n < this.model.getRowCount()) {
            this.model.setValueAt(n + 1 + "", n, 0);
            ++n;
        }
    }

    public Bibitem rowNum2bibitem(int n) {
        String string = (String)this.model.getValueAt(n, 9);
        return (Bibitem)this.key2bibitem.get(string);
    }

    public void addBibEntry(Bibitem bibitem) {
        this.key2bibitem.put(bibitem.getBibManKey(), bibitem);
        this.model.addRow(bibitem.toList());
    }

    Object[] getAllColumnData(int n) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        int n2 = 0;
        while (n2 < this.model.getRowCount()) {
            object = (String)this.model.getValueAt(n2, n);
            if (!hashSet.contains(object)) {
                if (((String)object).length() > 70) {
                    hashSet.add(((String)object).substring(0, 70));
                } else {
                    hashSet.add(object);
                }
            }
            ++n2;
        }
        object = hashSet.toArray();
        Arrays.sort((Object[])object);
        return object;
    }

    protected void reset() {
        this.key2bibitem.clear();
        this.model.clear();
        titleHighlight.clear();
        authorHighlight.clear();
        this.contentChangedButNotSaved = false;
        allKeys.clear();
    }

    protected void checkIfNeedToSaveFile() {
        int n;
        if (this.contentChangedButNotSaved && (n = JOptionPane.showConfirmDialog(null, "You have made changes but have not saved them. If you open another file, all the \n changes will be lost. Would you like to save these changes?", "Confirm Close", 0)) == 0) {
            this.saveChangesToFile();
        }
    }

    protected void saveChangesToFile() {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (this.model.getRowCount() == 0 && this.key2bibitem.size() == 0) {
            this.taskBar.show_message("Nothing to save!");
            return;
        }
        if (this.filename == null || this.filename.equals("")) {
            this.taskBar.show_message("Create or choose a file.");
            object3 = System.getProperty("user.dir");
            object2 = new JFileChooser(new File((String)object3));
            ((JFileChooser)object2).addChoosableFileFilter(new BibFileFilter());
            ((JFileChooser)object2).setDialogType(0);
            ((JFileChooser)object2).showOpenDialog(null);
            object = ((JFileChooser)object2).getSelectedFile();
            if (object == null || ((File)object).equals("")) {
                return;
            }
            n = ((File)object).exists() ? 1 : 0;
            if (n != 0) {
                JOptionPane.showMessageDialog(null, "Error: " + ((File)object).getName() + "\n already exists. You need to open this file using\n" + " \"Open BibTex File\" menu item.");
                return;
            }
            this.previousOpenFilePath = ((File)object).getParent();
            this.filename = ((File)object).getName();
        }
        try {
            object3 = new GregorianCalendar();
            this.writingFile = true;
            object2 = new FileWriter(this.filename);
            object = new PrintWriter((Writer)object2);
            n = 0;
            while (n < this.model.getRowCount()) {
                ((PrintWriter)object).println(this.rowNum2bibitem(n));
                ++n;
            }
            ((OutputStreamWriter)object2).close();
            this.contentChangedButNotSaved = false;
            this.taskBar.show_message("File " + this.filename + " updated ( " + this.formatter.format(new Date()) + " ).");
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Error writing to file: " + this.filename);
            this.writingFile = false;
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "Error writing to file: " + this.filename);
            this.writingFile = false;
        }
        this.writingFile = false;
    }

    protected String getNewFile() {
        JFileChooser jFileChooser = this.previousOpenFilePath == null || this.previousOpenFilePath.equals("") ? new JFileChooser(new File(System.getProperty("user.home"))) : new JFileChooser(new File(this.previousOpenFilePath));
        jFileChooser.addChoosableFileFilter(new BibFileFilter());
        jFileChooser.setDialogType(0);
        jFileChooser.showOpenDialog(null);
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        this.previousOpenFilePath = file.getParent();
        return file.getAbsolutePath();
    }

    public void readFileHelper(String string) {
        this.readFileHelper(string, false);
    }

    public static String fixedWidthString(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public void readFileHelper(final String string, boolean bl) {
        File file;
        if (!bl) {
            allKeys.clear();
        }
        if (!((file = new File(string)).exists() && file.canRead() && file.isFile())) {
            JOptionPane.showMessageDialog(null, "Error: " + string + " does not exist or is not a valid BibTex file.\n" + "If you are trying to create a new BibTex database, then \n" + " create some entries and then choose the \"save selected entries\" to file menu item");
            return;
        }
        if (!bl) {
            this.filename = string;
            this.reset();
            JBM.setTabTitle(JBibtexManager.fixedWidthString(file.getName(), tabLength));
            this.setFileHistory();
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int n;
                Object object;
                String[] stringArray;
                Object object2;
                Object object3;
                JBibtexManager.this.readingFile = true;
                if (Globals.BACKUP) {
                    try {
                        object3 = new FileInputStream(string).getChannel();
                        object2 = new FileOutputStream(string + ".bkup").getChannel();
                        ((FileChannel)object2).transferFrom((ReadableByteChannel)object3, 0L, ((FileChannel)object3).size());
                        ((AbstractInterruptibleChannel)object3).close();
                        ((AbstractInterruptibleChannel)object2).close();
                    }
                    catch (IOException iOException) {
                        System.err.println("Unable to create a backup");
                    }
                }
                object3 = new StringBuffer();
                try {
                    object2 = new FileReader(string);
                    stringArray = new BufferedReader((Reader)object2);
                    JBibtexManager.this.taskBar.show_message("Reading file: " + string);
                    while ((object = stringArray.readLine()) != null) {
                        n = ((String)object).indexOf("%");
                        if (n >= 0) {
                            object = ((String)object).substring(0, n);
                        }
                        ((StringBuffer)object3).append((String)object);
                    }
                    ((InputStreamReader)object2).close();
                }
                catch (IOException iOException) {
                    System.err.println("Error reading file: " + string);
                    JOptionPane.showMessageDialog(null, "Error reading file: " + string);
                    JBibtexManager.this.readingFile = false;
                    JBibtexManager.this.taskBar.show_message("Failed reading: " + string);
                    return;
                }
                object2 = ((StringBuffer)object3).toString().replaceAll("[ \t\r\n]+", " ");
                stringArray = ((String)object2).split("@");
                if (stringArray.length <= 1) {
                    JOptionPane.showMessageDialog(null, "Either file " + string + "\nis in a invalid format or is empty." + "\nIf this is a scifinder format file, then open it using the menu.");
                    JBibtexManager.this.readingFile = false;
                    JBibtexManager.this.taskBar.show_message("Failed reading: " + string);
                    JBibtexManager.this.filename = null;
                    return;
                }
                object = new ProgressMonitor(null, "Reading file", "", 0, stringArray.length);
                ((ProgressMonitor)object).setProgress(0);
                n = 0;
                boolean bl = false;
                BibtexTableModel bibtexTableModel = JBibtexManager.this.model;
                synchronized (bibtexTableModel) {
                    int n2 = 1;
                    while (n2 < stringArray.length) {
                        Bibitem bibitem = new Bibitem(stringArray[n2], JBibtexManager.this.nextKey(), n2 + "");
                        String string2 = bibitem.getType();
                        if (string2.length() > 0 && !string2.toUpperCase().matches("STRING|PREAMBLE|COMMENT")) {
                            JBibtexManager.this.addBibEntry(bibitem);
                            ++n;
                        }
                        if (n2 % 100 == 0) {
                            ((ProgressMonitor)object).setNote(" read " + n + " entries");
                            ((ProgressMonitor)object).setProgress(n);
                        }
                        if (bl = ((ProgressMonitor)object).isCanceled()) break;
                        ++n2;
                    }
                }
                ((ProgressMonitor)object).close();
                JBibtexManager.this.readingFile = false;
                JBibtexManager.this.numberRows();
                if (bl) {
                    JBibtexManager.this.reset();
                    JBibtexManager.this.taskBar.show_message("Abort reading: " + string);
                } else {
                    JBibtexManager.this.taskBar.show_message("Done reading: " + string);
                }
            }
        };
        thread.start();
    }

    void setUpPopupMenu() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("New as raw BibTex", new ImageIcon(this.getClass().getResource("images16/New16.gif")));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new BibStringEntryDialog(null, "Type in a single entry in Bibtex format", -1).setVisible(true);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("New as form", new ImageIcon(this.getClass().getResource("images16/New16.gif")));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new BibEntryDialog(null, -1).setVisible(true);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("edit as form", new ImageIcon(this.getClass().getResource("images16/Edit16.gif")));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.editBibtexDialog();
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("edit as raw BibTex", new ImageIcon(this.getClass().getResource("images16/Edit16.gif")));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.editBibtexStringDialog();
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("delete", new ImageIcon(this.getClass().getResource("images16/Remove16.gif")));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.deleteBibtexItem();
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem5);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getClickCount() == 2) {
                    JBibtexManager.this.editBibtexStringDialog();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.scrollPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    void deleteBibtexItem() {
        if (this.selectedRows == null || this.selectedRows.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.selectedRows.length) {
            this.key2bibitem.remove(this.model.getValueAt(this.selectedRows[n], 9));
            ++n;
        }
        this.model.removeRow(this.selectedRows);
        this.numberRows();
        this.contentChangedButNotSaved = true;
    }

    void editBibtexStringDialog() {
        if (this.model.getRowCount() == 0 && this.key2bibitem.size() == 0) {
            return;
        }
        if (this.selectedRows == null || this.selectedRows.length == 0) {
            return;
        }
        BibStringEntryDialog bibStringEntryDialog = new BibStringEntryDialog(null, "Edit in a valid Bibtex format", this.selectedRows[0]);
        bibStringEntryDialog.setDialogFont(Globals.tableFont);
        bibStringEntryDialog.setVisible(true);
    }

    void editBibtexDialog() {
        if (this.model.getRowCount() == 0 && this.key2bibitem.size() == 0) {
            return;
        }
        if (this.selectedRows == null || this.selectedRows.length == 0) {
            return;
        }
        BibEntryDialog bibEntryDialog = new BibEntryDialog(null, this.selectedRows[0]);
        bibEntryDialog.setDialogFont(Globals.tableFont);
        bibEntryDialog.setVisible(true);
    }

    protected void setupColumns() {
        TableColumn tableColumn;
        CustomTableCellRenderer customTableCellRenderer = new CustomTableCellRenderer();
        AuthorTitleCellRenderer authorTitleCellRenderer = new AuthorTitleCellRenderer();
        int n = 0;
        while (n < Globals.columnNames.length) {
            tableColumn = this.table.getColumn(Globals.columnNames[n]);
            if (n == 3 || n == 5) {
                tableColumn.setCellRenderer(authorTitleCellRenderer);
            } else {
                tableColumn.setCellRenderer(customTableCellRenderer);
            }
            ++n;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumn = tableColumnModel.getColumn(9);
        tableColumnModel.removeColumn(tableColumn);
    }

    protected void setupHeaders() {
        this.header = this.table.getTableHeader();
        this.header.setFont(new Font("Times", 1, 12));
        ColumnHeaderToolTips columnHeaderToolTips = new ColumnHeaderToolTips();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(2);
        columnHeaderToolTips.setToolTip(tableColumn, "click to sort (toggle assending and descending)");
        tableColumn = this.table.getColumnModel().getColumn(4);
        columnHeaderToolTips.setToolTip(tableColumn, "click to sort (toggle assending and descending)");
        tableColumn = this.table.getColumnModel().getColumn(1);
        columnHeaderToolTips.setToolTip(tableColumn, "click to sort (toggle assending and descending)");
        tableColumn = this.table.getColumnModel().getColumn(6);
        columnHeaderToolTips.setToolTip(tableColumn, "click to sort (toggle assending and descending)");
        this.header.addMouseMotionListener(columnHeaderToolTips);
        this.header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (JBibtexManager.this.readingFile) {
                    return;
                }
                int n = JBibtexManager.this.header.columnAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                int n2 = JBibtexManager.this.table.getRowCount();
                if (n2 != 0) {
                    if (n == 4) {
                        titleHighlight.clear();
                        authorHighlight.clear();
                        JBibtexManager.this.sortAllRowsBy(JBibtexManager.this.model, n, JBibtexManager.this.year_sorting_order);
                        JBibtexManager.this.year_sorting_order = !JBibtexManager.this.year_sorting_order;
                        JBibtexManager.this.numberRows();
                    } else if (n == 2) {
                        titleHighlight.clear();
                        authorHighlight.clear();
                        JBibtexManager.this.sortAllRowsBy(JBibtexManager.this.model, n, JBibtexManager.this.key_sorting_order);
                        JBibtexManager.this.key_sorting_order = !JBibtexManager.this.key_sorting_order;
                        JBibtexManager.this.numberRows();
                    } else if (n == 1) {
                        titleHighlight.clear();
                        authorHighlight.clear();
                        JBibtexManager.this.sortAllRowsBy(JBibtexManager.this.model, n, JBibtexManager.this.type_sorting_order);
                        JBibtexManager.this.type_sorting_order = !JBibtexManager.this.type_sorting_order;
                        JBibtexManager.this.numberRows();
                    } else if (n == 6) {
                        titleHighlight.clear();
                        authorHighlight.clear();
                        JBibtexManager.this.sortAllRowsBy(JBibtexManager.this.model, n, JBibtexManager.this.journal_sorting_order);
                        JBibtexManager.this.journal_sorting_order = !JBibtexManager.this.journal_sorting_order;
                        JBibtexManager.this.numberRows();
                    }
                }
            }
        });
    }

    protected void setColumnWidth(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (n != 9) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
                tableColumn.setPreferredWidth(nArray[n]);
            }
            ++n;
        }
    }

    int findNextRowWithText(int n, String string) {
        if (n < 0) {
            n = 0;
        }
        int n2 = n + 1;
        while (n2 < this.table.getRowCount()) {
            if (this.model.columnHasText(n2, 3, string) || this.model.columnHasText(n2, 5, string) || this.model.columnHasText(n2, 2, string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    int findNextRowWithText(int n, String string, boolean bl, boolean bl2, boolean bl3) {
        if (n < 0) {
            n = 0;
        }
        if (bl) {
            if (bl2) {
                if (bl3) {
                    int n2 = n + 1;
                    while (n2 < this.table.getRowCount()) {
                        if (this.model.columnHasText(n2, 3, string) || this.model.columnHasText(n2, 5, string) || this.model.columnHasText(n2, 2, string)) {
                            return n2;
                        }
                        ++n2;
                    }
                } else {
                    int n3 = n + 1;
                    while (n3 < this.table.getRowCount()) {
                        if (this.model.columnHasText(n3, 3, string) || this.model.columnHasText(n3, 2, string)) {
                            return n3;
                        }
                        ++n3;
                    }
                }
            } else if (bl3) {
                int n4 = n + 1;
                while (n4 < this.table.getRowCount()) {
                    if (this.model.columnHasText(n4, 5, string) || this.model.columnHasText(n4, 2, string)) {
                        return n4;
                    }
                    ++n4;
                }
            } else {
                int n5 = n + 1;
                while (n5 < this.table.getRowCount()) {
                    if (this.model.columnHasText(n5, 2, string)) {
                        return n5;
                    }
                    ++n5;
                }
            }
        } else if (bl2) {
            if (bl3) {
                int n6 = n + 1;
                while (n6 < this.table.getRowCount()) {
                    if (this.model.columnHasText(n6, 5, string) || this.model.columnHasText(n6, 3, string)) {
                        return n6;
                    }
                    ++n6;
                }
            } else {
                int n7 = n + 1;
                while (n7 < this.table.getRowCount()) {
                    if (this.model.columnHasText(n7, 3, string)) {
                        return n7;
                    }
                    ++n7;
                }
            }
        } else if (bl3) {
            int n8 = n + 1;
            while (n8 < this.table.getRowCount()) {
                if (this.model.columnHasText(n8, 5, string)) {
                    return n8;
                }
                ++n8;
            }
        } else {
            return -1;
        }
        return -1;
    }

    void searchHelper(String string, HashSet hashSet, int n) {
        if (this.model.getRowCount() == 0 && this.key2bibitem.size() == 0) {
            return;
        }
        String string2 = JOptionPane.showInputDialog(this, (Object)string);
        if (string2 != null && string2.length() > 0) {
            HashSet hashSet2 = this.model.getColumnsWithText(n, string2);
            hashSet.addAll(hashSet2);
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                this.model.fireTableCellUpdated((Integer)iterator.next(), n);
            }
        }
    }

    protected void addOptionsMenu() {
        JRadioButton jRadioButton;
        JMenu jMenu = new JMenu("Options");
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Foreground Color");
        JMenuItem jMenuItem2 = new JMenuItem("Background Color");
        jMenuItem.setIcon(new ImageIcon(this.getClass().getResource("images16/ForegroundColor16.gif")));
        jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("images16/BackgroundColor16.gif")));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(null, "Selection Color", Globals.foregroundColor);
                if (color != null) {
                    Globals.updateForegroundColor(color.getRed(), color.getGreen(), color.getBlue());
                    JBibtexManager.this.flicker();
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(null, "Selection Color", Globals.backgroundColor);
                if (color != null) {
                    Globals.updateBackgroundColor(color.getRed(), color.getGreen(), color.getBlue());
                    JBibtexManager.this.flicker();
                }
            }
        });
        jMenu.add(jMenuItem2);
        ButtonModel buttonModel = null;
        ButtonModel buttonModel2 = null;
        ButtonModel buttonModel3 = null;
        ButtonModel buttonModel4 = null;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = JBibtexManager.getSelection(JBibtexManager.this.groupFontSize);
                JRadioButton jRadioButton2 = JBibtexManager.getSelection(JBibtexManager.this.groupFontName);
                String string = jRadioButton.getText();
                int n = Integer.parseInt(string.substring(0, string.length() - 2));
                Globals.updateFont(jRadioButton2.getText(), n);
                JBibtexManager.this.flicker();
            }
        };
        JMenu jMenu2 = new JMenu("Font Size");
        jMenu2.setIcon(new ImageIcon(this.getClass().getResource("images16/FontSize16.gif")));
        String[] stringArray = new String[]{"8pt", "10pt", "12pt", "14pt", "16pt"};
        int n = 0;
        while (n < stringArray.length) {
            jRadioButton = new JRadioButton(stringArray[n]);
            buttonModel = jRadioButton.getModel();
            buttonModel.addActionListener(actionListener);
            if (stringArray[n].equals(Globals.FONTSIZE + "pt")) {
                buttonModel3 = jRadioButton.getModel();
            }
            jMenu2.add(jRadioButton);
            this.groupFontSize.add(jRadioButton);
            ++n;
        }
        if (buttonModel3 != null) {
            this.groupFontSize.setSelected(buttonModel3, true);
        }
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Fonts");
        jMenu3.setIcon(new ImageIcon(this.getClass().getResource("images16/Font16.gif")));
        String[] stringArray2 = new String[]{"Courier", "Dialog", "Lucida Bright", "Lucida Sans", "Lucida Sans Typewriter", "Serif", "Times"};
        int n2 = 0;
        while (n2 < stringArray2.length) {
            jRadioButton = new JRadioButton(stringArray2[n2]);
            buttonModel2 = jRadioButton.getModel();
            buttonModel2.addActionListener(actionListener);
            if (stringArray2[n2].equalsIgnoreCase(Globals.FONTNAME)) {
                buttonModel4 = jRadioButton.getModel();
            }
            jMenu3.add(jRadioButton);
            this.groupFontName.add(jRadioButton);
            ++n2;
        }
        if (buttonModel4 != null) {
            this.groupFontName.setSelected(buttonModel4, true);
        }
        jMenu.add(jMenu3);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = JBibtexManager.getSelection(JBibtexManager.this.groupBackup);
                String string = jRadioButton.getText();
                Globals.BACKUP = string.equals("Yes");
            }
        };
        JMenu jMenu4 = new JMenu("Backup");
        jMenu4.setIcon(new ImageIcon(this.getClass().getResource("images16/Backup16.gif")));
        jRadioButton = new JRadioButton("Yes");
        jRadioButton.getModel().addActionListener(actionListener2);
        jMenu4.add(jRadioButton);
        this.groupBackup.add(jRadioButton);
        if (Globals.BACKUP) {
            this.groupBackup.setSelected(jRadioButton.getModel(), true);
        }
        jRadioButton = new JRadioButton("No");
        jRadioButton.getModel().addActionListener(actionListener2);
        jMenu4.add(jRadioButton);
        this.groupBackup.add(jRadioButton);
        if (!Globals.BACKUP) {
            this.groupBackup.setSelected(jRadioButton.getModel(), true);
        }
        jMenu.add(jMenu4);
        JMenu jMenu5 = new JMenu("Edit templates");
        jMenu5.setIcon(new ImageIcon(this.getClass().getResource("images16/Template16.gif")));
        jMenu.add(jMenu5);
        jMenu5.add(this.templateItem("Article", Globals.TEMPLATE_ARTICLE_PREF, Globals.TEMPLATE_ARTICLE));
        jMenu5.add(this.templateItem("Book", Globals.TEMPLATE_BOOK_PREF, Globals.TEMPLATE_BOOK));
        jMenu5.add(this.templateItem("InBook", Globals.TEMPLATE_INBOOK_PREF, Globals.TEMPLATE_INBOOK));
        jMenu5.add(this.templateItem("Booklet", Globals.TEMPLATE_BOOKLET_PREF, Globals.TEMPLATE_BOOKLET));
        jMenu5.add(this.templateItem("InCollection", Globals.TEMPLATE_INCOLLECTION_PREF, Globals.TEMPLATE_INCOLLECTION));
        jMenu5.add(this.templateItem("InProceedings", Globals.TEMPLATE_INPROCEEDINGS_PREF, Globals.TEMPLATE_INPROCEEDINGS));
        jMenu5.add(this.templateItem("Mannual", Globals.TEMPLATE_MANUAL_PREF, Globals.TEMPLATE_MANUAL));
        jMenu5.add(this.templateItem("MastersThesis", Globals.TEMPLATE_MASTERSTHESIS_PREF, Globals.TEMPLATE_MASTERSTHESIS));
        jMenu5.add(this.templateItem("Misc", Globals.TEMPLATE_MISC_PREF, Globals.TEMPLATE_MISC));
        jMenu5.add(this.templateItem("Periodical", Globals.TEMPLATE_PERIODICAL_PREF, Globals.TEMPLATE_PERIODICAL));
        jMenu5.add(this.templateItem("PhdThesis", Globals.TEMPLATE_PHDTHESIS_PREF, Globals.TEMPLATE_PHDTHESIS));
        jMenu5.add(this.templateItem("Proceedings", Globals.TEMPLATE_PROCEEDINGS_PREF, Globals.TEMPLATE_PROCEEDINGS));
        jMenu5.add(this.templateItem("TechReport", Globals.TEMPLATE_TECHREPORT_PREF, Globals.TEMPLATE_TECHREPORT));
        jMenu5.add(this.templateItem("Unpublished", Globals.TEMPLATE_UNPUBLISHED_PREF, Globals.TEMPLATE_UNPUBLISHED));
    }

    JMenuItem templateItem(final String string, final String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new TemplateDialog(null, string, string2, Globals.getTemplate(string2)).setVisible(true);
            }
        });
        return jMenuItem;
    }

    public static JRadioButton getSelection(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.getModel() != buttonGroup.getSelection()) continue;
            return jRadioButton;
        }
        return null;
    }

    protected void addMenu() {
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Edit");
        JMenu jMenu3 = new JMenu("Search");
        JMenu jMenu4 = new JMenu("Help");
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.addOptionsMenu();
        this.menuBar.add(jMenu4);
        this.prev_previousMenu = new JMenuItem("");
        this.prev_previousMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JBibtexManager.this.prev_previousMenu.getText();
                if (string != null && !string.equals("")) {
                    JBibtexManager.this.checkIfNeedToSaveFile();
                    JBibtexManager.this.readFileHelper(string);
                }
            }
        });
        this.prev_previousMenu.setFont(new Font("Times", 0, 9));
        this.previousMenu = new JMenuItem("");
        this.previousMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JBibtexManager.this.previousMenu.getText();
                if (string != null && !string.equals("")) {
                    JBibtexManager.this.checkIfNeedToSaveFile();
                    JBibtexManager.this.readFileHelper(string);
                }
            }
        });
        this.previousMenu.setFont(new Font("Times", 0, 9));
        JMenuItem jMenuItem = new JMenuItem("Open BibTex", new ImageIcon(this.getClass().getResource("images16/Open16.gif")));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.checkIfNeedToSaveFile();
                String string = JBibtexManager.this.getNewFile();
                if (string != null) {
                    JBibtexManager.this.readFileHelper(string);
                    JBibtexManager.this.repaint();
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Open Medline", new ImageIcon(this.getClass().getResource("images16/Open16.gif")));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.tempFilename = JBibtexManager.this.getNewFile();
                if (JBibtexManager.this.tempFilename != null) {
                    Thread thread = new Thread(this){
                        private final /* synthetic */ 20 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ArrayList arrayList = MedlineParser.readMedline(20.access$000(this.this$1).tempFilename);
                            if (arrayList != null) {
                                if (arrayList.size() > 0) {
                                    20.access$000(this.this$1).filename = 20.access$000(this.this$1).tempFilename = 20.access$000(this.this$1).auxFileReader(arrayList, 20.access$000(this.this$1).tempFilename);
                                } else {
                                    20.access$000(this.this$1).taskBar.show_message("empty file or wrong format");
                                }
                            } else {
                                20.access$000(this.this$1).taskBar.show_message("File Format Error: " + 20.access$000(this.this$1).tempFilename + " (expecting xml format)");
                            }
                        }
                    };
                    thread.start();
                }
            }

            static /* synthetic */ JBibtexManager access$000(20 var0) {
                return var0.JBibtexManager.this;
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Open SciFinder", new ImageIcon(this.getClass().getResource("images16/Open16.gif")));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.tempFilename = JBibtexManager.this.getNewFile();
                if (JBibtexManager.this.tempFilename != null) {
                    Thread thread = new Thread(this){
                        private final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ArrayList arrayList = Scifinder2bibtex.readSciFinderFile(22.access$100(this.this$1).tempFilename);
                            if (arrayList != null) {
                                if (arrayList.size() > 0) {
                                    22.access$100(this.this$1).filename = 22.access$100(this.this$1).tempFilename = 22.access$100(this.this$1).auxFileReader(arrayList, 22.access$100(this.this$1).tempFilename);
                                } else {
                                    22.access$100(this.this$1).taskBar.show_message("empty file or wrong format");
                                }
                            } else {
                                22.access$100(this.this$1).taskBar.show_message("File Format Error: " + 22.access$100(this.this$1).tempFilename + " ( expecting Scifinder format)");
                            }
                        }
                    };
                    thread.start();
                }
            }

            static /* synthetic */ JBibtexManager access$100(22 var0) {
                return var0.JBibtexManager.this;
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Append BibTex", new ImageIcon(this.getClass().getResource("images16/Open16.gif")));
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                if (!(JBibtexManager.this.filename == null || JBibtexManager.this.filename.equals("") || (string = JBibtexManager.this.previousMenu.getText()).equals("") || string.equals(JBibtexManager.this.prev_previousMenu.getText()))) {
                    JBibtexManager.this.prev_previousMenu.setText(string);
                }
                if ((string = JBibtexManager.this.getNewFile()) != null) {
                    JBibtexManager.this.readFileHelper(string, true);
                    JBibtexManager.this.repaint();
                }
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("Save", new ImageIcon(this.getClass().getResource("images16/Save16.gif")));
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.saveChangesToFile();
            }
        });
        JMenuItem jMenuItem6 = new JMenuItem("Delete Selection", new ImageIcon(this.getClass().getResource("images16/Delete16.gif")));
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.deleteBibtexItem();
            }
        });
        JMenuItem jMenuItem7 = new JMenuItem("Save Selected As", new ImageIcon(this.getClass().getResource("images16/Export16.gif")));
        jMenuItem7.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (JBibtexManager.this.selectedRows == null || JBibtexManager.this.selectedRows.length == 0) {
                    return;
                }
                String string = System.getProperty("user.dir");
                JFileChooser jFileChooser = new JFileChooser(new File(string));
                jFileChooser.addChoosableFileFilter(new BibFileFilter());
                jFileChooser.setDialogType(1);
                jFileChooser.showSaveDialog(null);
                File file = jFileChooser.getSelectedFile();
                if (file == null || file.equals("")) {
                    return;
                }
                String string2 = file.getAbsolutePath();
                File file2 = new File(string2);
                if (file2.exists()) {
                    Object[] objectArray = new String[]{"Append", "Overwrite"};
                    Object object = JOptionPane.showInputDialog(null, string2 + " already exists. What would your like to do?", "File Exists", 2, null, objectArray, objectArray[1]);
                    if (object == null) {
                        return;
                    }
                    if (object.toString().equals("Append")) {
                        try {
                            FileWriter fileWriter = new FileWriter(file2, true);
                            PrintWriter printWriter = new PrintWriter(fileWriter);
                            int n = 0;
                            while (n < JBibtexManager.this.selectedRows.length) {
                                printWriter.println(JBibtexManager.this.rowNum2bibitem(JBibtexManager.this.selectedRows[n]));
                                ++n;
                            }
                            fileWriter.close();
                            return;
                        }
                        catch (IOException iOException) {}
                        return;
                    } else {
                        if (!object.toString().equals("Overwrite")) return;
                        try {
                            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
                            int n = 0;
                            while (n < JBibtexManager.this.selectedRows.length) {
                                Bibitem bibitem = (Bibitem)JBibtexManager.this.key2bibitem.get(JBibtexManager.this.model.getValueAt(JBibtexManager.this.selectedRows[n], 9));
                                bufferedWriter.write(bibitem.toString());
                                ++n;
                            }
                            bufferedWriter.close();
                            return;
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                } else {
                    try {
                        FileWriter fileWriter = new FileWriter(file2);
                        PrintWriter printWriter = new PrintWriter(fileWriter);
                        int n = 0;
                        while (n < JBibtexManager.this.selectedRows.length) {
                            printWriter.println(JBibtexManager.this.rowNum2bibitem(JBibtexManager.this.selectedRows[n]).toString());
                            ++n;
                        }
                        fileWriter.close();
                        return;
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        JMenuItem jMenuItem8 = new JMenuItem("Print", new ImageIcon(this.getClass().getResource("images16/Print16.gif")));
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 28 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        try {
                            PrinterJob printerJob = PrinterJob.getPrinterJob();
                            printerJob.setPrintable(null);
                            if (!printerJob.printDialog()) {
                                return;
                            }
                            28.access$200(this.this$1).m_maxNumPage = 1;
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            printerException.printStackTrace();
                            System.err.println("Printing error: " + printerException.toString());
                        }
                    }
                };
                thread.start();
            }

            static /* synthetic */ JBibtexManager access$200(28 var0) {
                return var0.JBibtexManager.this;
            }
        });
        JMenuItem jMenuItem9 = new JMenuItem("Close", new ImageIcon(this.getClass().getResource("images16/Close16.gif")));
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.cleanUp();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem7);
        jMenu.add(jMenuItem8);
        jMenu.add(jMenuItem9);
        jMenu.add(new JSeparator());
        jMenu.add(this.previousMenu);
        jMenu.add(this.prev_previousMenu);
        JMenuItem jMenuItem10 = new JMenuItem("Find", new ImageIcon(this.getClass().getResource("images16/FindAgain16.gif")));
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JBibtexManager.this.model.getRowCount() == 0 && JBibtexManager.this.key2bibitem.size() == 0) {
                    return;
                }
                new FindAgainDialog(null).show();
            }
        });
        JMenuItem jMenuItem11 = new JMenuItem("New as form", new ImageIcon(this.getClass().getResource("images16/New16.gif")));
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BibEntryDialog bibEntryDialog = new BibEntryDialog(null, -1);
                bibEntryDialog.setDialogFont(Globals.tableFont);
                bibEntryDialog.setVisible(true);
            }
        });
        JMenuItem jMenuItem12 = new JMenuItem("Edit as form", new ImageIcon(this.getClass().getResource("images16/Edit16.gif")));
        jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(69, 1));
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.editBibtexDialog();
            }
        });
        JMenuItem jMenuItem13 = new JMenuItem("New as BibTex", new ImageIcon(this.getClass().getResource("images16/New16.gif")));
        jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BibStringEntryDialog bibStringEntryDialog = new BibStringEntryDialog(null, "Type in a single entry in Bibtex format", -1);
                bibStringEntryDialog.setDialogFont(Globals.tableFont);
                bibStringEntryDialog.setVisible(true);
            }
        });
        JMenuItem jMenuItem14 = new JMenuItem("Edit as BibTex", new ImageIcon(this.getClass().getResource("images16/Edit16.gif")));
        jMenuItem14.setAccelerator(KeyStroke.getKeyStroke(66, 1));
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBibtexManager.this.editBibtexStringDialog();
            }
        });
        JMenuItem jMenuItem15 = new JMenuItem("Find Duplicates", new ImageIcon(this.getClass().getResource("images16/Duplicates16.gif")));
        jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JBibtexManager.this.model.getRowCount() == 0 && JBibtexManager.this.key2bibitem.size() == 0) {
                    return;
                }
                HashSet<String> hashSet = new HashSet<String>(JBibtexManager.this.table.getRowCount());
                int n = 0;
                int n2 = 0;
                while (n2 < JBibtexManager.this.table.getRowCount()) {
                    String string = JBibtexManager.this.rowNum2bibitem(n2).toStringNoKey();
                    if (hashSet.contains(string)) {
                        JBibtexManager.this.table.addRowSelectionInterval(n2, n2);
                        ++n;
                    } else {
                        hashSet.add(string);
                    }
                    ++n2;
                }
                if (n == 0) {
                    JBibtexManager.this.taskBar.show_message("No duplicate keys found.");
                } else {
                    JBibtexManager.this.taskBar.show_message("Duplicate keys are highlighted.");
                }
            }
        });
        jMenu2.add(jMenuItem11);
        jMenu2.add(jMenuItem12);
        jMenu2.add(jMenuItem13);
        jMenu2.add(jMenuItem14);
        jMenu2.add(jMenuItem6);
        jMenu3.add(jMenuItem10);
        jMenu3.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem("Version");
        jMenuItem16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                JOptionPane.showMessageDialog(JBibtexManager.this.menuBar, "Version: 1.618\nrelease date (dd/mm/yyyy) : " + gregorianCalendar.get(5) + "/" + (gregorianCalendar.get(2) + 1) + "/" + gregorianCalendar.get(1));
            }
        });
        JMenuItem jMenuItem17 = new JMenuItem("Manual");
        JMenuItem jMenuItem18 = new JMenuItem("Author", new ImageIcon(this.getClass().getResource("images16/SendMail16.gif")));
        JMenuItem jMenuItem19 = new JMenuItem("License");
        jMenuItem17.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(JBibtexManager.this.menuBar, "This program manages citations in bibtex format\ncheck out: http://csb.stanford.edu/nbatada/JBibtexManager/\n\nSome tips:\n============\n\t * key, year, journal and type columns are sortable -- click on the column header to sort\n\t * for best results, print only in the landscape mode\n\t * sorting messes up the search results. So if you sort when \n\t\tyou have some highlighted terms, you will have to do a search again\n\t * if you find a bug, please email me the the input along with the \n\t\t description of what you were doing before you encountered the bug.");
            }
        });
        jMenuItem18.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(JBibtexManager.this.menuBar, "Nizar Batada \n nbatada@stanford.edu \n http://www.stanford.edu/~nbatada/\nIf you email me, please include the word JBibtexManager in the subject line.");
            }
        });
        jMenuItem19.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(JBibtexManager.this.menuBar, "Copyright (c) 2002-03 by Nizar N. Batada. \n This software is a free software; you can redistribute it \nunder the terms of the GNU Library General Public License \nas published by the Free Software Foundation. \n This software is made available in the hope that it will \nbe useful, but WITHOUT ANY WARRANTY; without even the \nimplied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR\n PURPOSE. See the GNU Library General Public License for more details. \n You should have received a copy of the GNU Library \nGeneral Public License along with this library; if not\n, write to the Free Software Foundation, Inc., \n675 Mass Ave, Cambridge, MA 02139, USA.  ");
            }
        });
        jMenu4.add(jMenuItem16);
        jMenu4.add(jMenuItem17);
        jMenu4.add(jMenuItem18);
        jMenu4.add(jMenuItem19);
    }

    public void sortAllRowsBy(BibtexTableModel bibtexTableModel, int n, boolean bl) {
        Collections.sort(bibtexTableModel.getDataArrayList(), new ColumnSorter(n, bl));
        bibtexTableModel.fireTableDataChanged();
    }

    public void highlight(JTextComponent jTextComponent, String string, Highlighter.HighlightPainter highlightPainter) {
        this.removeHighlights(jTextComponent);
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            Document document = jTextComponent.getDocument();
            String string2 = document.getText(0, document.getLength());
            int n = 0;
            Matcher matcher = Pattern.compile(string).matcher(string2);
            while (matcher.find()) {
                n = matcher.start();
                highlighter.addHighlight(n, matcher.end(), highlightPainter);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void removeHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        int n = 0;
        while (n < highlightArray.length) {
            if (highlightArray[n].getPainter() instanceof MyHighlightPainter) {
                highlighter.removeHighlight(highlightArray[n]);
            }
            ++n;
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        Font font = new Font("Times", 0, 7);
        if (n >= this.m_maxNumPage) {
            return -1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n3 = 0;
        int n4 = 0;
        pageFormat.setOrientation(0);
        if (pageFormat.getOrientation() == 1) {
            n3 = (int)pageFormat.getImageableWidth();
            n4 = (int)pageFormat.getImageableHeight();
        } else {
            n3 = (int)pageFormat.getImageableWidth();
            n3 += n3 / 2;
            n4 = (int)pageFormat.getImageableHeight();
            graphics.setClip(0, 0, n3, n4);
        }
        int n5 = 0;
        graphics.setColor(Color.black);
        Font font2 = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n5 += fontMetrics.getAscent();
        n5 += 20;
        Font font3 = this.table.getFont().deriveFont(1);
        graphics.setFont(font3);
        fontMetrics = graphics.getFontMetrics();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int[] nArray = new int[Globals.columnNames.length];
        nArray[0] = 0;
        int n6 = fontMetrics.getAscent();
        n5 += n6;
        int n7 = 0;
        while (n7 < Globals.columnNames.length) {
            block11: {
                TableColumn tableColumn;
                block12: {
                    if (n7 == 9) break block11;
                    tableColumn = tableColumnModel.getColumn(n7);
                    n2 = Globals.columnWidths_printing[n7];
                    if (nArray[n7] + n2 > n3) break;
                    if (n7 + 1 >= Globals.columnNames.length) break block12;
                    if (n7 == 9) break block11;
                    nArray[n7 + 1] = nArray[n7] + n2;
                }
                String string = (String)tableColumn.getIdentifier();
                graphics.drawString(string, nArray[n7], n5);
            }
            ++n7;
        }
        graphics.setFont(font);
        fontMetrics = graphics.getFontMetrics();
        int n8 = n5;
        n6 = fontMetrics.getHeight();
        n2 = Math.max((int)((double)n6 * 1.5), 10);
        int n9 = (n4 - n8) / n2;
        this.m_maxNumPage = Math.max((int)Math.ceil((double)this.table.getRowCount() / (double)n9), 1);
        TableModel tableModel = this.table.getModel();
        int n10 = n * n9;
        int n11 = Math.min(this.table.getRowCount(), n10 + n9);
        int n12 = n10;
        while (n12 < n11) {
            n5 += n6;
            n7 = 0;
            while (n7 < Globals.columnNames.length) {
                if (n7 != 9) {
                    int n13 = this.table.getColumnModel().getColumn(n7).getModelIndex();
                    String string = this.model.getValueAt(n12, n13).toString();
                    graphics.setColor(Color.black);
                    if (string.length() > Globals.columnWidths_printing_word[n7]) {
                        string = string.substring(0, Globals.columnWidths_printing_word[n7]);
                    }
                    graphics.drawString(string, nArray[n7], n5);
                }
                ++n7;
            }
            ++n12;
        }
        System.gc();
        return 1;
    }

    public void scrollToCenter(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        int n3 = (rectangle2.width - rectangle.width) / 2;
        int n4 = (rectangle2.height - rectangle.height) / 2;
        if (rectangle.x < n3) {
            n3 = -n3;
        }
        if (rectangle.y < n4) {
            n4 = -n4;
        }
        rectangle.translate(n3, n4);
        jViewport.scrollRectToVisible(rectangle);
    }

    String auxFileReader(ArrayList arrayList, String string) {
        try {
            if (!string.endsWith(".bib")) {
                string = string + ".bib";
            }
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file, false);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                printWriter.println(((Bibitem)iterator.next()).toString());
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("IOError:" + this.filename);
        }
        this.readFileHelper(string);
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame();
        JBibtexManager jBibtexManager = new JBibtexManager();
        jFrame.getContentPane().add(jBibtexManager);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
        jFrame.setSize(400, 500);
        if (stringArray.length > 0) {
            jBibtexManager.readFileHelper(stringArray[0]);
        }
    }

    static {
        allKeys = new HashSet();
        tabLength = 15;
    }

    protected class BibFileFilter
    extends FileFilter {
        protected BibFileFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".bib") || file.isDirectory() || string.endsWith(".txt") || string.endsWith(".xml");
        }

        public String getDescription() {
            return "*.bib or *.txt";
        }
    }

    protected class BibEntryDialog
    extends JDialog {
        JTextField pages;
        JTextField volume;
        JTextField title;
        JTextField year;
        JTextField key;
        JTextField series;
        JTextField editor;
        JTextField booktitle;
        JTextField address;
        JTextField number;
        JComboBox journal_cb;
        JComboBox type_cb;
        JComboBox author_cb;
        JButton ok;
        JButton cancel;
        String[] rowData = null;
        String oldKey = "";
        boolean data_read_ok = false;
        boolean edit_mode = false;
        int row_num;
        GridBagConstraints constraints;
        JPanel labelPanel;
        JPanel textFieldPanel;
        String[] ArticleEntries = new String[]{"KEY", "AUTHOR", "TITLE", "JOURNAL", "YEAR", "Volume", "Number", "Pages", "Month", "keyword", "note"};
        String[] BookEntries = new String[]{"KEY", "AUTHOR", "TITLE", "PUBLISHER", "YEAR", "Isbn", "Editor", "Volume", "Series", "Address", "Edition"};

        void setDialogFont(Font font) {
            this.setFont(font);
        }

        void addLabel(String string) {
            JLabel jLabel = new JLabel(string, 4);
            jLabel.setForeground(Globals.foregroundColor);
            this.labelPanel.add(jLabel);
        }

        JTextField addTextField(String string) {
            JTextField jTextField = new JTextField(string, 45);
            jTextField.setFont(Globals.tableFont);
            this.textFieldPanel.add(jTextField);
            return jTextField;
        }

        JTextField addMoreTextField(String string, Bibitem bibitem) {
            String string2 = bibitem.getByName(string);
            if (string2 == null) {
                string2 = "";
            }
            return this.addTextField(string2);
        }

        void createArticleForm() {
        }

        void getArticleInput() {
        }

        public BibEntryDialog(JFrame jFrame, int n) {
            super(jFrame, "bibtex entry", true);
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.row_num = -1;
            this.setSize(400, 150);
            int n2 = 9;
            int n3 = 2;
            String[] stringArray = new String[Globals.columnNames.length - 1];
            if (n >= 0) {
                this.edit_mode = true;
                this.row_num = n;
                int n4 = 0;
                while (n4 < Globals.columnNames.length - 1) {
                    stringArray[n4] = (String)JBibtexManager.this.model.getValueAt(n, n4);
                    ++n4;
                }
            }
            this.getContentPane().setLayout(new GridBagLayout());
            this.labelPanel = new JPanel(new GridLayout(0, 1));
            this.textFieldPanel = new JPanel(new GridLayout(0, 1));
            JPanel jPanel = new JPanel(new FlowLayout());
            this.constraints = new GridBagConstraints();
            this.constraints.weighty = 1.0;
            this.constraints.fill = 1;
            this.constraints.weightx = 0.0;
            int n5 = 0;
            int n6 = 0;
            this.addGB(this.labelPanel, 0, 0);
            this.constraints.weightx = 1.0;
            n5 = 1;
            n6 = 0;
            this.addGB(this.textFieldPanel, 1, 0);
            this.constraints.weightx = 1.33;
            n5 = 1;
            n6 = 1;
            this.addGB(jPanel, 1, 1);
            this.addLabel("TYPE:");
            this.addLabel("AUTHOR:");
            this.addLabel("KEY:");
            this.addLabel("TITLE:");
            this.addLabel("YEAR:");
            this.addLabel("JOURNAL:");
            this.addLabel("VOLUME:");
            this.addLabel("PAGES:");
            this.addLabel("SERIES:");
            this.addLabel("EDITOR:");
            this.addLabel("BOOKTITLE:");
            this.addLabel("ADDRESS:");
            this.addLabel("NUMBER:");
            Object[] objectArray = new Object[]{"Article", "Book", "Booklet", "InBook", "InCollection", "InProceedings", "Manual", "MastersThesis", "Misc", "PhDThesis", "Proceedings", "TechReport", "Unpublished"};
            this.type_cb = new JComboBox<Object>(objectArray);
            this.type_cb.setEditable(true);
            this.type_cb.setFont(Globals.tableFont);
            this.type_cb.setSelectedItem(stringArray[JBibtexManager.this.model.findColumn("type")]);
            this.textFieldPanel.add(this.type_cb);
            Object[] objectArray2 = JBibtexManager.this.getAllColumnData(3);
            this.author_cb = new JComboBox<Object>(objectArray2);
            this.author_cb.setEditable(true);
            this.author_cb.setFont(Globals.tableFont);
            this.author_cb.setSelectedItem(stringArray[JBibtexManager.this.model.findColumn("author")]);
            this.textFieldPanel.add(this.author_cb);
            this.oldKey = stringArray[2];
            if (this.oldKey == null) {
                this.oldKey = "";
            }
            this.key = this.addTextField(this.oldKey);
            this.title = this.addTextField(stringArray[JBibtexManager.this.model.findColumn("title")]);
            this.year = this.addTextField(stringArray[JBibtexManager.this.model.findColumn("year")]);
            Object[] objectArray3 = JBibtexManager.this.getAllColumnData(6);
            this.journal_cb = new JComboBox<Object>(objectArray3);
            this.journal_cb.setEditable(true);
            this.journal_cb.setFont(Globals.tableFont);
            this.journal_cb.setSelectedItem(stringArray[JBibtexManager.this.model.findColumn("journal")]);
            this.textFieldPanel.add(this.journal_cb);
            this.volume = this.addTextField(stringArray[JBibtexManager.this.model.findColumn("volume")]);
            this.pages = this.addTextField(stringArray[JBibtexManager.this.model.findColumn("pages")]);
            if (n > 0) {
                Bibitem bibitem = JBibtexManager.this.rowNum2bibitem(this.row_num);
                this.series = this.addMoreTextField("series", bibitem);
                this.editor = this.addMoreTextField("editor", bibitem);
                this.booktitle = this.addMoreTextField("booktitle", bibitem);
                this.address = this.addMoreTextField("address", bibitem);
                this.number = this.addMoreTextField("number", bibitem);
            } else {
                this.series = this.addTextField("");
                this.editor = this.addTextField("");
                this.booktitle = this.addTextField("");
                this.address = this.addTextField("");
                this.number = this.addTextField("");
            }
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            this.ok.setIcon(new ImageIcon(this.getClass().getResource("images16/Save16.gif")));
            this.cancel.setIcon(new ImageIcon(this.getClass().getResource("images16/ExitSmall.gif")));
            jPanel.add(this.ok);
            jPanel.add(this.cancel);
            this.pack();
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibEntryDialog this$1;
                {
                    this.this$1 = bibEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray;
                    String string = (String)this.this$1.author_cb.getSelectedItem();
                    string = string == null ? "" : string.trim();
                    String string2 = (String)this.this$1.journal_cb.getSelectedItem();
                    string2 = string2 == null ? "" : string2.trim();
                    String string3 = (String)this.this$1.type_cb.getSelectedItem();
                    string3 = string3 == null ? "" : string3.trim();
                    String string4 = this.this$1.year.getText().trim();
                    String string5 = this.this$1.title.getText().trim();
                    String string6 = this.this$1.key.getText().trim();
                    String string7 = this.this$1.volume.getText().trim();
                    String string8 = this.this$1.pages.getText().trim();
                    String string9 = this.this$1.series.getText().trim();
                    String string10 = this.this$1.editor.getText().trim();
                    String string11 = this.this$1.booktitle.getText().trim();
                    String string12 = this.this$1.address.getText().trim();
                    String string13 = this.this$1.number.getText().trim();
                    this.this$1.closeDialog();
                    if (string.equals("") && string2.equals("") && string4.equals("") && string5.equals("") && string6.equals("") && string7.equals("") && string8.equals("") && string9.equals("") && string11.equals("") && string10.equals("") && string12.equals("") && string13.equals("")) {
                        return;
                    }
                    BibEntryDialog.access$300((BibEntryDialog)this.this$1).contentChangedButNotSaved = true;
                    if (!this.this$1.edit_mode) {
                        Bibitem bibitem = new Bibitem(string, string5, string2, string6, string4, string8, string7, string3, string9, string10, string11, string12, string13, BibEntryDialog.access$300(this.this$1).nextKey(), BibEntryDialog.access$300((BibEntryDialog)this.this$1).model.getRowCount() + 1 + "");
                        BibEntryDialog.access$300(this.this$1).addBibEntry(bibitem);
                    } else {
                        Bibitem bibitem = BibEntryDialog.access$300(this.this$1).rowNum2bibitem(this.this$1.row_num);
                        bibitem.update(string, string5, string2, string6, string4, string8, string7, string3, string9, string10, string11, string12, string13);
                        objectArray = bibitem.toArray();
                        int n = 1;
                        while (n < Globals.columnNames.length) {
                            BibEntryDialog.access$300((BibEntryDialog)this.this$1).model.setValueAt(objectArray[n], this.this$1.row_num, n);
                            ++n;
                        }
                    }
                    if (string6.length() > 0 && !this.this$1.oldKey.equals(string6) && allKeys.contains(string6)) {
                        objectArray = new Object[]{"OK"};
                        JOptionPane.showMessageDialog(null, "Warning: there is a duplicate key: " + string6, "Duplicate Key Warning", 2);
                    }
                }
            });
            this.cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibEntryDialog this$1;
                {
                    this.this$1 = bibEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.closeDialog();
                }
            });
        }

        void addGB(Component component, int n, int n2) {
            this.constraints.gridx = n;
            this.constraints.gridy = n2;
            this.getContentPane().add(component, this.constraints);
        }

        public BibEntryDialog(JFrame jFrame) {
            this(jFrame, -1);
        }

        protected void closeDialog() {
            this.dispose();
        }

        static /* synthetic */ JBibtexManager access$300(BibEntryDialog bibEntryDialog) {
            return bibEntryDialog.JBibtexManager.this;
        }
    }

    protected class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }

    protected class BibStringEntryDialog
    extends JDialog {
        final JTextArea ta;
        final JButton cutButton;
        final JButton copyButton;
        final JButton pasteButton;
        final JButton ok;
        final JButton cancel;
        final JButton keybindings;
        final JButton undoButton;
        boolean editMode = false;
        int selectedRow;
        Bibitem b;
        Document doc;
        UndoManager undo;
        JToolBar toolbar;
        String[] templateNames = new String[]{"Article", "Book", "InProceedings"};
        String[] templateValues = new String[]{"@Article{,\n AUTHOR = {},\n TITLE = {},\n JOURNAL = {},\n YEAR = {},\n Volume = {},\n Number = {},\n Pages = {},\n Month = {},\n keywords = {},\n note = {},\n url = {},\n}", "@Book{,\n AUTHOR = {},\n TITLE = {},\n PUBLISHER = {},\n YEAR = {},\n Isbn = {},\n Editor = {},\n Volume = {},\n Series = {},\n Address = {},\n Edition = {},\n}", "@InProceedings{, AUTHOR = {},\n TITLE = {},\n BOOKTITLE = {},\n YEAR = {},\n Editor = {},\n Volume = {},\n Series = {},\n Organization = {},\n Publisher = {},\n Address = {},\n Month = {},\n Pages = {},\n}"};
        JPopupMenu menu;

        void setDialogFont(Font font) {
            this.ta.setFont(font);
        }

        BibStringEntryDialog(JFrame jFrame, String string, int n) {
            super((Frame)jFrame, string);
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            if (n >= 0) {
                this.editMode = true;
                this.selectedRow = n;
                this.b = (Bibitem)JBibtexManager.this.key2bibitem.get(JBibtexManager.this.model.getValueAt(this.selectedRow, 9));
                this.ta = new JTextArea(this.b.toString(), 25, 50);
            } else {
                this.ta = new JTextArea(25, 50);
            }
            JBibtexManager.this.highlight(this.ta, "\\b[A-Za-z]+\\b[\\s]*=|\\},", JBibtexManager.this.greenHighlightPainter);
            this.undo = new UndoManager();
            this.doc = this.ta.getDocument();
            this.ta.setTabSize(4);
            this.ta.setCaretColor(Globals.foregroundColor);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(this.ta), "Center");
            this.ok = new JButton("Done");
            this.ok.setIcon(new ImageIcon(this.getClass().getResource("images24/Save24.gif")));
            this.cancel = new JButton("Cancel");
            this.cancel.setIcon(new ImageIcon(this.getClass().getResource("images24/CloseAll24.gif")));
            this.cutButton = new JButton("Cut");
            this.cutButton.setIcon(new ImageIcon(this.getClass().getResource("images24/Cut24.gif")));
            this.copyButton = new JButton("Copy");
            this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("images24/Copy24.gif")));
            this.pasteButton = new JButton("Paste");
            this.pasteButton.setIcon(new ImageIcon(this.getClass().getResource("images24/Paste24.gif")));
            this.keybindings = new JButton("Keybindings");
            this.keybindings.setIcon(new ImageIcon(this.getClass().getResource("images24/TipOfTheDay24.gif")));
            this.undoButton = new JButton("Undo");
            this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("images24/Undo24.gif")));
            this.toolbar = new JToolBar();
            this.toolbar.setRollover(true);
            this.ok.setText(null);
            this.ok.setMargin(new Insets(0, 0, 0, 0));
            this.ok.setToolTipText("Done: Save changes");
            this.toolbar.add(this.ok);
            this.cancel.setText(null);
            this.cancel.setMargin(new Insets(0, 0, 0, 0));
            this.cancel.setToolTipText("Cancel: ignore changes");
            this.toolbar.add(this.cancel);
            this.cutButton.setText(null);
            this.cutButton.setMargin(new Insets(0, 0, 0, 0));
            this.cutButton.setToolTipText("Cut selection into clipboard");
            this.toolbar.add(this.cutButton);
            this.pasteButton.setText(null);
            this.pasteButton.setMargin(new Insets(0, 0, 0, 0));
            this.pasteButton.setToolTipText("Paste Selection from clipboard");
            this.toolbar.add(this.pasteButton);
            this.copyButton.setText(null);
            this.copyButton.setMargin(new Insets(0, 0, 0, 0));
            this.copyButton.setToolTipText("Copy selection into clipboard");
            this.toolbar.add(this.copyButton);
            this.undoButton.setText(null);
            this.undoButton.setMargin(new Insets(0, 0, 0, 0));
            this.undoButton.setToolTipText("Undo");
            this.toolbar.add(this.undoButton);
            this.keybindings.setText(null);
            this.keybindings.setMargin(new Insets(0, 0, 0, 0));
            this.keybindings.setToolTipText("List keybindings valid in this editor");
            this.toolbar.add(this.keybindings);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.addListeners();
            this.bindKeys();
            this.setTemplatePopups();
            this.pack();
        }

        protected void save() {
            String string = this.ta.getText().trim();
            if (string != null && string.length() > 0) {
                string = string.toString().replaceAll("[ \t\r\n]+", " ").replaceAll("@", "");
                if (this.editMode) {
                    this.b.update(string);
                    JBibtexManager.this.key2bibitem.put(this.b.getBibManKey(), this.b);
                    JBibtexManager.this.model.removeRow(this.selectedRow);
                    JBibtexManager.this.model.addRow(this.selectedRow, this.b.toList());
                } else {
                    JBibtexManager.this.addBibEntry(new Bibitem(string, JBibtexManager.this.nextKey(), "" + (JBibtexManager.this.model.getRowCount() + 1)));
                }
                JBibtexManager.this.contentChangedButNotSaved = true;
            }
            this.dispose();
        }

        protected void addListeners() {
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.save();
                }
            });
            this.cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            });
            this.cutButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = this.this$1.ta.getSelectedText();
                    if (string == null) {
                        return;
                    }
                    if (string.equals("")) {
                        string = this.this$1.ta.getText();
                    }
                    Globals.setClipboard(string);
                    this.this$1.ta.replaceSelection("");
                }
            });
            this.copyButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = this.this$1.ta.getSelectedText();
                    if (string == null) {
                        return;
                    }
                    if (string.equals("")) {
                        string = this.this$1.ta.getText();
                    }
                    Globals.setClipboard(string);
                }
            });
            this.pasteButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Globals.getClipboard();
                    if (string == null) {
                        return;
                    }
                    this.this$1.ta.replaceSelection(string);
                }
            });
            this.undoButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (this.this$1.undo.canUndo()) {
                            this.this$1.undo.undo();
                        }
                    }
                    catch (CannotUndoException cannotUndoException) {}
                }
            });
            this.keybindings.addActionListener(new ActionListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JOptionPane.showMessageDialog(null, "Following Key bindings work in this editing window:.\n C = Ctrl\nEmacs Type Key\nC-a         Begining-of-line\nC-e         End-of-line\nC-w         Cut selected region and put into clipboard\nC-y         Paste from system clipboard\nC-x C-c     Cancel (quit dialog without saving changes)\nC-x C-s     done (save) \n\nWindows Key bindings\nC-z         Undo\nC-s         done (save) \nC-x         Cut to Clipboard\nC-v         paste from Clipboard\nC-r         Redo\nC-q         Cancel\n\nOther Key bindings\nC-+         Enlarge window\nC--         Shrink window\nC-up        Selection right\nC-down      Selection down\nC-left      Selection left\nC-right     Selection right\nC-u         Undo\n", "Keybindings", 1);
                }
            });
        }

        void bindKeys() {
            this.doc.addUndoableEditListener(new UndoableEditListener(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    this.this$1.undo.addEdit(undoableEditEvent.getEdit());
                }
            });
            this.ta.getActionMap().put("Undo", new AbstractAction(this, "Undo"){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (this.this$1.undo.canUndo()) {
                            this.this$1.undo.undo();
                        }
                    }
                    catch (CannotUndoException cannotUndoException) {}
                }
            });
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke("control Z"), "Undo");
            this.ta.getActionMap().put("Redo", new AbstractAction(this, "Redo"){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (this.this$1.undo.canRedo()) {
                            this.this$1.undo.redo();
                        }
                    }
                    catch (CannotRedoException cannotRedoException) {}
                }
            });
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke(82, 1), "Redo");
            KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 2);
            this.ta.getInputMap(2).put(keyStroke, "caret-begin-line");
            keyStroke = KeyStroke.getKeyStroke(69, 2);
            this.ta.getInputMap(2).put(keyStroke, "caret-end-line");
            keyStroke = KeyStroke.getKeyStroke(89, 2);
            this.ta.getInputMap(2).put(keyStroke, "paste-from-clipboard");
            keyStroke = KeyStroke.getKeyStroke(86, 2);
            this.ta.getInputMap(2).put(keyStroke, "paste-from-clipboard");
            keyStroke = KeyStroke.getKeyStroke(87, 2);
            this.ta.getInputMap(2).put(keyStroke, "cut-to-clipboard");
            keyStroke = KeyStroke.getKeyStroke(88, 2);
            this.ta.getInputMap(2).put(keyStroke, "cut-to-clipboard");
            keyStroke = KeyStroke.getKeyStroke(39, 2);
            this.ta.getInputMap(2).put(keyStroke, "selection-forward");
            keyStroke = KeyStroke.getKeyStroke(37, 2);
            this.ta.getInputMap(2).put(keyStroke, "selection-backward");
            keyStroke = KeyStroke.getKeyStroke(38, 2);
            this.ta.getInputMap(2).put(keyStroke, "selection-up");
            keyStroke = KeyStroke.getKeyStroke(40, 2);
            this.ta.getInputMap(2).put(keyStroke, "selection-down");
            this.ta.getActionMap().put("Abort", new AbstractAction(this, "Abort"){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            });
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke(81, 2), "Abort");
            this.ta.getActionMap().put("Save", new AbstractAction(this, "Save"){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.save();
                }
            });
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke(83, 2), "Save");
            this.ta.getActionMap().put("Shrink", new AbstractAction(this, "Shrink"){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ta.setColumns(this.this$1.ta.getColumns() - 4);
                    this.this$1.ta.setRows(this.this$1.ta.getRows() - 4);
                    this.this$1.pack();
                }
            });
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke(45, 2), "Shrink");
            this.ta.getActionMap().put("Grow", new AbstractAction(this, "Grow"){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ta.setColumns(this.this$1.ta.getColumns() + 4);
                    this.this$1.ta.setRows(this.this$1.ta.getRows() + 4);
                    this.this$1.pack();
                }
            });
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke(107, 2), "Grow");
            this.ta.getInputMap(2).put(KeyStroke.getKeyStroke("Ctrl +"), "Grow");
        }

        void putTemplateItem(String string, String string2) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(this, string2){
                private final /* synthetic */ String val$TemplateName;
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                    this.val$TemplateName = string;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ta.replaceSelection(Globals.getTemplate(this.val$TemplateName));
                }
            });
            this.menu.add(jMenuItem);
        }

        void setTemplatePopups() {
            this.menu = new JPopupMenu();
            this.putTemplateItem("Article", Globals.TEMPLATE_ARTICLE_PREF);
            this.putTemplateItem("Book", Globals.TEMPLATE_BOOK_PREF);
            this.putTemplateItem("InBook", Globals.TEMPLATE_INBOOK_PREF);
            this.putTemplateItem("Booklet", Globals.TEMPLATE_BOOKLET_PREF);
            this.putTemplateItem("InCollection", Globals.TEMPLATE_INCOLLECTION_PREF);
            this.putTemplateItem("InProceedings", Globals.TEMPLATE_INPROCEEDINGS_PREF);
            this.putTemplateItem("Manual", Globals.TEMPLATE_MANUAL_PREF);
            this.putTemplateItem("MastersThesis", Globals.TEMPLATE_MASTERSTHESIS_PREF);
            this.putTemplateItem("Misc", Globals.TEMPLATE_MISC_PREF);
            this.putTemplateItem("Periodical", Globals.TEMPLATE_PERIODICAL_PREF);
            this.putTemplateItem("PhdThesis", Globals.TEMPLATE_PHDTHESIS_PREF);
            this.putTemplateItem("Proceedings", Globals.TEMPLATE_PROCEEDINGS_PREF);
            this.putTemplateItem("TechReport", Globals.TEMPLATE_TECHREPORT_PREF);
            this.putTemplateItem("Unpublished", Globals.TEMPLATE_UNPUBLISHED_PREF);
            this.ta.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ BibStringEntryDialog this$1;
                {
                    this.this$1 = bibStringEntryDialog;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.this$1.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        this.this$1.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    protected class TemplateDialog
    extends JDialog {
        final JTextArea ta;
        final JButton ok;
        String templateName;

        TemplateDialog(JFrame jFrame, String string, String string2, String string3) {
            super((Frame)jFrame, "Template Editor: " + string);
            this.setSize(400, 300);
            this.templateName = string2;
            this.ok = new JButton("ok", new ImageIcon(this.getClass().getResource("images16/Save16.gif")));
            this.setDefaultCloseOperation(2);
            this.ta = new JTextArea(string3.replaceAll(",[\\n]*", ",\n"), 25, 50);
            this.ta.setFont(Globals.tableFont);
            this.ta.setTabSize(4);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(this.ta), "Center");
            this.getContentPane().add((Component)this.ok, "South");
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ TemplateDialog this$1;
                {
                    this.this$1 = templateDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.save();
                }
            });
        }

        protected void save() {
            String string = this.ta.getText();
            if (string != null) {
                Globals.updateTemplate(this.templateName, string);
            }
            this.dispose();
        }
    }

    protected class FindAgainDialog
    extends JDialog {
        final JTextField tf;
        final JButton find;
        final JButton done;
        String prevQuery = "";
        String currQuery = "";
        int startSearchRow = 0;
        JCheckBox keyCheckBox;
        JCheckBox authorCheckBox;
        JCheckBox titleCheckBox;

        FindAgainDialog(JFrame jFrame) {
            super((Frame)jFrame, "Search");
            this.setModal(false);
            this.setDefaultCloseOperation(2);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Enter text to search:", 2));
            this.tf = new JTextField(10);
            jPanel.add(this.tf);
            container.add((Component)jPanel, "North");
            this.keyCheckBox = new JCheckBox("Key", true);
            this.authorCheckBox = new JCheckBox("Author", true);
            this.titleCheckBox = new JCheckBox("Title", true);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.keyCheckBox);
            jPanel2.add(this.authorCheckBox);
            jPanel2.add(this.titleCheckBox);
            container.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel();
            this.find = new JButton("Find");
            this.find.setIcon(new ImageIcon(this.getClass().getResource("images24/FindAgain24.gif")));
            this.done = new JButton("Done");
            this.done.setIcon(new ImageIcon(this.getClass().getResource("images24/Stop24.gif")));
            jPanel3.add(this.find);
            jPanel3.add(this.done);
            container.add((Component)jPanel3, "South");
            KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 2);
            this.tf.getInputMap(2).put(keyStroke, "caret-begin-line");
            keyStroke = KeyStroke.getKeyStroke(69, 2);
            this.tf.getInputMap(2).put(keyStroke, "caret-end-line");
            this.tf.getActionMap().put("kill", new AbstractAction(this, "kill"){
                private final /* synthetic */ FindAgainDialog this$1;
                {
                    this.this$1 = findAgainDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.tf.setText("");
                }
            });
            keyStroke = KeyStroke.getKeyStroke(75, 2);
            this.tf.getInputMap(2).put(keyStroke, "kill");
            this.find.getActionMap().put("find", new AbstractAction(this, "find"){
                private final /* synthetic */ FindAgainDialog this$1;
                {
                    this.this$1 = findAgainDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.findAgain();
                }
            });
            this.find.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl F"), "find");
            keyStroke = KeyStroke.getKeyStroke("ctrl Q");
            this.done.getActionMap().put("cancel", new AbstractAction(this, "cancel"){
                private final /* synthetic */ FindAgainDialog this$1;
                {
                    this.this$1 = findAgainDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            });
            this.done.getInputMap(2).put(keyStroke, "cancel");
            this.find.addActionListener(new ActionListener(this){
                private final /* synthetic */ FindAgainDialog this$1;
                {
                    this.this$1 = findAgainDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.findAgain();
                }
            });
            this.done.addActionListener(new ActionListener(this){
                private final /* synthetic */ FindAgainDialog this$1;
                {
                    this.this$1 = findAgainDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            });
            this.pack();
        }

        void findAgain() {
            boolean bl = this.authorCheckBox.isSelected();
            boolean bl2 = this.titleCheckBox.isSelected();
            boolean bl3 = this.keyCheckBox.isSelected();
            this.currQuery = this.tf.getText();
            if (this.currQuery.trim().length() == 0) {
                return;
            }
            if (!this.currQuery.equals(this.prevQuery)) {
                this.prevQuery = this.currQuery;
                this.startSearchRow = 0;
            } else if (this.startSearchRow < 0) {
                this.startSearchRow = 0;
            }
            JBibtexManager.this.table.removeRowSelectionInterval(this.startSearchRow, this.startSearchRow);
            this.startSearchRow = JBibtexManager.this.findNextRowWithText(this.startSearchRow, this.currQuery, bl3, bl, bl2);
            if (this.startSearchRow >= 0) {
                JBibtexManager.this.scrollToCenter(JBibtexManager.this.table, this.startSearchRow, 0);
                JBibtexManager.this.table.setRowSelectionInterval(this.startSearchRow, this.startSearchRow);
            }
        }
    }
}

