#ifndef lint
static char *copyright = "Copyright (C) 1985, Sven Mattisson.";
#endif

#include <stdio.h>
#include <ctype.h>
#include "l2sl.h"
#include "hash.h"

int optarg = 0, seen_lb = 0, lb_lines = 0, seen_array = 0;

main (argc,argv)
	char **argv;
{
	int i;

	inithashtab ();
	if (argc==1) {
	    yyin = stdin;
	    yylex ();
	} else for (i=1; i<argc; i++) {
	    yyin = fopen (argv[i],"r");
	    if (yyin == NULL) {
		fprintf (stderr,"can't open %s\n",argv[i]);
		exit (1);
	    }
	    yylex ();
	}
	exit (0);
}

yywrap ()
{
    if (seen_lb != 0)
	fprintf (stderr, "Possible optional argument bracket mismatch\n");
    return (1);
}

parens (s)
    char *s;
{
    int i;
    char *p;

    if ((p=index(s, '(')) != NULL)
        *p = '"';
    else {
	i++;
	p = s;
    }
    if ((p=index(p, ')')) != NULL)
	*p = '"';
    else
	i++;
    return (i);
}

subst (s)
    char *s;
{
    for (; *s; s++)
        switch (*s) {
	    case OESC:
	        *s = NESC;
	        break;
	    case OLGR:
	        *s = NLGR;
	        break;
	    case ORGR:
	        *s = NRGR;
	        break;
	}
}

char *
strip (s)
    char *s;
{
    static char buf[100];
    char *p;

    for (p = buf; *s && !isspace (*s); s++, p++) {
        *p = *s;
    }
    *p = '\0';
    return (buf);
}
