---
myst:
  html_meta:
    keywords: LaTeX, fichiers, postscript, graphiques, Metapost
---

# Comment afficher une sortie MetaPost dans `ghostscript` ?

MetaPost s'attend normalement à ce que sa sortie soit incluse dans un contexte 
où les polices MetaFont "standard" (que vous avez spécifiées) sont déjà définies 
--- par exemple, en tant que figure dans un document TeX. Si vous déboguez votre code MetaPost, 
vous pouvez le visualiser dans un visualiseur basé sur [`ghostscript`](https://www.ghostscript.com/).
Toutefois, ces visualiseurs (même `ghostscript`) *n'ont pas* normalement ces polices à disposition 
et vous rencontrerez une erreur telle que

```text
Error : /undefined in cmmi10
```

Il existe une disposition dans MetaPost pour éviter ce problème : lancer la commande 
`prologues := 2;` au début du fichier `mp`.

Malheureusement, le PostScript que MetaPost insère dans sa sortie, suite à cette commande, 
est incompatible avec l'utilisation ordinaire du PostScript pour des inclusions 
dans les documents (La)TeX, il est donc préférable de rendre la commande `prologues` optionnelle. 
En outre, MetaPost adopte une approche très simple du codage des polices : 
comme les codages des polices TeX sont tout sauf basiques, 
le codage du texte dans les diagrammes se pose comme une autre source de problèmes. 
Si vous observez ce type d'anomalies (des caractères disparaissent ou sont mal présentés), 
la solution est de voir la sortie "originale" de MetaPost après traitement par LaTeX et `dvips`.

La compilation peut être faite en entrant `MaFigure.mp` 
indirectement à partir d'un simple `MaFigureAffichee.mp` encapsulant le premier fichier :

```text
prologues := 2;
input MaFigure
```

Elle peut aussi être obtenue en lançant une commande shell telle que

```bash
mp "\prologues:=2; input MaFigure"
```

Elle fonctionnera sans les guillemets si vous n'utilisez pas un shell Unix.

Un code LaTeX approprié pour cet exemple serait :

```{noedit}
\documentclass{article}
  \usepackage{graphicx}

\begin{document}
\thispagestyle{empty}
\includegraphics{MyFigure.1}
\end{document}
```

Pour le traiter avec `dvips`, la commande serait alors :

```bash
dvips -E -o MaFigure.eps MaFigure
```

Cela donne alors un fichier PostScript encapsulé satisfaisant. 
Cette procédure peut être automatisée à l'aide du script Perl `mps2eps`, 
ce qui permet d'éviter un certain nombre de manipulations fastidieuses.

L'utilisateur de Plain TeX peut utiliser une adaptation, par Dan Luecking, 
d'une méthode de Donald Knuth. Son programme 
[mpsproof.tex](https://ctan.org/tex-archive/obsolete/graphics/metapost/base/texmf/tex/generic/metapost) 
fonctionnera sous TeX pour produire un fichier DVI à utiliser avec `dvips`, 
ou sous pdfTeX pour produire un fichier PDF, directement. 
La sortie est configurée pour ressembler à une feuille d'épreuve.

Un script, `mptopdf`, est disponible dans les distributions récentes de (La)TeX : 
il semble assez fiable pour produire du PDF à partir de MetaPost 
et peut donc raisonnablement être considéré comme une réponse à la question.


:::{sources}
[Displaying MetaPost output in ghostscript](faquk:FAQ-mpprologues)
:::
