/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

class PrintDoubleSided
extends JDialog
implements ActionListener {
    private int m_DefaultDoubleSide = 0;
    private JRadioButton[] radios = null;
    private DviFile m_Source = null;
    private String m_Description;
    private String m_PrintPasses;
    private String m_CloseMenu;

    PrintDoubleSided(DviFile dviFile, String string) {
        super((Frame)dviFile, string);
        this.m_Source = dviFile;
        this.m_DefaultDoubleSide = this.m_Source.getDefaultDoubleSide();
        this.radios = new JRadioButton[6];
        int n = 0;
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(0, 1));
        String string2 = "print.Double";
        StringTokenizer stringTokenizer = new StringTokenizer(DviMain.getResourceString(string2));
        while (stringTokenizer.hasMoreElements()) {
            Object object;
            Serializable serializable;
            String string3 = stringTokenizer.nextToken();
            String string4 = DviMain.getResourceString(string3 + ".type");
            if (string4.equals("item")) {
                serializable = new JMenuItem(DviMain.getResourceString(string3 + ".label"));
                object = DviMain.getResourceString(string3 + ".mnemonic");
                if (object != null) {
                    ((AbstractButton)serializable).setMnemonic(GetKeyCode.getKeyCode((String)object));
                }
                ((AbstractButton)serializable).addActionListener(this);
                container.add((Component)serializable);
                if (string3.equals("print.DoubleDesc")) {
                    this.m_Description = ((AbstractButton)serializable).getActionCommand();
                    continue;
                }
                if (string3.equals("print.DoubleDoIt")) {
                    this.m_PrintPasses = ((AbstractButton)serializable).getActionCommand();
                    continue;
                }
                if (!string3.equals("print.DoubleClose")) continue;
                this.m_CloseMenu = ((AbstractButton)serializable).getActionCommand();
                continue;
            }
            if (string4.equals("label")) {
                serializable = new JLabel(DviMain.getResourceString(string3 + ".label"));
                container.add((Component)serializable);
                continue;
            }
            if (!string4.equals("group")) continue;
            serializable = new ButtonGroup();
            object = new StringTokenizer(DviMain.getResourceString(string3));
            while (((StringTokenizer)object).hasMoreElements()) {
                int n2;
                String string5 = ((StringTokenizer)object).nextToken();
                String string6 = DviMain.getResourceString(string5 + ".type");
                if (!string6.equals("radio")) continue;
                JRadioButton jRadioButton = new JRadioButton(DviMain.getResourceString(string5 + ".label"));
                String string7 = DviMain.getResourceString(string5 + ".mnemonic");
                if (string7 != null) {
                    jRadioButton.setMnemonic(GetKeyCode.getKeyCode(string7));
                }
                jRadioButton.setSelected(((n2 = this.m_DefaultDoubleSide >> 2 - (n >> 1)) & 1) == (n & 1));
                ((ButtonGroup)serializable).add(jRadioButton);
                container.add(jRadioButton);
                this.radios[n] = jRadioButton;
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = 0;
        if (this.radios[1].isSelected()) {
            n += 4;
        }
        if (this.radios[3].isSelected()) {
            n += 2;
        }
        if (this.radios[5].isSelected()) {
            ++n;
        }
        this.m_Source.setDefaultDoubleSide(n);
        this.m_DefaultDoubleSide = n;
        String string = actionEvent.getActionCommand();
        if (string.equals(this.m_Description)) {
            this.m_Source.getSource();
            object = DviMain.getResourceString("print.DoubleDesc.message");
            int n2 = JOptionPane.showConfirmDialog(this, object, "Double Sided Printing Description", 2, 1);
        }
        if (string.equals(this.m_CloseMenu)) {
            this.dispose();
            return;
        }
        if (string.equals(this.m_PrintPasses)) {
            object = PrinterJob.getPrinterJob();
            if (((PrinterJob)object).printDialog()) {
                PageFormat pageFormat = ((PrinterJob)object).defaultPage();
                DviMain dviMain = this.m_Source.getSource();
                pageFormat.setOrientation(this.m_Source.getPaperOrient());
                Dimension dimension = this.m_Source.getPaperSize();
                Paper paper = pageFormat.getPaper();
                paper.setImageableArea(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
                pageFormat.setPaper(paper);
                ((PrinterJob)object).setPrintable(this.m_Source.getPage(), pageFormat);
                this.m_Source.getPage().setPrintOption(this.m_DefaultDoubleSide);
                try {
                    ((PrinterJob)object).print();
                }
                catch (PrinterException printerException) {
                    System.out.println("PrintListener e=" + printerException.getMessage());
                    printerException.printStackTrace();
                }
                int n3 = JOptionPane.showConfirmDialog(this, DviMain.getResourceString("print.DoubleDoIt.message"), DviMain.getResourceString("print.DoubleDoIt.label2"), 2);
                if (n3 == 0) {
                    this.m_Source.getPage().setPrintOption(this.m_DefaultDoubleSide + 8);
                    try {
                        ((PrinterJob)object).print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println("PrintListener e=" + printerException.getMessage());
                        printerException.printStackTrace();
                    }
                }
            } else {
                this.m_Source.getLog().append("User aborted Print.\n");
            }
            this.dispose();
            return;
        }
    }
}

