/* This file is part of dvi2bitmap; see README for copyrights and licence */

#ifndef PIPE_STREAM_HEADER_READ
#define PIPE_STREAM_HEADER_READ 1

#include <InputByteStream.h>
#include <sys/types.h>

/**
 * Runs an external program, and provides access to the result.  This
 * runs a given command in a forked process, optionally adjusting the
 * environment as it does so.  The output from the command is
 * available using the methods of an {@link InputByteStream}, plus an
 * additional one which retrieves the entire result as a string.
 */
class PipeStream : public InputByteStream {
 public:
    PipeStream (string cmd, string envs="")
	    throw (InputByteStreamError);
    ~PipeStream();
    string getResult(bool allOfFile=false, bool gobbleRest=true)
	    throw (InputByteStreamError);
    virtual void close(void);
    int getTerminationStatus(void);
    /**
     * Returns the PID of the running process.  After the process has
     * finished, this will return zero.
     *
     * @return the process's PID, or zero if it has finished
     */
    pid_t getPid(void) const { return pid_; };
 private:
    int pipe_status_;
    pid_t pid_;
#ifdef WIN32
    FILE *fp_;
#endif // WIN32
    const string orig_command_;
};

#endif /* PIPE_STREAM_HEADER_READ */
