/* Main include file for this implementation.  Everybody includes this.  */

#ifndef EXTRA_H
#define EXTRA_H

#include <stdio.h>
#include "site.h"

/* pltotf et al. use the symbol `index' themselves; we don't want to
   redefine it in those cases (and those programs don't use the other
   string functions, fortunately).  */ 
#ifndef index
#ifndef	BSD
#include <string.h>
#define index strchr
#define rindex strrchr
#else /* BSD */
#include <strings.h>
#endif /* BSD */
#endif /* not index */

extern char *getenv (), *rindex ();
extern SPRINTF_RETURN_TYPE sprintf ();


/* Global constants.  */
#define true 1
#define false 0

/* Path searching.  The `...PATH' constants are used both as indices and
   just as enumeration values.  Their values must match the
   initialization of `env_var_names' in extra.c.  The `...PATHBIT'
   constants are used in the argument to `setpaths'.  */
#define BIBINPUTPATH	0
#define BIBINPUTPATHBIT (1 << BIBINPUTPATH)
#define GFFILEPATH	1
#define GFFILEPATHBIT (1 << GFFILEPATH)
#define MFBASEPATH	2
#define MFBASEPATHBIT (1 << MFBASEPATH)
#define MFINPUTPATH	3
#define MFINPUTPATHBIT (1 << MFINPUTPATH)
#define MFPOOLPATH	4
#define MFPOOLPATHBIT (1 << MFPOOLPATH)
#define PKFILEPATH	5
#define PKFILEPATHBIT (1 << PKFILEPATH)
#define TEXFORMATPATH	6
#define TEXFORMATPATHBIT (1 << TEXFORMATPATH)
#define TEXINPUTPATH	7
#define TEXINPUTPATHBIT (1 << TEXINPUTPATH)
#define TEXPOOLPATH	8
#define TEXPOOLPATHBIT (1 << TEXPOOLPATH)
#define TFMFILEPATH	9
#define TFMFILEPATHBIT (1 << TFMFILEPATH)
#define VFFILEPATH     10
#define VFFILEPATHBIT (1 << VFFILEPATH)

/* For some initializations of constant strings.  */
typedef char *ccharpointer;

/* We need one global variable.  */
extern integer argc;

/* Globally needed routines we can implement as macros.  */
#define	abs(x)		((x) >= 0 ? (x) : -(x)) /*Integer abs*/
#define	fabs(x)		((x) >= 0.0 ? (x) : -(x)) /*real*/
#define	odd(x)		((x) % 2)
#define ord(x)		(x)
#define	chr(x)		(char)(x)
#define	round(x)	zround ((double) (x))
#define	incr(x)		++(x)
#define	decr(x)		--(x)
#define	toint(x)	((integer) (x))
#define trunc(x)	((integer) (x))
/* ``Unix exit'', since WEB already defines the symbol `exit'.  */
#define	uexit		exit
#define dispose( x)     ( free( (char*) x))


/* C doesn't distinguish between text files and other files.  */
typedef FILE *file_ptr;
typedef file_ptr text[1] ;


/*File functions. All altered by RMD as you need an extra level of pointer*/
#define eof(f)		test_eof (f)
#define flush(f)	(void) fflush (*f)
#define	Fputs(f, s)	(void) fputs (s, *f)  /* fixwrites outputs this.  */
#define	input3ints(a, b, c)  zinput3ints (&a, &b, &c)
#define printreal(r, n, m)  fprintreal (stdout, r, n, m)
#define	putbyte(x, f)	putc ((char) (x) & 255, *f)
#define read(f, b)	((b) = getc (*f))
#define	readln(f)       { register c; \
                          while ((c = getc (*f)) != '\n' && c != EOF); }
#define page(file)      putc( '\f', *file)

/* Open files for reading and writing.  */
#define	reset(f, n) \
  ((*f) ? fclose (*f) : 0), (*f) = checked_fopen ((char *) (n), "r")
#define rewrite(f, n) \
  (*f) = checked_fopen ((char *) (n), "w")

/* For throwing away input from the file F.  */
#define vgetc(f)	(void) getc (*f)

/* If we don't care that strcpy(3) returns A.  */
#define vstrcpy(a, b)	(void) strcpy (a, b)

/* Write out elements START through END of BUF to the file F.  */
#define writechunk(f, buf, start, end) \
  (void) fwrite (&buf[start], sizeof (buf[start]), end - start + 1, *f)

/* Like fseek(3), but cast the arguments and ignore the return value.  */
#define checkedfseek(f, n, w)  (void) fseek(*f, (long) n, (int) w)


/* Routines in extra.c and main.c.  */
#ifdef ANSI
extern void argv (int, char[]);
extern FILE *checked_fopen (char *, char *);
extern boolean eoln (text);
extern void fprintreal (text, double, int, int);
extern integer inputint (text);
extern char *xmalloc (unsigned), *xrealloc (char *, unsigned);
extern integer zround (double);
#else /* not ANSI */
extern void argv ();
extern FILE *checked_fopen ();
extern boolean eoln ();
extern void fprintreal ();
extern integer inputint();
extern void fprintreal ();
extern char *xmalloc (), *xrealloc ();
extern integer zround ();
#endif /* not ANSI */

#endif /* not EXTRA_H */

