#!/usr/bin/perl
#
# Script to print the key, the reference type, and the first part of the
#  title of ALL the references in a BiBTeX database.
#
#
#  This script is part of the XBibFile software package.
#  Writer:  Ross Maloney
#  Date:    August 2000
#

while ( <> ) {
    chomp;
    if ( /@/ )  {
      $count++ ;
      $type = 'x';
      if ( /\@ARTICLE/ ) {  $type = 'A' } ;
      if ( /\@BOOK/ ) {  $type = 'B' } ;
      if ( /\@INCOLLECTION/ ) {  $type = 'C' } ;
      if ( /\@INPROCEEDINGS/ ) {  $type = 'P' } ;
      if ( /\@PHDTHESIS/ ) {  $type = 'T' } ;
      @fields = split(/{/, $_);
      $fields[1] =~ s/,//;
      printf "\n%s  %s", $type, $fields[1];
    }
    else { if ( /^ +title = \{/ ) {
             @fields = split(/{/, $_);
             $fields[1] =~ s/},//;
             printf "\t%s", substr($fields[1], 0, 50) ;
	 }
    }
}
print "\nnumber of references = $count\n" ;
