/* This file is a part of XBibFile - a system for handling BibTeX references
 *
 * Author:   Ross Maloney
 * Date:     January 2002
 *
 */

#include  <stdio.h>
#include  <string.h>
#include  <gtk/gtk.h>

GtkWidget  *summary;
GtkWidget  *text, *textblock, *scrollblock;
GtkTextBuffer  *textpad;
GtkTextIter  iter;

extern  FILE  *refFile;                     /* defined in xbibfile.c */

void  all(GtkWidget *widget)
{
  GtkTooltips  *tooltips;
  GtkWidget  *window, *panel, *description, *controls;
  GtkWidget  *key0, *key1;

  extern  void  close_window(GtkWidget *);    /* defined in file cleanup.c */
  extern  void  error();                      /* defined in file error.c */
  void  put_refs_inplace(GtkWidget *);

  tooltips = gtk_tooltips_new();

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "XBibFile inspect");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_window_set_default_size(GTK_WINDOW(window), 500, 500);
  panel = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), panel);
  description = gtk_label_new("References found in the database");
  gtk_box_pack_start(GTK_BOX(panel), description, FALSE, TRUE, 10);

                          /* create the text display part of the window */
  textblock = gtk_scrolled_window_new(NULL, NULL);
  textpad = gtk_text_buffer_new(NULL);
  text = gtk_text_view_new_with_buffer(textpad);
  gtk_container_add(GTK_CONTAINER(textblock), text);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(textblock),
                                 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start_defaults(GTK_BOX(panel), textblock);

                          /* put the window control buttons in place */
  controls = gtk_hbox_new(FALSE, 0);
  key0 = gtk_button_new_with_label("CANCEL");
  gtk_widget_set_usize(GTK_WIDGET(key0), 90, -1);
  g_signal_connect(GTK_OBJECT(key0), "clicked",
                     G_CALLBACK(close_window), NULL);
  gtk_tooltips_set_tip(tooltips, key0,
                       "Finish this reference probe", NULL);
  gtk_box_pack_end(GTK_BOX(controls), key0, FALSE, FALSE, 10);

                           /* and put the summary line in place */
  summary = gtk_entry_new();
  gtk_editable_set_editable(GTK_EDITABLE(summary), FALSE);
  gtk_widget_set_usize(GTK_WIDGET(summary), 150, 20);
  gtk_box_pack_start(GTK_BOX(controls), summary, FALSE, FALSE, 10);
  gtk_box_pack_end(GTK_BOX(panel), controls, FALSE, TRUE, 10);

                          /* now put the 'style' for the text output */
  gtk_text_buffer_create_tag(textpad, "blackface",
                             "foreground", "black", NULL);
  gtk_text_buffer_create_tag(textpad, "emphasis",
                             "foreground", "red", NULL);
  gtk_text_buffer_create_tag(textpad, "point",
                             "size", 11 * PANGO_SCALE, NULL);
  gtk_text_buffer_create_tag(textpad, "font",
                             "style", PANGO_STYLE_NORMAL, NULL);

                          /* put the required text into the window */
  put_refs_inplace(widget);

                          /* put the composite window on the screen */
  gtk_widget_show_all(window);
}

/* This procedure performs the required searching and returns its results
 * in the text window create in the  all()  procedure
 */

void  put_refs_inplace(GtkWidget  *widget)
{
  int  i, count;
  char  *start, *end;
  char  holder[200], temp[100], report[30];
  
  rewind(refFile);
  gtk_text_buffer_get_iter_at_offset(textpad, &iter, 0);
  i = 0;
  count = 0;
  while ( ( holder[i] = getc(refFile) ) != EOF )  {
    if ( holder[i] == '\n' )  {
      if ( holder[0] == '@' )  {
        if ( strstr( holder, "ARTICLE") ) 
	  strcpy(temp, "Article   ");
        if ( strstr( holder, "BOOK") ) 
	  strcpy(temp, "Book   ");
        if ( strstr( holder, "BOOKLET") ) 
	  strcpy(temp, "Booklet   ");
        if ( strstr( holder, "CONFERENCE") ) 
	  strcpy(temp, "Conference  ");
        if ( strstr( holder, "INBOOK") ) 
	  strcpy(temp, "inBook   ");
        if ( strstr( holder, "INCOLLECTION") ) 
	  strcpy(temp, "Incollection   ");
        if ( strstr( holder, "INPROCEEDINGS") ) 
	  strcpy(temp, "inProceedings   ");
        if ( strstr( holder, "MANUAL") ) 
	  strcpy(temp, "Manual   ");
        if ( strstr( holder, "MASTERSTHESIS") ) 
	  strcpy(temp, "Masters   ");
        if ( strstr( holder, "MISC") ) 
	  strcpy(temp, "Misc   ");
        if ( strstr( holder, "PHDTHESIS") ) 
	  strcpy(temp, "PhD Thesis   ");
        if ( strstr( holder, "PROCEEDINGS") ) 
	  strcpy(temp, "Proceedngs   ");
        if ( strstr( holder, "TECHREPORT") ) 
	  strcpy(temp, "Tech Report   ");
        if ( strstr( holder, "UNPUBLISHED") ) 
	  strcpy(temp, "Unpublished   ");
	  gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                temp, -1,
			"blackface", "point", "font", NULL);
	if ( start = strstr( holder, "{" ) ) 
	  if ( end = strstr( holder, "," ) )  {
	    *end = ' ';
	    end++;
	    *end = ' ';
	    end++;
	    *end = '\0';
	    gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                    start+1, -1,
			    "emphasis", "point", "font", NULL);
	  }
	  else {
	    error(widget, GINT_TO_POINTER(9));
	    g_print("Format error in this BibTeX file - no ending ,");
	  }
	else  {
	  error(widget, GINT_TO_POINTER(9));
	  g_print("Format error in this BibTeX file - no {");
	}
	count++;
      }
      i = 0;
      if ( start = strstr( holder, "  title = {" ) )
        if ( end = strstr( holder, "}," )  ) {
	  if ( (end - start) > 60 )
	    end = start + 60;
	  *end = '\n';
	  end++;
	  *end = '\0';
	  start += 10;
	  *start = ' ';
	  gtk_text_buffer_insert_with_tags_by_name(textpad, &iter,
	                  start, -1,
			  "blackface", "point", "font", NULL);
	}
	else  {
	  error(widget, GINT_TO_POINTER(9));
	  g_print("Format error in this BibTeX file - no ending ,}");
	}
    }
    else
      i++;
  }
  sprintf(report, "%d references displayed", count);
  gtk_entry_set_text(GTK_ENTRY(summary), report);
} 
