/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPreferencePage;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JUnitPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static JUnitPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.junit";
    public static final String ID_EXTENSION_POINT_TESTRUN_LISTENERS = "org.eclipse.jdt.junit.testRunListeners";
    public static final String ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS = "org.eclipse.jdt.junit.junitLaunchConfigs";
    public static final String TEST_SUPERCLASS_NAME = "junit.framework.TestCase";
    public static final String TEST_INTERFACE_NAME = "junit.framework.Test";
    public static final String JUNIT_HOME = "JUNIT_HOME";
    private static URL fgIconBaseURL;
    private AbstractSet fTrackedLaunches = new HashSet(20);
    private List fTestRunListeners;
    private List fJUnitLaunchConfigTypeIDs;

    public JUnitPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgPlugin = this;
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(Platform.getBundle((String)PLUGIN_ID).getEntry("/"), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static JUnitPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = fgPlugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        JUnitPreferencePage.initializeDefaults(store);
    }

    public static void log(Throwable e) {
        JUnitPlugin.log((IStatus)new Status(4, JUnitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitPlugin.getDefault().getLog().log(status);
    }

    public static URL makeIconFileURL(String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(fgIconBaseURL, name);
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            return ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL(relativePath));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void launchRemoved(final ILaunch launch) {
        this.fTrackedLaunches.remove(launch);
        JUnitPlugin.getDisplay().asyncExec(new Runnable(){

            public void run() {
                TestRunnerViewPart testRunnerViewPart = JUnitPlugin.this.findTestRunnerViewPartInActivePage();
                if (testRunnerViewPart != null && testRunnerViewPart.isCreated() && launch.equals(testRunnerViewPart.getLastLaunch())) {
                    testRunnerViewPart.reset();
                }
            }
        });
    }

    public void launchAdded(ILaunch launch) {
        this.fTrackedLaunches.add(launch);
    }

    public void connectTestRunner(ILaunch launch, IType launchedType, int port) {
        TestRunnerViewPart testRunnerViewPart = this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
        if (testRunnerViewPart != null) {
            testRunnerViewPart.startTestRunListening((IJavaElement)launchedType, port, launch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
        TestRunnerViewPart testRunnerViewPart;
        block10: {
            IWorkbenchPage page;
            IWorkbenchPart activePart;
            block8: {
                TestRunnerViewPart testRunnerViewPart2;
                block9: {
                    block6: {
                        TestRunnerViewPart testRunnerViewPart3;
                        block7: {
                            activePart = null;
                            page = null;
                            if (testRunner == null || !testRunner.isCreated()) break block6;
                            testRunnerViewPart3 = testRunner;
                            Object var7_8 = null;
                            if (page == null || activePart == null) break block7;
                            page.activate(activePart);
                        }
                        return testRunnerViewPart3;
                    }
                    page = JUnitPlugin.getActivePage();
                    if (page != null) break block8;
                    testRunnerViewPart2 = null;
                    Object var7_9 = null;
                    if (page == null || activePart == null) break block9;
                    page.activate(activePart);
                }
                return testRunnerViewPart2;
            }
            try {
                activePart = page.getActivePart();
                testRunnerViewPart = (TestRunnerViewPart)page.showView("org.eclipse.jdt.junit.ResultView");
                Object var7_10 = null;
                if (page == null || activePart == null) break block10;
            }
            catch (PartInitException pie) {
                TestRunnerViewPart testRunnerViewPart4;
                block11: {
                    try {
                        JUnitPlugin.log(pie);
                        testRunnerViewPart4 = null;
                        Object var7_11 = null;
                        if (page == null || activePart == null) break block11;
                    }
                    catch (Throwable throwable) {
                        block12: {
                            Object var7_12 = null;
                            if (page == null || activePart == null) break block12;
                            page.activate(activePart);
                        }
                        throw throwable;
                    }
                    page.activate(activePart);
                }
                return testRunnerViewPart4;
            }
            page.activate(activePart);
        }
        return testRunnerViewPart;
    }

    private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
        IWorkbenchPage page = JUnitPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (TestRunnerViewPart)page.findView("org.eclipse.jdt.junit.ResultView");
    }

    public void launchChanged(final ILaunch launch) {
        if (!this.fTrackedLaunches.contains(launch)) {
            return;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        IType launchedType = null;
        int port = -1;
        if (config != null) {
            String portStr = launch.getAttribute("org.eclipse.jdt.junit.PORT");
            String typeStr = launch.getAttribute("org.eclipse.jdt.junit.TESTTYPE");
            if (portStr != null && typeStr != null) {
                port = Integer.parseInt(portStr);
                IJavaElement element = JavaCore.create((String)typeStr);
                if (element instanceof IType) {
                    launchedType = (IType)element;
                }
            }
        }
        if (launchedType != null) {
            this.fTrackedLaunches.remove(launch);
            final int finalPort = port;
            final IType finalType = launchedType;
            JUnitPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JUnitPlugin.this.connectTestRunner(launch, finalType, finalPort);
                }
            });
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunchListener((ILaunchListener)this);
        }
        finally {
            super.stop(context);
        }
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ElementListSelectionDialog createAllPackagesDialog(Shell shell, IJavaProject[] originals, final boolean includeDefaultPackage) throws JavaModelException {
        final ArrayList packageList = new ArrayList();
        if (originals == null) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel model = JavaCore.create((IWorkspaceRoot)wsroot);
            originals = model.getJavaProjects();
        }
        final IJavaProject[] projects = originals;
        final JavaModelException[] exception = new JavaModelException[1];
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    HashSet<String> packageNameSet = new HashSet<String>();
                    pm.beginTask(JUnitMessages.getString("JUnitPlugin.searching"), projects.length);
                    for (int i = 0; i < projects.length; ++i) {
                        IPackageFragment[] pkgs = projects[i].getPackageFragments();
                        for (int j = 0; j < pkgs.length; ++j) {
                            IPackageFragment pkg = pkgs[j];
                            if (!pkg.hasChildren() && pkg.getNonJavaResources().length > 0) continue;
                            String pkgName = pkg.getElementName();
                            if (!includeDefaultPackage && pkgName.length() == 0 || !packageNameSet.add(pkgName)) continue;
                            packageList.add(pkg);
                        }
                        pm.worked(1);
                    }
                    pm.done();
                }
                catch (JavaModelException jme) {
                    exception[0] = jme;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(r);
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log(e);
        }
        catch (InterruptedException e) {
            JUnitPlugin.log(e);
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setIgnoreCase(false);
        dialog.setElements(packageList.toArray());
        return dialog;
    }

    private void loadTestRunListeners() {
        this.fTestRunListeners = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_LISTENERS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(PLUGIN_ID, 0, "Could not load some testRunner extension points", null);
        for (int i = 0; i < configs.length; ++i) {
            try {
                ITestRunListener testRunListener = (ITestRunListener)configs[i].createExecutableExtension("class");
                this.fTestRunListeners.add(testRunListener);
                continue;
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (!status.isOK()) {
            JUnitPlugin.log((IStatus)status);
        }
    }

    private void loadLaunchConfigTypeIDs() {
        this.fJUnitLaunchConfigTypeIDs = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        for (int i = 0; i < configs.length; ++i) {
            String configTypeID = configs[i].getAttribute("configTypeID");
            this.fJUnitLaunchConfigTypeIDs.add(configTypeID);
        }
    }

    public List getTestRunListeners() {
        if (this.fTestRunListeners == null) {
            this.loadTestRunListeners();
        }
        return this.fTestRunListeners;
    }

    public List getJUnitLaunchConfigTypeIDs() {
        if (this.fJUnitLaunchConfigTypeIDs == null) {
            this.loadLaunchConfigTypeIDs();
        }
        return this.fJUnitLaunchConfigTypeIDs;
    }

    public void addTestRunListener(ITestRunListener newListener) {
        if (this.fTestRunListeners == null) {
            this.loadTestRunListeners();
        }
        Iterator iter = this.fTestRunListeners.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o != newListener) continue;
            return;
        }
        this.fTestRunListeners.add(newListener);
    }

    public void removeTestRunListener(ITestRunListener newListener) {
        if (this.fTestRunListeners != null) {
            this.fTestRunListeners.remove(newListener);
        }
    }
}

