/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.AddUnimplementedMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.OverrideMethodDialog;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class OverrideMethodsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.getString("OverrideMethodsAction.error.title");
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public OverrideMethodsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("OverrideMethodsAction.label"));
        this.setDescription(ActionMessages.getString("OverrideMethodsAction.description"));
        this.setToolTipText(ActionMessages.getString("OverrideMethodsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.add_unimplemented_methods_action_context");
    }

    public OverrideMethodsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isAnonymous();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        Shell shell = this.getShell();
        try {
            IType type = this.getSelectedType(selection);
            if (type == null) {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("OverrideMethodsAction.not_applicable"));
                return;
            }
            if (!ElementValidator.check((IJavaElement)type, this.getShell(), this.getDialogTitle(), false) || !ActionUtil.isProcessable(this.getShell(), type)) {
                return;
            }
            if (type == null) {
                MessageDialog.openError((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("OverrideMethodsAction.error.type_removed_in_editor"));
                return;
            }
            this.run(shell, type);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), ActionMessages.getString("OverrideMethodsAction.error.actionfailed"));
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void run(ITextSelection selection) {
        Shell shell = this.getShell();
        try {
            IType type = SelectionConverter.getTypeAtOffset(this.fEditor);
            if (type != null) {
                if (!ElementValidator.check((IJavaElement)type, shell, this.getDialogTitle(), false) || !ActionUtil.isProcessable(shell, type)) {
                    return;
                }
                if (type.isInterface() || type.isAnonymous()) {
                    MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("OverrideMethodsAction.not_applicable"));
                    return;
                }
                this.run(shell, type);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("OverrideMethodsAction.not_applicable"));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.getString("OverrideMethodsAction.error.actionfailed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Shell shell, IType type) throws JavaModelException, CoreException {
        OverrideMethodDialog dialog = new OverrideMethodDialog(shell, this.fEditor, type, false);
        IMethod[] selected = null;
        if (!dialog.hasMethodsToOverride()) {
            MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("OverrideMethodsAction.error.nothing_found"));
            return;
        }
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            IRewriteTarget target;
            Object[] checkedElements = dialog.getResult();
            if (checkedElements == null) {
                return;
            }
            ArrayList<Object> result = new ArrayList<Object>(checkedElements.length);
            for (int i = 0; i < checkedElements.length; ++i) {
                Object curr = checkedElements[i];
                if (!(curr instanceof IMethod)) continue;
                result.add(curr);
            }
            selected = result.toArray(new IMethod[result.size()]);
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            settings.createComments = dialog.getGenerateComment();
            IEditorPart editor = EditorUtility.openInEditor(type.getCompilationUnit());
            IRewriteTarget iRewriteTarget = editor != null ? (IRewriteTarget)editor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = OverrideMethodsAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget) : (target = null);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                IJavaElement elementPosition = dialog.getElementPosition();
                AddUnimplementedMethodsOperation op = new AddUnimplementedMethodsOperation(type, settings, selected, false, elementPosition);
                Object context = JavaPlugin.getActiveWorkbenchWindow();
                if (context == null) {
                    context = new BusyIndicatorRunnableContext();
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                IMethod[] res = op.getCreatedMethods();
                if (res == null || res.length == 0) {
                    MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.getString("OverrideMethodsAction.error.nothing_found"));
                } else if (editor != null) {
                    EditorUtility.revealInEditor(editor, (IJavaElement)res[0]);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
            }
            catch (InterruptedException e) {
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit cu;
        IType type;
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getCompilationUnit() != null && type2.isClass()) {
                return type2;
            }
        } else if (elements[0] instanceof ICompilationUnit && !(type = (cu = (ICompilationUnit)elements[0]).findPrimaryType()).isInterface()) {
            return type;
        }
        return null;
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

