/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;

public class ConvertedProjectsPage
extends WizardPage {
    private Button updateBuildPathButton;
    private CheckboxTableViewer projectViewer;
    public static final String KEY_TITLE = "ConvertedProjectWizard.title";
    public static final String KEY_UPDATE_BUILD_PATH = "ConvertedProjectWizard.updateBuildPath";
    public static final String KEY_CONVERTING = "ConvertedProjectWizard.converting";
    public static final String KEY_UPDATING = "ConvertedProjectWizard.updating";
    public static final String KEY_DESC = "ConvertedProjectWizard.desc";
    public static final String KEY_PROJECT_LIST = "ConvertedProjectWizard.projectList";
    private static final String UPDATE_SECTION = "ConvertedProjectsPageUpdate";
    private TablePart tablePart;

    public ConvertedProjectsPage(Vector initialSelection) {
        super("convertedProjects");
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.tablePart = new TablePart(PDEPlugin.getResourceString(KEY_PROJECT_LIST));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.projectViewer = this.tablePart.getTableViewer();
        this.projectViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object object) {
                IProject project = (IProject)object;
                return project.isOpen() && !PDE.hasPluginNature((IProject)project);
            }
        });
        this.projectViewer.setInput((Object)PDEPlugin.getWorkspace());
        this.updateBuildPathButton = new Button(container, 32);
        this.updateBuildPathButton.setText(PDEPlugin.getResourceString(KEY_UPDATE_BUILD_PATH));
        this.updateBuildPathButton.setSelection(this.getDialogSettings().getBoolean(UPDATE_SECTION));
        this.updateBuildPathButton.setLayoutData((Object)new GridData(768));
        this.updateBuildPathButton.setEnabled(false);
        this.tablePart.updateCounter(0);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.converted_projects");
    }

    private static String createInitialName(String id) {
        int loc = id.lastIndexOf(46);
        if (loc == -1) {
            return id;
        }
        StringBuffer buf = new StringBuffer(id.substring(loc + 1));
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private static void createManifestFile(IFile file, IProgressMonitor monitor) throws CoreException {
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        model.load();
        IPlugin plugin = model.getPlugin();
        plugin.setId(file.getProject().getName());
        plugin.setName(ConvertedProjectsPage.createInitialName(plugin.getId()));
        plugin.setVersion("1.0.0");
        model.save();
    }

    public boolean finish() {
        final boolean updateBuildPath = this.updateBuildPathButton.getSelection() && this.updateBuildPathButton.isEnabled();
        final Object[] selected = this.tablePart.getSelection();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(UPDATE_SECTION, updateBuildPath);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    ConvertedProjectsPage.this.convertProjects(selected, updateBuildPath, monitor);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    public static void updateBuildPath(IProject project, IProgressMonitor monitor) throws CoreException {
        IPath manifestPath = project.getFullPath().append("plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(manifestPath);
        if (!file.exists()) {
            return;
        }
        WorkspacePluginModel model = new WorkspacePluginModel(file);
        model.load();
        if (!model.isLoaded()) {
            return;
        }
        ClasspathUtilCore.setClasspath((IPluginModelBase)model, (IProgressMonitor)monitor);
    }

    public static void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        IPath manifestPath = project.getFullPath().append("plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(manifestPath);
        if (file.exists()) {
            IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.manifestEditor");
        } else {
            manifestPath = project.getFullPath().append("fragment.xml");
            IFile fragmentFile = project.getWorkspace().getRoot().getFile(manifestPath);
            if (!fragmentFile.exists()) {
                ConvertedProjectsPage.createManifestFile(file, monitor);
            }
            IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.manifestEditor");
        }
        IPath buildPath = project.getFullPath().append("build.properties");
        IFile buildFile = project.getWorkspace().getRoot().getFile(buildPath);
        if (buildFile.exists()) {
            IDE.setDefaultEditor((IFile)buildFile, (String)"org.eclipse.pde.ui.buildEditor");
        }
    }

    private void convertProjects(Object[] selected, boolean updateBuildPath, IProgressMonitor monitor) throws CoreException {
        int i;
        int totalCount = updateBuildPath ? 2 * selected.length : selected.length;
        monitor.beginTask(PDEPlugin.getResourceString(KEY_CONVERTING), totalCount);
        for (i = 0; i < selected.length; ++i) {
            ConvertedProjectsPage.convertProject((IProject)selected[i], monitor);
            monitor.worked(1);
        }
        if (updateBuildPath) {
            monitor.subTask(PDEPlugin.getResourceString(KEY_UPDATING));
            for (i = 0; i < selected.length; ++i) {
                if (((IProject)selected[i]).hasNature("org.eclipse.jdt.core.javanature")) {
                    ConvertedProjectsPage.updateBuildPath((IProject)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    continue;
                }
                monitor.worked(1);
            }
        }
        monitor.done();
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            ConvertedProjectsPage.this.setPageComplete(count > 0);
            if (ConvertedProjectsPage.this.updateBuildPathButton == null) {
                return;
            }
            Object[] selected = ConvertedProjectsPage.this.tablePart.getSelection();
            ConvertedProjectsPage.this.updateBuildPathButton.setEnabled(false);
            for (int i = 0; i < selected.length; ++i) {
                try {
                    if (!((IProject)selected[i]).hasNature("org.eclipse.jdt.core.javanature")) continue;
                    ConvertedProjectsPage.this.updateBuildPathButton.setEnabled(true);
                    break;
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        }
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return ((IProject)obj).getName();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }

    public class ProjectContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            IWorkspace workspace = (IWorkspace)parent;
            return workspace.getRoot().getProjects();
        }
    }
}

