/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLPartitionScanner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DescriptionSection
extends PDESection
implements IPartSelectionListener {
    private Button applyButton;
    private Button resetButton;
    private IDocument document;
    private boolean editable = true;
    private SourceViewerConfiguration sourceConfiguration;
    private ISchemaObject element;
    private SourceViewer sourceViewer;
    public static final String SECTION_TITLE = "SchemaEditor.DescriptionSection.title";
    public static final String KEY_APPLY = "Actions.apply.flabel";
    public static final String KEY_RESET = "Actions.reset.flabel";
    public static final String SECTION_DESC = "SchemaEditor.DescriptionSection.desc";
    private IDocumentPartitioner partitioner;
    private ISchema schema;
    private boolean ignoreChange = false;

    public DescriptionSection(PDEFormPage page, Composite parent, IColorManager colorManager) {
        super(page, parent, 128);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.sourceConfiguration = new XMLConfiguration(colorManager);
        this.document = new Document();
        this.partitioner = new DefaultPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        this.partitioner.connect(this.document);
        this.document.setDocumentPartitioner(this.partitioner);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private void checkForPendingChanges() {
        if (this.applyButton.isEnabled()) {
            this.handleApply();
        }
    }

    public void commit(boolean onSave) {
        this.handleApply();
        if (onSave) {
            this.resetButton.setEnabled(false);
        }
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        container.setLayout((Layout)layout);
        int styles = 834;
        this.sourceViewer = new SourceViewer(container, null, styles);
        this.sourceViewer.configure(this.sourceConfiguration);
        this.sourceViewer.setDocument(this.document);
        this.sourceViewer.setEditable(this.isEditable());
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DescriptionSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        if (!SWT.getPlatform().equals("motif")) {
            toolkit.paintBordersFor(container);
        }
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 64;
        control.setLayoutData((Object)gd);
        styledText.setMenu(this.getPage().getPDEEditor().getContextMenu());
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DescriptionSection.this.updateSelection(DescriptionSection.this.sourceViewer.getSelection());
            }
        });
        Composite buttonContainer = toolkit.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        this.applyButton.setEnabled(false);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionSection.this.handleApply();
            }
        });
        this.resetButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        this.resetButton.setEnabled(false);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionSection.this.handleReset();
            }
        });
        section.setClient((Control)container);
        this.initialize();
    }

    private void updateSelection(ISelection selection) {
        this.getPage().getPDEEditor().setSelection(selection);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.sourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.sourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.sourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.sourceViewer.doOperation(7);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.sourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            this.sourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            this.sourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleApply() {
        if (this.element != null) {
            if (this.element == this.schema) {
                ((Schema)this.schema).setDescription(this.document.get());
            } else {
                ((SchemaObject)this.element).setDescription(this.document.get());
            }
        }
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    private void handleReset() {
        this.updateDocument();
    }

    public void initialize() {
        this.schema = (ISchema)this.getPage().getModel();
        this.element = this.schema;
        this.updateDocument();
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!DescriptionSection.this.ignoreChange && DescriptionSection.this.schema instanceof IEditable) {
                    DescriptionSection.this.markDirty();
                }
                DescriptionSection.this.applyButton.setEnabled(true);
                DescriptionSection.this.resetButton.setEnabled(true);
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        this.checkForPendingChanges();
        if (!(part instanceof ElementSection)) {
            return;
        }
        Object changeObject = ((IStructuredSelection)selection).getFirstElement();
        this.element = (ISchemaObject)changeObject;
        if (this.element == null) {
            this.element = this.schema;
        }
        this.updateDocument();
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void updateDocument() {
        this.ignoreChange = true;
        String text = this.element.getDescription();
        if (text == null) {
            text = "";
        }
        this.document.set(text);
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.ignoreChange = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.sourceViewer.canDoOperation(5);
    }
}

