/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;
import org.eclipse.ui.IWorkbenchPart;

public abstract class RepositoryLocationOperation
extends RemoteOperation {
    protected RepositoryLocationOperation(IWorkbenchPart part, ICVSRemoteResource[] remoteResources) {
        super(part, remoteResources);
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        Map table = this.getLocationMapping(this.getRemoteResources());
        Set keySet = table.keySet();
        monitor.beginTask(null, keySet.size() * 100);
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            ICVSRepositoryLocation location = (ICVSRepositoryLocation)iterator.next();
            List list = (List)table.get(location);
            ICVSRemoteResource[] remoteResources = list.toArray(new ICVSRemoteResource[list.size()]);
            this.execute(location, remoteResources, Policy.subMonitorFor(monitor, 100));
        }
    }

    protected abstract void execute(ICVSRepositoryLocation var1, ICVSRemoteResource[] var2, IProgressMonitor var3) throws CVSException;

    private Map getLocationMapping(ICVSRemoteResource[] remoteResources) {
        HashMap<ICVSRepositoryLocation, ArrayList<ICVSRemoteResource>> locationsMap = new HashMap<ICVSRepositoryLocation, ArrayList<ICVSRemoteResource>>();
        for (int i = 0; i < remoteResources.length; ++i) {
            ICVSRemoteResource resource = remoteResources[i];
            ICVSRepositoryLocation location = resource.getRepository();
            ArrayList<ICVSRemoteResource> resources = (ArrayList<ICVSRemoteResource>)locationsMap.get(location);
            if (resources == null) {
                resources = new ArrayList<ICVSRemoteResource>();
                locationsMap.put(location, resources);
            }
            resources.add(resource);
        }
        return locationsMap;
    }
}

