/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XColor;

public final class Color {
    public XColor handle;
    Device device;

    Color() {
    }

    public Color(Device device, int red, int green, int blue) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, red, green, blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rgb) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(device, rgb.red, rgb.green, rgb.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        int xDisplay = this.device.xDisplay;
        int pixel = this.handle.pixel;
        if (this.device.colorRefCount != null) {
            int n = pixel;
            this.device.colorRefCount[n] = this.device.colorRefCount[n] - 1;
            if (this.device.colorRefCount[n] == 0) {
                this.device.xcolors[pixel] = null;
            }
        }
        int colormap = OS.XDefaultColormap(xDisplay, OS.XDefaultScreen(xDisplay));
        OS.XFreeColors(xDisplay, colormap, new int[]{pixel}, 1, 0);
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        XColor xColor = color.handle;
        if (this.handle == xColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == xColor.red && this.handle.green == xColor.green && this.handle.blue == xColor.blue;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle.red >> 8 & 0xFF, this.handle.green >> 8 & 0xFF, this.handle.blue >> 8 & 0xFF);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue;
    }

    void init(Device device, int red, int green, int blue) {
        int i;
        this.device = device;
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        XColor xColor = new XColor();
        xColor.red = (short)(red & 0xFF | (red & 0xFF) << 8);
        xColor.green = (short)(green & 0xFF | (green & 0xFF) << 8);
        xColor.blue = (short)(blue & 0xFF | (blue & 0xFF) << 8);
        this.handle = xColor;
        int xDisplay = device.xDisplay;
        int screen = OS.XDefaultScreen(xDisplay);
        int colormap = OS.XDefaultColormap(xDisplay, screen);
        if (OS.XAllocColor(xDisplay, colormap, xColor) != 0) {
            if (device.colorRefCount != null) {
                XColor colorCopy = new XColor();
                colorCopy.red = xColor.red;
                colorCopy.green = xColor.green;
                colorCopy.blue = xColor.blue;
                colorCopy.pixel = xColor.pixel;
                device.xcolors[colorCopy.pixel] = colorCopy;
                int n = xColor.pixel;
                device.colorRefCount[n] = device.colorRefCount[n] + 1;
            }
            return;
        }
        Visual visual = new Visual();
        OS.memmove(visual, OS.XDefaultVisual(xDisplay, screen), 32);
        int mapEntries = visual.map_entries;
        XColor[] queried = new XColor[mapEntries];
        int[] distances = new int[mapEntries];
        for (i = 0; i < mapEntries; ++i) {
            XColor color = new XColor();
            color.pixel = i;
            queried[i] = color;
            OS.XQueryColor(xDisplay, colormap, color);
            int r = red - (color.red >> 8 & 0xFF);
            int g = green - (color.green >> 8 & 0xFF);
            int b = blue - (color.blue >> 8 & 0xFF);
            distances[i] = r * r + g * g + b * b;
        }
        for (i = 0; i < mapEntries; ++i) {
            int minDist = 196608;
            int minIndex = 0;
            for (int j = 0; j < mapEntries; ++j) {
                if (distances[j] >= minDist) continue;
                minDist = distances[j];
                minIndex = j;
            }
            XColor queriedColor = queried[minIndex];
            XColor osColor = new XColor();
            osColor.red = queriedColor.red;
            osColor.green = queriedColor.green;
            osColor.blue = queriedColor.blue;
            if (OS.XAllocColor(xDisplay, colormap, osColor) != 0) {
                xColor.red = osColor.red;
                xColor.green = osColor.green;
                xColor.blue = osColor.blue;
                xColor.pixel = osColor.pixel;
                if (device.colorRefCount != null) {
                    device.xcolors[osColor.pixel] = osColor;
                    int n = osColor.pixel;
                    device.colorRefCount[n] = device.colorRefCount[n] + 1;
                }
                return;
            }
            distances[minIndex] = 196608;
        }
        XColor osColor = new XColor();
        OS.XAllocColor(xDisplay, colormap, osColor);
        xColor.red = osColor.red;
        xColor.green = osColor.green;
        xColor.blue = osColor.blue;
        xColor.pixel = osColor.pixel;
        if (device.colorRefCount != null) {
            device.xcolors[osColor.pixel] = osColor;
            int n = osColor.pixel;
            device.colorRefCount[n] = device.colorRefCount[n] + 1;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public static Color motif_new(Device device, XColor xColor) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = xColor;
        color.device = device;
        return color;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

